package io.fabric8.openshift.api.model.operatorhub.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class OperatorGroupListBuilder extends OperatorGroupListFluentImpl<OperatorGroupListBuilder> implements VisitableBuilder<OperatorGroupList,OperatorGroupListBuilder> {

    OperatorGroupListFluent<?> fluent;
    Boolean validationEnabled;

    public OperatorGroupListBuilder() { 
        this(true);
    }


    public OperatorGroupListBuilder(Boolean validationEnabled) { 
        this(new OperatorGroupList(), validationEnabled);
    }


    public OperatorGroupListBuilder(OperatorGroupListFluent<?> fluent) { 
        this(fluent, true);
    }


    public OperatorGroupListBuilder(OperatorGroupListFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new OperatorGroupList(), validationEnabled);
    }


    public OperatorGroupListBuilder(OperatorGroupListFluent<?> fluent,OperatorGroupList instance) { 
        this(fluent, instance, true);
    }


    public OperatorGroupListBuilder(OperatorGroupListFluent<?> fluent,OperatorGroupList instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }


    public OperatorGroupListBuilder(OperatorGroupList instance) { 
        this(instance,true);
    }


    public OperatorGroupListBuilder(OperatorGroupList instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }


    public OperatorGroupList build() {
        OperatorGroupList buildable = new OperatorGroupList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        OperatorGroupListBuilder that = (OperatorGroupListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
