package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface APIServiceDescriptionFluent<A extends APIServiceDescriptionFluent<A>> extends Fluent<A> {


    public A addToActionDescriptors(int index,ActionDescriptor item);
    public A setToActionDescriptors(int index,ActionDescriptor item);
    public A addToActionDescriptors(ActionDescriptor... items);
    public A addAllToActionDescriptors(Collection<ActionDescriptor> items);
    public A removeFromActionDescriptors(ActionDescriptor... items);
    public A removeAllFromActionDescriptors(Collection<ActionDescriptor> items);
    public A removeMatchingFromActionDescriptors(io.fabric8.kubernetes.api.builder.Predicate<ActionDescriptorBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildActionDescriptors instead.
 * @return The buildable object.
 */
@Deprecated public List<ActionDescriptor> getActionDescriptors();
    public List<ActionDescriptor> buildActionDescriptors();
    public ActionDescriptor buildActionDescriptor(int index);
    public ActionDescriptor buildFirstActionDescriptor();
    public ActionDescriptor buildLastActionDescriptor();
    public ActionDescriptor buildMatchingActionDescriptor(io.fabric8.kubernetes.api.builder.Predicate<ActionDescriptorBuilder> predicate);
    public Boolean hasMatchingActionDescriptor(io.fabric8.kubernetes.api.builder.Predicate<ActionDescriptorBuilder> predicate);
    public A withActionDescriptors(List<ActionDescriptor> actionDescriptors);
    public A withActionDescriptors(ActionDescriptor... actionDescriptors);
    public Boolean hasActionDescriptors();
    public APIServiceDescriptionFluent.ActionDescriptorsNested<A> addNewActionDescriptor();
    public APIServiceDescriptionFluent.ActionDescriptorsNested<A> addNewActionDescriptorLike(ActionDescriptor item);
    public APIServiceDescriptionFluent.ActionDescriptorsNested<A> setNewActionDescriptorLike(int index,ActionDescriptor item);
    public APIServiceDescriptionFluent.ActionDescriptorsNested<A> editActionDescriptor(int index);
    public APIServiceDescriptionFluent.ActionDescriptorsNested<A> editFirstActionDescriptor();
    public APIServiceDescriptionFluent.ActionDescriptorsNested<A> editLastActionDescriptor();
    public APIServiceDescriptionFluent.ActionDescriptorsNested<A> editMatchingActionDescriptor(io.fabric8.kubernetes.api.builder.Predicate<ActionDescriptorBuilder> predicate);
    public Integer getContainerPort();
    public A withContainerPort(Integer containerPort);
    public Boolean hasContainerPort();
    public String getDeploymentName();
    public A withDeploymentName(String deploymentName);
    public Boolean hasDeploymentName();
    public A withNewDeploymentName(String arg1);
    public A withNewDeploymentName(StringBuilder arg1);
    public A withNewDeploymentName(StringBuffer arg1);
    public String getDescription();
    public A withDescription(String description);
    public Boolean hasDescription();
    public A withNewDescription(String arg1);
    public A withNewDescription(StringBuilder arg1);
    public A withNewDescription(StringBuffer arg1);
    public String getDisplayName();
    public A withDisplayName(String displayName);
    public Boolean hasDisplayName();
    public A withNewDisplayName(String arg1);
    public A withNewDisplayName(StringBuilder arg1);
    public A withNewDisplayName(StringBuffer arg1);
    public String getGroup();
    public A withGroup(String group);
    public Boolean hasGroup();
    public A withNewGroup(String arg1);
    public A withNewGroup(StringBuilder arg1);
    public A withNewGroup(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public String getName();
    public A withName(String name);
    public Boolean hasName();
    public A withNewName(String arg1);
    public A withNewName(StringBuilder arg1);
    public A withNewName(StringBuffer arg1);
    public A addToResources(int index,APIResourceReference item);
    public A setToResources(int index,APIResourceReference item);
    public A addToResources(APIResourceReference... items);
    public A addAllToResources(Collection<APIResourceReference> items);
    public A removeFromResources(APIResourceReference... items);
    public A removeAllFromResources(Collection<APIResourceReference> items);
    public A removeMatchingFromResources(io.fabric8.kubernetes.api.builder.Predicate<APIResourceReferenceBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildResources instead.
 * @return The buildable object.
 */
@Deprecated public List<APIResourceReference> getResources();
    public List<APIResourceReference> buildResources();
    public APIResourceReference buildResource(int index);
    public APIResourceReference buildFirstResource();
    public APIResourceReference buildLastResource();
    public APIResourceReference buildMatchingResource(io.fabric8.kubernetes.api.builder.Predicate<APIResourceReferenceBuilder> predicate);
    public Boolean hasMatchingResource(io.fabric8.kubernetes.api.builder.Predicate<APIResourceReferenceBuilder> predicate);
    public A withResources(List<APIResourceReference> resources);
    public A withResources(APIResourceReference... resources);
    public Boolean hasResources();
    public A addNewResource(String kind,String name,String version);
    public APIServiceDescriptionFluent.ResourcesNested<A> addNewResource();
    public APIServiceDescriptionFluent.ResourcesNested<A> addNewResourceLike(APIResourceReference item);
    public APIServiceDescriptionFluent.ResourcesNested<A> setNewResourceLike(int index,APIResourceReference item);
    public APIServiceDescriptionFluent.ResourcesNested<A> editResource(int index);
    public APIServiceDescriptionFluent.ResourcesNested<A> editFirstResource();
    public APIServiceDescriptionFluent.ResourcesNested<A> editLastResource();
    public APIServiceDescriptionFluent.ResourcesNested<A> editMatchingResource(io.fabric8.kubernetes.api.builder.Predicate<APIResourceReferenceBuilder> predicate);
    public A addToSpecDescriptors(int index,SpecDescriptor item);
    public A setToSpecDescriptors(int index,SpecDescriptor item);
    public A addToSpecDescriptors(SpecDescriptor... items);
    public A addAllToSpecDescriptors(Collection<SpecDescriptor> items);
    public A removeFromSpecDescriptors(SpecDescriptor... items);
    public A removeAllFromSpecDescriptors(Collection<SpecDescriptor> items);
    public A removeMatchingFromSpecDescriptors(io.fabric8.kubernetes.api.builder.Predicate<SpecDescriptorBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildSpecDescriptors instead.
 * @return The buildable object.
 */
@Deprecated public List<SpecDescriptor> getSpecDescriptors();
    public List<SpecDescriptor> buildSpecDescriptors();
    public SpecDescriptor buildSpecDescriptor(int index);
    public SpecDescriptor buildFirstSpecDescriptor();
    public SpecDescriptor buildLastSpecDescriptor();
    public SpecDescriptor buildMatchingSpecDescriptor(io.fabric8.kubernetes.api.builder.Predicate<SpecDescriptorBuilder> predicate);
    public Boolean hasMatchingSpecDescriptor(io.fabric8.kubernetes.api.builder.Predicate<SpecDescriptorBuilder> predicate);
    public A withSpecDescriptors(List<SpecDescriptor> specDescriptors);
    public A withSpecDescriptors(SpecDescriptor... specDescriptors);
    public Boolean hasSpecDescriptors();
    public APIServiceDescriptionFluent.SpecDescriptorsNested<A> addNewSpecDescriptor();
    public APIServiceDescriptionFluent.SpecDescriptorsNested<A> addNewSpecDescriptorLike(SpecDescriptor item);
    public APIServiceDescriptionFluent.SpecDescriptorsNested<A> setNewSpecDescriptorLike(int index,SpecDescriptor item);
    public APIServiceDescriptionFluent.SpecDescriptorsNested<A> editSpecDescriptor(int index);
    public APIServiceDescriptionFluent.SpecDescriptorsNested<A> editFirstSpecDescriptor();
    public APIServiceDescriptionFluent.SpecDescriptorsNested<A> editLastSpecDescriptor();
    public APIServiceDescriptionFluent.SpecDescriptorsNested<A> editMatchingSpecDescriptor(io.fabric8.kubernetes.api.builder.Predicate<SpecDescriptorBuilder> predicate);
    public A addToStatusDescriptors(int index,StatusDescriptor item);
    public A setToStatusDescriptors(int index,StatusDescriptor item);
    public A addToStatusDescriptors(StatusDescriptor... items);
    public A addAllToStatusDescriptors(Collection<StatusDescriptor> items);
    public A removeFromStatusDescriptors(StatusDescriptor... items);
    public A removeAllFromStatusDescriptors(Collection<StatusDescriptor> items);
    public A removeMatchingFromStatusDescriptors(io.fabric8.kubernetes.api.builder.Predicate<StatusDescriptorBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildStatusDescriptors instead.
 * @return The buildable object.
 */
@Deprecated public List<StatusDescriptor> getStatusDescriptors();
    public List<StatusDescriptor> buildStatusDescriptors();
    public StatusDescriptor buildStatusDescriptor(int index);
    public StatusDescriptor buildFirstStatusDescriptor();
    public StatusDescriptor buildLastStatusDescriptor();
    public StatusDescriptor buildMatchingStatusDescriptor(io.fabric8.kubernetes.api.builder.Predicate<StatusDescriptorBuilder> predicate);
    public Boolean hasMatchingStatusDescriptor(io.fabric8.kubernetes.api.builder.Predicate<StatusDescriptorBuilder> predicate);
    public A withStatusDescriptors(List<StatusDescriptor> statusDescriptors);
    public A withStatusDescriptors(StatusDescriptor... statusDescriptors);
    public Boolean hasStatusDescriptors();
    public APIServiceDescriptionFluent.StatusDescriptorsNested<A> addNewStatusDescriptor();
    public APIServiceDescriptionFluent.StatusDescriptorsNested<A> addNewStatusDescriptorLike(StatusDescriptor item);
    public APIServiceDescriptionFluent.StatusDescriptorsNested<A> setNewStatusDescriptorLike(int index,StatusDescriptor item);
    public APIServiceDescriptionFluent.StatusDescriptorsNested<A> editStatusDescriptor(int index);
    public APIServiceDescriptionFluent.StatusDescriptorsNested<A> editFirstStatusDescriptor();
    public APIServiceDescriptionFluent.StatusDescriptorsNested<A> editLastStatusDescriptor();
    public APIServiceDescriptionFluent.StatusDescriptorsNested<A> editMatchingStatusDescriptor(io.fabric8.kubernetes.api.builder.Predicate<StatusDescriptorBuilder> predicate);
    public String getVersion();
    public A withVersion(String version);
    public Boolean hasVersion();
    public A withNewVersion(String arg1);
    public A withNewVersion(StringBuilder arg1);
    public A withNewVersion(StringBuffer arg1);
    public interface ActionDescriptorsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ActionDescriptorFluent<APIServiceDescriptionFluent.ActionDescriptorsNested<N>> {

        public N and();
        public N endActionDescriptor();    }


    public interface ResourcesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,APIResourceReferenceFluent<APIServiceDescriptionFluent.ResourcesNested<N>> {

        public N and();
        public N endResource();    }


    public interface SpecDescriptorsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SpecDescriptorFluent<APIServiceDescriptionFluent.SpecDescriptorsNested<N>> {

        public N and();
        public N endSpecDescriptor();    }


    public interface StatusDescriptorsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,StatusDescriptorFluent<APIServiceDescriptionFluent.StatusDescriptorsNested<N>> {

        public N and();
        public N endStatusDescriptor();    }


}
