
package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.admissionregistration.v1.RuleWithOperations;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.rbac.PolicyRule;
import io.fabric8.kubernetes.api.model.version.Info;
import io.fabric8.openshift.api.model.operatorhub.manifests.PackageManifest;
import io.fabric8.openshift.api.model.operatorhub.v1.OperatorGroup;
import io.fabric8.openshift.api.model.operatorhub.v1.OperatorGroupList;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.CatalogSource;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.CatalogSourceList;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersion;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.ClusterServiceVersionList;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.InstallPlan;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.InstallPlanList;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.Subscription;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.SubscriptionList;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;

@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "APIGroup",
    "APIGroupList",
    "BaseKubernetesList",
    "CatalogSource",
    "CatalogSourceList",
    "ClusterServiceVersion",
    "ClusterServiceVersionList",
    "Deployment",
    "Info",
    "InstallPlan",
    "InstallPlanList",
    "ObjectMeta",
    "OperatorGroup",
    "OperatorGroupList",
    "PackageManifest",
    "Patch",
    "PolicyRule",
    "Quantity",
    "RuleWithOperations",
    "Status",
    "Subscription",
    "SubscriptionList",
    "Time",
    "TypeMeta"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = false, generateBuilderPackage = false, lazyCollectionInitEnabled = false, builderPackage = "io.fabric8.kubernetes.api.builder", inline = {
    @Inline(type = Doneable.class, prefix = "Doneable", value = "done")
}, refs = {
    @BuildableReference(io.fabric8.kubernetes.api.model.ObjectMeta.class),
    @BuildableReference(LabelSelector.class),
    @BuildableReference(Container.class),
    @BuildableReference(PodTemplateSpec.class),
    @BuildableReference(ResourceRequirements.class),
    @BuildableReference(IntOrString.class),
    @BuildableReference(ObjectReference.class),
    @BuildableReference(LocalObjectReference.class),
    @BuildableReference(PersistentVolumeClaim.class)
})
public class KubeSchema {

    /**
     * 
     * 
     */
    @JsonProperty("APIGroup")
    private APIGroup aPIGroup;
    /**
     * 
     * 
     */
    @JsonProperty("APIGroupList")
    private APIGroupList aPIGroupList;
    /**
     * 
     * 
     */
    @JsonProperty("BaseKubernetesList")
    private BaseKubernetesList baseKubernetesList;
    /**
     * 
     * 
     */
    @JsonProperty("CatalogSource")
    private CatalogSource catalogSource;
    /**
     * 
     * 
     */
    @JsonProperty("CatalogSourceList")
    private CatalogSourceList catalogSourceList;
    /**
     * 
     * 
     */
    @JsonProperty("ClusterServiceVersion")
    private ClusterServiceVersion clusterServiceVersion;
    /**
     * 
     * 
     */
    @JsonProperty("ClusterServiceVersionList")
    private ClusterServiceVersionList clusterServiceVersionList;
    /**
     * 
     * 
     */
    @JsonProperty("Deployment")
    private Deployment deployment;
    /**
     * 
     * 
     */
    @JsonProperty("Info")
    private Info info;
    /**
     * 
     * 
     */
    @JsonProperty("InstallPlan")
    private InstallPlan installPlan;
    /**
     * 
     * 
     */
    @JsonProperty("InstallPlanList")
    private InstallPlanList installPlanList;
    /**
     * 
     * 
     */
    @JsonProperty("ObjectMeta")
    private io.fabric8.kubernetes.api.model.ObjectMeta objectMeta;
    /**
     * 
     * 
     */
    @JsonProperty("OperatorGroup")
    private OperatorGroup operatorGroup;
    /**
     * 
     * 
     */
    @JsonProperty("OperatorGroupList")
    private OperatorGroupList operatorGroupList;
    /**
     * 
     * 
     */
    @JsonProperty("PackageManifest")
    private PackageManifest packageManifest;
    /**
     * 
     * 
     */
    @JsonProperty("Patch")
    private Patch patch;
    /**
     * 
     * 
     */
    @JsonProperty("PolicyRule")
    private PolicyRule policyRule;
    /**
     * 
     * 
     */
    @JsonProperty("Quantity")
    private Quantity quantity;
    /**
     * 
     * 
     */
    @JsonProperty("RuleWithOperations")
    private RuleWithOperations ruleWithOperations;
    /**
     * 
     * 
     */
    @JsonProperty("Status")
    private Status status;
    /**
     * 
     * 
     */
    @JsonProperty("Subscription")
    private Subscription subscription;
    /**
     * 
     * 
     */
    @JsonProperty("SubscriptionList")
    private SubscriptionList subscriptionList;
    /**
     * 
     * 
     */
    @JsonProperty("Time")
    private String time;
    /**
     * 
     * 
     */
    @JsonProperty("TypeMeta")
    private TypeMeta typeMeta;
    @JsonIgnore
    private Map<java.lang.String, Object> additionalProperties = new HashMap<java.lang.String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public KubeSchema() {
    }

    /**
     * 
     * @param operatorGroupList
     * @param aPIGroupList
     * @param quantity
     * @param ruleWithOperations
     * @param installPlan
     * @param subscriptionList
     * @param baseKubernetesList
     * @param subscription
     * @param clusterServiceVersionList
     * @param patch
     * @param aPIGroup
     * @param typeMeta
     * @param clusterServiceVersion
     * @param policyRule
     * @param objectMeta
     * @param catalogSourceList
     * @param time
     * @param catalogSource
     * @param operatorGroup
     * @param installPlanList
     * @param packageManifest
     * @param deployment
     * @param info
     * @param status
     */
    public KubeSchema(APIGroup aPIGroup, APIGroupList aPIGroupList, BaseKubernetesList baseKubernetesList, CatalogSource catalogSource, CatalogSourceList catalogSourceList, ClusterServiceVersion clusterServiceVersion, ClusterServiceVersionList clusterServiceVersionList, Deployment deployment, Info info, InstallPlan installPlan, InstallPlanList installPlanList, io.fabric8.kubernetes.api.model.ObjectMeta objectMeta, OperatorGroup operatorGroup, OperatorGroupList operatorGroupList, PackageManifest packageManifest, Patch patch, PolicyRule policyRule, Quantity quantity, RuleWithOperations ruleWithOperations, Status status, Subscription subscription, SubscriptionList subscriptionList, String time, TypeMeta typeMeta) {
        this.aPIGroup = aPIGroup;
        this.aPIGroupList = aPIGroupList;
        this.baseKubernetesList = baseKubernetesList;
        this.catalogSource = catalogSource;
        this.catalogSourceList = catalogSourceList;
        this.clusterServiceVersion = clusterServiceVersion;
        this.clusterServiceVersionList = clusterServiceVersionList;
        this.deployment = deployment;
        this.info = info;
        this.installPlan = installPlan;
        this.installPlanList = installPlanList;
        this.objectMeta = objectMeta;
        this.operatorGroup = operatorGroup;
        this.operatorGroupList = operatorGroupList;
        this.packageManifest = packageManifest;
        this.patch = patch;
        this.policyRule = policyRule;
        this.quantity = quantity;
        this.ruleWithOperations = ruleWithOperations;
        this.status = status;
        this.subscription = subscription;
        this.subscriptionList = subscriptionList;
        this.time = time;
        this.typeMeta = typeMeta;
    }

    /**
     * 
     * 
     * @return
     *     The aPIGroup
     */
    @JsonProperty("APIGroup")
    public APIGroup getAPIGroup() {
        return aPIGroup;
    }

    /**
     * 
     * 
     * @param aPIGroup
     *     The APIGroup
     */
    @JsonProperty("APIGroup")
    public void setAPIGroup(APIGroup aPIGroup) {
        this.aPIGroup = aPIGroup;
    }

    /**
     * 
     * 
     * @return
     *     The aPIGroupList
     */
    @JsonProperty("APIGroupList")
    public APIGroupList getAPIGroupList() {
        return aPIGroupList;
    }

    /**
     * 
     * 
     * @param aPIGroupList
     *     The APIGroupList
     */
    @JsonProperty("APIGroupList")
    public void setAPIGroupList(APIGroupList aPIGroupList) {
        this.aPIGroupList = aPIGroupList;
    }

    /**
     * 
     * 
     * @return
     *     The baseKubernetesList
     */
    @JsonProperty("BaseKubernetesList")
    public BaseKubernetesList getBaseKubernetesList() {
        return baseKubernetesList;
    }

    /**
     * 
     * 
     * @param baseKubernetesList
     *     The BaseKubernetesList
     */
    @JsonProperty("BaseKubernetesList")
    public void setBaseKubernetesList(BaseKubernetesList baseKubernetesList) {
        this.baseKubernetesList = baseKubernetesList;
    }

    /**
     * 
     * 
     * @return
     *     The catalogSource
     */
    @JsonProperty("CatalogSource")
    public CatalogSource getCatalogSource() {
        return catalogSource;
    }

    /**
     * 
     * 
     * @param catalogSource
     *     The CatalogSource
     */
    @JsonProperty("CatalogSource")
    public void setCatalogSource(CatalogSource catalogSource) {
        this.catalogSource = catalogSource;
    }

    /**
     * 
     * 
     * @return
     *     The catalogSourceList
     */
    @JsonProperty("CatalogSourceList")
    public CatalogSourceList getCatalogSourceList() {
        return catalogSourceList;
    }

    /**
     * 
     * 
     * @param catalogSourceList
     *     The CatalogSourceList
     */
    @JsonProperty("CatalogSourceList")
    public void setCatalogSourceList(CatalogSourceList catalogSourceList) {
        this.catalogSourceList = catalogSourceList;
    }

    /**
     * 
     * 
     * @return
     *     The clusterServiceVersion
     */
    @JsonProperty("ClusterServiceVersion")
    public ClusterServiceVersion getClusterServiceVersion() {
        return clusterServiceVersion;
    }

    /**
     * 
     * 
     * @param clusterServiceVersion
     *     The ClusterServiceVersion
     */
    @JsonProperty("ClusterServiceVersion")
    public void setClusterServiceVersion(ClusterServiceVersion clusterServiceVersion) {
        this.clusterServiceVersion = clusterServiceVersion;
    }

    /**
     * 
     * 
     * @return
     *     The clusterServiceVersionList
     */
    @JsonProperty("ClusterServiceVersionList")
    public ClusterServiceVersionList getClusterServiceVersionList() {
        return clusterServiceVersionList;
    }

    /**
     * 
     * 
     * @param clusterServiceVersionList
     *     The ClusterServiceVersionList
     */
    @JsonProperty("ClusterServiceVersionList")
    public void setClusterServiceVersionList(ClusterServiceVersionList clusterServiceVersionList) {
        this.clusterServiceVersionList = clusterServiceVersionList;
    }

    /**
     * 
     * 
     * @return
     *     The deployment
     */
    @JsonProperty("Deployment")
    public Deployment getDeployment() {
        return deployment;
    }

    /**
     * 
     * 
     * @param deployment
     *     The Deployment
     */
    @JsonProperty("Deployment")
    public void setDeployment(Deployment deployment) {
        this.deployment = deployment;
    }

    /**
     * 
     * 
     * @return
     *     The info
     */
    @JsonProperty("Info")
    public Info getInfo() {
        return info;
    }

    /**
     * 
     * 
     * @param info
     *     The Info
     */
    @JsonProperty("Info")
    public void setInfo(Info info) {
        this.info = info;
    }

    /**
     * 
     * 
     * @return
     *     The installPlan
     */
    @JsonProperty("InstallPlan")
    public InstallPlan getInstallPlan() {
        return installPlan;
    }

    /**
     * 
     * 
     * @param installPlan
     *     The InstallPlan
     */
    @JsonProperty("InstallPlan")
    public void setInstallPlan(InstallPlan installPlan) {
        this.installPlan = installPlan;
    }

    /**
     * 
     * 
     * @return
     *     The installPlanList
     */
    @JsonProperty("InstallPlanList")
    public InstallPlanList getInstallPlanList() {
        return installPlanList;
    }

    /**
     * 
     * 
     * @param installPlanList
     *     The InstallPlanList
     */
    @JsonProperty("InstallPlanList")
    public void setInstallPlanList(InstallPlanList installPlanList) {
        this.installPlanList = installPlanList;
    }

    /**
     * 
     * 
     * @return
     *     The objectMeta
     */
    @JsonProperty("ObjectMeta")
    public io.fabric8.kubernetes.api.model.ObjectMeta getObjectMeta() {
        return objectMeta;
    }

    /**
     * 
     * 
     * @param objectMeta
     *     The ObjectMeta
     */
    @JsonProperty("ObjectMeta")
    public void setObjectMeta(io.fabric8.kubernetes.api.model.ObjectMeta objectMeta) {
        this.objectMeta = objectMeta;
    }

    /**
     * 
     * 
     * @return
     *     The operatorGroup
     */
    @JsonProperty("OperatorGroup")
    public OperatorGroup getOperatorGroup() {
        return operatorGroup;
    }

    /**
     * 
     * 
     * @param operatorGroup
     *     The OperatorGroup
     */
    @JsonProperty("OperatorGroup")
    public void setOperatorGroup(OperatorGroup operatorGroup) {
        this.operatorGroup = operatorGroup;
    }

    /**
     * 
     * 
     * @return
     *     The operatorGroupList
     */
    @JsonProperty("OperatorGroupList")
    public OperatorGroupList getOperatorGroupList() {
        return operatorGroupList;
    }

    /**
     * 
     * 
     * @param operatorGroupList
     *     The OperatorGroupList
     */
    @JsonProperty("OperatorGroupList")
    public void setOperatorGroupList(OperatorGroupList operatorGroupList) {
        this.operatorGroupList = operatorGroupList;
    }

    /**
     * 
     * 
     * @return
     *     The packageManifest
     */
    @JsonProperty("PackageManifest")
    public PackageManifest getPackageManifest() {
        return packageManifest;
    }

    /**
     * 
     * 
     * @param packageManifest
     *     The PackageManifest
     */
    @JsonProperty("PackageManifest")
    public void setPackageManifest(PackageManifest packageManifest) {
        this.packageManifest = packageManifest;
    }

    /**
     * 
     * 
     * @return
     *     The patch
     */
    @JsonProperty("Patch")
    public Patch getPatch() {
        return patch;
    }

    /**
     * 
     * 
     * @param patch
     *     The Patch
     */
    @JsonProperty("Patch")
    public void setPatch(Patch patch) {
        this.patch = patch;
    }

    /**
     * 
     * 
     * @return
     *     The policyRule
     */
    @JsonProperty("PolicyRule")
    public PolicyRule getPolicyRule() {
        return policyRule;
    }

    /**
     * 
     * 
     * @param policyRule
     *     The PolicyRule
     */
    @JsonProperty("PolicyRule")
    public void setPolicyRule(PolicyRule policyRule) {
        this.policyRule = policyRule;
    }

    /**
     * 
     * 
     * @return
     *     The quantity
     */
    @JsonProperty("Quantity")
    public Quantity getQuantity() {
        return quantity;
    }

    /**
     * 
     * 
     * @param quantity
     *     The Quantity
     */
    @JsonProperty("Quantity")
    public void setQuantity(Quantity quantity) {
        this.quantity = quantity;
    }

    /**
     * 
     * 
     * @return
     *     The ruleWithOperations
     */
    @JsonProperty("RuleWithOperations")
    public RuleWithOperations getRuleWithOperations() {
        return ruleWithOperations;
    }

    /**
     * 
     * 
     * @param ruleWithOperations
     *     The RuleWithOperations
     */
    @JsonProperty("RuleWithOperations")
    public void setRuleWithOperations(RuleWithOperations ruleWithOperations) {
        this.ruleWithOperations = ruleWithOperations;
    }

    /**
     * 
     * 
     * @return
     *     The status
     */
    @JsonProperty("Status")
    public Status getStatus() {
        return status;
    }

    /**
     * 
     * 
     * @param status
     *     The Status
     */
    @JsonProperty("Status")
    public void setStatus(Status status) {
        this.status = status;
    }

    /**
     * 
     * 
     * @return
     *     The subscription
     */
    @JsonProperty("Subscription")
    public Subscription getSubscription() {
        return subscription;
    }

    /**
     * 
     * 
     * @param subscription
     *     The Subscription
     */
    @JsonProperty("Subscription")
    public void setSubscription(Subscription subscription) {
        this.subscription = subscription;
    }

    /**
     * 
     * 
     * @return
     *     The subscriptionList
     */
    @JsonProperty("SubscriptionList")
    public SubscriptionList getSubscriptionList() {
        return subscriptionList;
    }

    /**
     * 
     * 
     * @param subscriptionList
     *     The SubscriptionList
     */
    @JsonProperty("SubscriptionList")
    public void setSubscriptionList(SubscriptionList subscriptionList) {
        this.subscriptionList = subscriptionList;
    }

    /**
     * 
     * 
     * @return
     *     The time
     */
    @JsonProperty("Time")
    public String getTime() {
        return time;
    }

    /**
     * 
     * 
     * @param time
     *     The Time
     */
    @JsonProperty("Time")
    public void setTime(String time) {
        this.time = time;
    }

    /**
     * 
     * 
     * @return
     *     The typeMeta
     */
    @JsonProperty("TypeMeta")
    public TypeMeta getTypeMeta() {
        return typeMeta;
    }

    /**
     * 
     * 
     * @param typeMeta
     *     The TypeMeta
     */
    @JsonProperty("TypeMeta")
    public void setTypeMeta(TypeMeta typeMeta) {
        this.typeMeta = typeMeta;
    }

    @JsonAnyGetter
    public Map<java.lang.String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(java.lang.String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
