package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;

public class CatalogSourceSpecFluentImpl<A extends CatalogSourceSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements CatalogSourceSpecFluent<A> {

    private String address;
    private String configMap;
    private String description;
    private String displayName;
    private IconBuilder icon;
    private String image;
    private Integer priority;
    private String publisher;
    private List<String> secrets = new ArrayList<String>();
    private String sourceType;
    private UpdateStrategyBuilder updateStrategy;

    public CatalogSourceSpecFluentImpl() { 
    }


    public CatalogSourceSpecFluentImpl(CatalogSourceSpec instance) { 
        this.withAddress(instance.getAddress()); 
        this.withConfigMap(instance.getConfigMap()); 
        this.withDescription(instance.getDescription()); 
        this.withDisplayName(instance.getDisplayName()); 
        this.withIcon(instance.getIcon()); 
        this.withImage(instance.getImage()); 
        this.withPriority(instance.getPriority()); 
        this.withPublisher(instance.getPublisher()); 
        this.withSecrets(instance.getSecrets()); 
        this.withSourceType(instance.getSourceType()); 
        this.withUpdateStrategy(instance.getUpdateStrategy()); 
    }


    public String getAddress() {
        return this.address;
    }

    public A withAddress(String address) {
        this.address=address; return (A) this;
    }

    public Boolean hasAddress() {
        return this.address != null;
    }

    public A withNewAddress(String arg1) {
        return (A)withAddress(new String(arg1));
    }

    public A withNewAddress(StringBuilder arg1) {
        return (A)withAddress(new String(arg1));
    }

    public A withNewAddress(StringBuffer arg1) {
        return (A)withAddress(new String(arg1));
    }

    public String getConfigMap() {
        return this.configMap;
    }

    public A withConfigMap(String configMap) {
        this.configMap=configMap; return (A) this;
    }

    public Boolean hasConfigMap() {
        return this.configMap != null;
    }

    public A withNewConfigMap(String arg1) {
        return (A)withConfigMap(new String(arg1));
    }

    public A withNewConfigMap(StringBuilder arg1) {
        return (A)withConfigMap(new String(arg1));
    }

    public A withNewConfigMap(StringBuffer arg1) {
        return (A)withConfigMap(new String(arg1));
    }

    public String getDescription() {
        return this.description;
    }

    public A withDescription(String description) {
        this.description=description; return (A) this;
    }

    public Boolean hasDescription() {
        return this.description != null;
    }

    public A withNewDescription(String arg1) {
        return (A)withDescription(new String(arg1));
    }

    public A withNewDescription(StringBuilder arg1) {
        return (A)withDescription(new String(arg1));
    }

    public A withNewDescription(StringBuffer arg1) {
        return (A)withDescription(new String(arg1));
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public A withDisplayName(String displayName) {
        this.displayName=displayName; return (A) this;
    }

    public Boolean hasDisplayName() {
        return this.displayName != null;
    }

    public A withNewDisplayName(String arg1) {
        return (A)withDisplayName(new String(arg1));
    }

    public A withNewDisplayName(StringBuilder arg1) {
        return (A)withDisplayName(new String(arg1));
    }

    public A withNewDisplayName(StringBuffer arg1) {
        return (A)withDisplayName(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildIcon instead.
 * @return The buildable object.
 */
@Deprecated public Icon getIcon() {
        return this.icon!=null?this.icon.build():null;
    }

    public Icon buildIcon() {
        return this.icon!=null?this.icon.build():null;
    }

    public A withIcon(Icon icon) {
        _visitables.get("icon").remove(this.icon);
        if (icon!=null){ this.icon= new IconBuilder(icon); _visitables.get("icon").add(this.icon);} return (A) this;
    }

    public Boolean hasIcon() {
        return this.icon != null;
    }

    public A withNewIcon(String base64data,String mediatype) {
        return (A)withIcon(new Icon(base64data, mediatype));
    }

    public CatalogSourceSpecFluent.IconNested<A> withNewIcon() {
        return new IconNestedImpl();
    }

    public CatalogSourceSpecFluent.IconNested<A> withNewIconLike(Icon item) {
        return new IconNestedImpl(item);
    }

    public CatalogSourceSpecFluent.IconNested<A> editIcon() {
        return withNewIconLike(getIcon());
    }

    public CatalogSourceSpecFluent.IconNested<A> editOrNewIcon() {
        return withNewIconLike(getIcon() != null ? getIcon(): new IconBuilder().build());
    }

    public CatalogSourceSpecFluent.IconNested<A> editOrNewIconLike(Icon item) {
        return withNewIconLike(getIcon() != null ? getIcon(): item);
    }

    public String getImage() {
        return this.image;
    }

    public A withImage(String image) {
        this.image=image; return (A) this;
    }

    public Boolean hasImage() {
        return this.image != null;
    }

    public A withNewImage(String arg1) {
        return (A)withImage(new String(arg1));
    }

    public A withNewImage(StringBuilder arg1) {
        return (A)withImage(new String(arg1));
    }

    public A withNewImage(StringBuffer arg1) {
        return (A)withImage(new String(arg1));
    }

    public Integer getPriority() {
        return this.priority;
    }

    public A withPriority(Integer priority) {
        this.priority=priority; return (A) this;
    }

    public Boolean hasPriority() {
        return this.priority != null;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public A withPublisher(String publisher) {
        this.publisher=publisher; return (A) this;
    }

    public Boolean hasPublisher() {
        return this.publisher != null;
    }

    public A withNewPublisher(String arg1) {
        return (A)withPublisher(new String(arg1));
    }

    public A withNewPublisher(StringBuilder arg1) {
        return (A)withPublisher(new String(arg1));
    }

    public A withNewPublisher(StringBuffer arg1) {
        return (A)withPublisher(new String(arg1));
    }

    public A addToSecrets(int index,String item) {
        if (this.secrets == null) {this.secrets = new ArrayList<String>();}
        this.secrets.add(index, item);
        return (A)this;
    }

    public A setToSecrets(int index,String item) {
        if (this.secrets == null) {this.secrets = new ArrayList<String>();}
        this.secrets.set(index, item); return (A)this;
    }

    public A addToSecrets(String... items) {
        if (this.secrets == null) {this.secrets = new ArrayList<String>();}
        for (String item : items) {this.secrets.add(item);} return (A)this;
    }

    public A addAllToSecrets(Collection<String> items) {
        if (this.secrets == null) {this.secrets = new ArrayList<String>();}
        for (String item : items) {this.secrets.add(item);} return (A)this;
    }

    public A removeFromSecrets(String... items) {
        for (String item : items) {if (this.secrets!= null){ this.secrets.remove(item);}} return (A)this;
    }

    public A removeAllFromSecrets(Collection<String> items) {
        for (String item : items) {if (this.secrets!= null){ this.secrets.remove(item);}} return (A)this;
    }

    public List<String> getSecrets() {
        return this.secrets;
    }

    public String getSecret(int index) {
        return this.secrets.get(index);
    }

    public String getFirstSecret() {
        return this.secrets.get(0);
    }

    public String getLastSecret() {
        return this.secrets.get(secrets.size() - 1);
    }

    public String getMatchingSecret(io.fabric8.kubernetes.api.builder.Predicate<String> predicate) {
        for (String item: secrets) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingSecret(io.fabric8.kubernetes.api.builder.Predicate<String> predicate) {
        for (String item: secrets) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withSecrets(List<String> secrets) {
        if (this.secrets != null) { _visitables.get("secrets").removeAll(this.secrets);}
        if (secrets != null) {this.secrets = new ArrayList<String>(); for (String item : secrets){this.addToSecrets(item);}} else { this.secrets = null;} return (A) this;
    }

    public A withSecrets(String... secrets) {
        if (this.secrets != null) {this.secrets.clear();}
        if (secrets != null) {for (String item :secrets){ this.addToSecrets(item);}} return (A) this;
    }

    public Boolean hasSecrets() {
        return secrets != null && !secrets.isEmpty();
    }

    public A addNewSecret(String arg1) {
        return (A)addToSecrets(new String(arg1));
    }

    public A addNewSecret(StringBuilder arg1) {
        return (A)addToSecrets(new String(arg1));
    }

    public A addNewSecret(StringBuffer arg1) {
        return (A)addToSecrets(new String(arg1));
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public A withSourceType(String sourceType) {
        this.sourceType=sourceType; return (A) this;
    }

    public Boolean hasSourceType() {
        return this.sourceType != null;
    }

    public A withNewSourceType(String arg1) {
        return (A)withSourceType(new String(arg1));
    }

    public A withNewSourceType(StringBuilder arg1) {
        return (A)withSourceType(new String(arg1));
    }

    public A withNewSourceType(StringBuffer arg1) {
        return (A)withSourceType(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildUpdateStrategy instead.
 * @return The buildable object.
 */
@Deprecated public UpdateStrategy getUpdateStrategy() {
        return this.updateStrategy!=null?this.updateStrategy.build():null;
    }

    public UpdateStrategy buildUpdateStrategy() {
        return this.updateStrategy!=null?this.updateStrategy.build():null;
    }

    public A withUpdateStrategy(UpdateStrategy updateStrategy) {
        _visitables.get("updateStrategy").remove(this.updateStrategy);
        if (updateStrategy!=null){ this.updateStrategy= new UpdateStrategyBuilder(updateStrategy); _visitables.get("updateStrategy").add(this.updateStrategy);} return (A) this;
    }

    public Boolean hasUpdateStrategy() {
        return this.updateStrategy != null;
    }

    public CatalogSourceSpecFluent.UpdateStrategyNested<A> withNewUpdateStrategy() {
        return new UpdateStrategyNestedImpl();
    }

    public CatalogSourceSpecFluent.UpdateStrategyNested<A> withNewUpdateStrategyLike(UpdateStrategy item) {
        return new UpdateStrategyNestedImpl(item);
    }

    public CatalogSourceSpecFluent.UpdateStrategyNested<A> editUpdateStrategy() {
        return withNewUpdateStrategyLike(getUpdateStrategy());
    }

    public CatalogSourceSpecFluent.UpdateStrategyNested<A> editOrNewUpdateStrategy() {
        return withNewUpdateStrategyLike(getUpdateStrategy() != null ? getUpdateStrategy(): new UpdateStrategyBuilder().build());
    }

    public CatalogSourceSpecFluent.UpdateStrategyNested<A> editOrNewUpdateStrategyLike(UpdateStrategy item) {
        return withNewUpdateStrategyLike(getUpdateStrategy() != null ? getUpdateStrategy(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CatalogSourceSpecFluentImpl that = (CatalogSourceSpecFluentImpl) o;
        if (address != null ? !address.equals(that.address) :that.address != null) return false;
        if (configMap != null ? !configMap.equals(that.configMap) :that.configMap != null) return false;
        if (description != null ? !description.equals(that.description) :that.description != null) return false;
        if (displayName != null ? !displayName.equals(that.displayName) :that.displayName != null) return false;
        if (icon != null ? !icon.equals(that.icon) :that.icon != null) return false;
        if (image != null ? !image.equals(that.image) :that.image != null) return false;
        if (priority != null ? !priority.equals(that.priority) :that.priority != null) return false;
        if (publisher != null ? !publisher.equals(that.publisher) :that.publisher != null) return false;
        if (secrets != null ? !secrets.equals(that.secrets) :that.secrets != null) return false;
        if (sourceType != null ? !sourceType.equals(that.sourceType) :that.sourceType != null) return false;
        if (updateStrategy != null ? !updateStrategy.equals(that.updateStrategy) :that.updateStrategy != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(address,  configMap,  description,  displayName,  icon,  image,  priority,  publisher,  secrets,  sourceType,  updateStrategy,  super.hashCode());
    }

    public class IconNestedImpl<N> extends IconFluentImpl<CatalogSourceSpecFluent.IconNested<N>> implements CatalogSourceSpecFluent.IconNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final IconBuilder builder;

        IconNestedImpl(Icon item) {
            this.builder = new IconBuilder(this, item);
        }

        IconNestedImpl() {
            this.builder = new IconBuilder(this);
        }

        public N and() {
             return (N) CatalogSourceSpecFluentImpl.this.withIcon(builder.build());
        }

        public N endIcon() {
             return and();
        }
    }


    public class UpdateStrategyNestedImpl<N> extends UpdateStrategyFluentImpl<CatalogSourceSpecFluent.UpdateStrategyNested<N>> implements CatalogSourceSpecFluent.UpdateStrategyNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final UpdateStrategyBuilder builder;

        UpdateStrategyNestedImpl(UpdateStrategy item) {
            this.builder = new UpdateStrategyBuilder(this, item);
        }

        UpdateStrategyNestedImpl() {
            this.builder = new UpdateStrategyBuilder(this);
        }

        public N and() {
             return (N) CatalogSourceSpecFluentImpl.this.withUpdateStrategy(builder.build());
        }

        public N endUpdateStrategy() {
             return and();
        }
    }


}
