package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.util.LinkedHashMap;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.Long;
import java.util.Collection;
import java.lang.Class;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import java.util.Map;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.GroupVersionKind;
import java.lang.Deprecated;
import java.util.Iterator;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import java.lang.StringBuffer;

public interface ClusterServiceVersionSpecFluent<A extends ClusterServiceVersionSpecFluent<A>> extends Fluent<A> {


    public A addToAnnotations(String key,String value);
    public A addToAnnotations(Map<String,String> map);
    public A removeFromAnnotations(String key);
    public A removeFromAnnotations(Map<String,String> map);
    public Map<String,String> getAnnotations();
    public A withAnnotations(Map<String,String> annotations);
    public Boolean hasAnnotations();
    
/**
 * This method has been deprecated, please use method buildApiservicedefinitions instead.
 * @return The buildable object.
 */
@Deprecated public APIServiceDefinitions getApiservicedefinitions();
    public APIServiceDefinitions buildApiservicedefinitions();
    public A withApiservicedefinitions(APIServiceDefinitions apiservicedefinitions);
    public Boolean hasApiservicedefinitions();
    public ClusterServiceVersionSpecFluent.ApiservicedefinitionsNested<A> withNewApiservicedefinitions();
    public ClusterServiceVersionSpecFluent.ApiservicedefinitionsNested<A> withNewApiservicedefinitionsLike(APIServiceDefinitions item);
    public ClusterServiceVersionSpecFluent.ApiservicedefinitionsNested<A> editApiservicedefinitions();
    public ClusterServiceVersionSpecFluent.ApiservicedefinitionsNested<A> editOrNewApiservicedefinitions();
    public ClusterServiceVersionSpecFluent.ApiservicedefinitionsNested<A> editOrNewApiservicedefinitionsLike(APIServiceDefinitions item);
    
/**
 * This method has been deprecated, please use method buildCustomresourcedefinitions instead.
 * @return The buildable object.
 */
@Deprecated public CustomResourceDefinitions getCustomresourcedefinitions();
    public CustomResourceDefinitions buildCustomresourcedefinitions();
    public A withCustomresourcedefinitions(CustomResourceDefinitions customresourcedefinitions);
    public Boolean hasCustomresourcedefinitions();
    public ClusterServiceVersionSpecFluent.CustomresourcedefinitionsNested<A> withNewCustomresourcedefinitions();
    public ClusterServiceVersionSpecFluent.CustomresourcedefinitionsNested<A> withNewCustomresourcedefinitionsLike(CustomResourceDefinitions item);
    public ClusterServiceVersionSpecFluent.CustomresourcedefinitionsNested<A> editCustomresourcedefinitions();
    public ClusterServiceVersionSpecFluent.CustomresourcedefinitionsNested<A> editOrNewCustomresourcedefinitions();
    public ClusterServiceVersionSpecFluent.CustomresourcedefinitionsNested<A> editOrNewCustomresourcedefinitionsLike(CustomResourceDefinitions item);
    public String getDescription();
    public A withDescription(String description);
    public Boolean hasDescription();
    public A withNewDescription(String arg1);
    public A withNewDescription(StringBuilder arg1);
    public A withNewDescription(StringBuffer arg1);
    public String getDisplayName();
    public A withDisplayName(String displayName);
    public Boolean hasDisplayName();
    public A withNewDisplayName(String arg1);
    public A withNewDisplayName(StringBuilder arg1);
    public A withNewDisplayName(StringBuffer arg1);
    public A addToIcon(int index,Icon item);
    public A setToIcon(int index,Icon item);
    public A addToIcon(Icon... items);
    public A addAllToIcon(Collection<Icon> items);
    public A removeFromIcon(Icon... items);
    public A removeAllFromIcon(Collection<Icon> items);
    public A removeMatchingFromIcon(io.fabric8.kubernetes.api.builder.Predicate<IconBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildIcon instead.
 * @return The buildable object.
 */
@Deprecated public List<Icon> getIcon();
    public List<Icon> buildIcon();
    public Icon buildIcon(int index);
    public Icon buildFirstIcon();
    public Icon buildLastIcon();
    public Icon buildMatchingIcon(io.fabric8.kubernetes.api.builder.Predicate<IconBuilder> predicate);
    public Boolean hasMatchingIcon(io.fabric8.kubernetes.api.builder.Predicate<IconBuilder> predicate);
    public A withIcon(List<Icon> icon);
    public A withIcon(Icon... icon);
    public Boolean hasIcon();
    public A addNewIcon(String base64data,String mediatype);
    public ClusterServiceVersionSpecFluent.IconNested<A> addNewIcon();
    public ClusterServiceVersionSpecFluent.IconNested<A> addNewIconLike(Icon item);
    public ClusterServiceVersionSpecFluent.IconNested<A> setNewIconLike(int index,Icon item);
    public ClusterServiceVersionSpecFluent.IconNested<A> editIcon(int index);
    public ClusterServiceVersionSpecFluent.IconNested<A> editFirstIcon();
    public ClusterServiceVersionSpecFluent.IconNested<A> editLastIcon();
    public ClusterServiceVersionSpecFluent.IconNested<A> editMatchingIcon(io.fabric8.kubernetes.api.builder.Predicate<IconBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildInstall instead.
 * @return The buildable object.
 */
@Deprecated public NamedInstallStrategy getInstall();
    public NamedInstallStrategy buildInstall();
    public A withInstall(NamedInstallStrategy install);
    public Boolean hasInstall();
    public ClusterServiceVersionSpecFluent.InstallNested<A> withNewInstall();
    public ClusterServiceVersionSpecFluent.InstallNested<A> withNewInstallLike(NamedInstallStrategy item);
    public ClusterServiceVersionSpecFluent.InstallNested<A> editInstall();
    public ClusterServiceVersionSpecFluent.InstallNested<A> editOrNewInstall();
    public ClusterServiceVersionSpecFluent.InstallNested<A> editOrNewInstallLike(NamedInstallStrategy item);
    public A addToInstallModes(int index,InstallMode item);
    public A setToInstallModes(int index,InstallMode item);
    public A addToInstallModes(InstallMode... items);
    public A addAllToInstallModes(Collection<InstallMode> items);
    public A removeFromInstallModes(InstallMode... items);
    public A removeAllFromInstallModes(Collection<InstallMode> items);
    public A removeMatchingFromInstallModes(io.fabric8.kubernetes.api.builder.Predicate<InstallModeBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildInstallModes instead.
 * @return The buildable object.
 */
@Deprecated public List<InstallMode> getInstallModes();
    public List<InstallMode> buildInstallModes();
    public InstallMode buildInstallMode(int index);
    public InstallMode buildFirstInstallMode();
    public InstallMode buildLastInstallMode();
    public InstallMode buildMatchingInstallMode(io.fabric8.kubernetes.api.builder.Predicate<InstallModeBuilder> predicate);
    public Boolean hasMatchingInstallMode(io.fabric8.kubernetes.api.builder.Predicate<InstallModeBuilder> predicate);
    public A withInstallModes(List<InstallMode> installModes);
    public A withInstallModes(InstallMode... installModes);
    public Boolean hasInstallModes();
    public A addNewInstallMode(Boolean supported,String type);
    public ClusterServiceVersionSpecFluent.InstallModesNested<A> addNewInstallMode();
    public ClusterServiceVersionSpecFluent.InstallModesNested<A> addNewInstallModeLike(InstallMode item);
    public ClusterServiceVersionSpecFluent.InstallModesNested<A> setNewInstallModeLike(int index,InstallMode item);
    public ClusterServiceVersionSpecFluent.InstallModesNested<A> editInstallMode(int index);
    public ClusterServiceVersionSpecFluent.InstallModesNested<A> editFirstInstallMode();
    public ClusterServiceVersionSpecFluent.InstallModesNested<A> editLastInstallMode();
    public ClusterServiceVersionSpecFluent.InstallModesNested<A> editMatchingInstallMode(io.fabric8.kubernetes.api.builder.Predicate<InstallModeBuilder> predicate);
    public A addToKeywords(int index,String item);
    public A setToKeywords(int index,String item);
    public A addToKeywords(String... items);
    public A addAllToKeywords(Collection<String> items);
    public A removeFromKeywords(String... items);
    public A removeAllFromKeywords(Collection<String> items);
    public List<String> getKeywords();
    public String getKeyword(int index);
    public String getFirstKeyword();
    public String getLastKeyword();
    public String getMatchingKeyword(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public Boolean hasMatchingKeyword(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withKeywords(List<String> keywords);
    public A withKeywords(String... keywords);
    public Boolean hasKeywords();
    public A addNewKeyword(String arg1);
    public A addNewKeyword(StringBuilder arg1);
    public A addNewKeyword(StringBuffer arg1);
    public A addToLabels(String key,String value);
    public A addToLabels(Map<String,String> map);
    public A removeFromLabels(String key);
    public A removeFromLabels(Map<String,String> map);
    public Map<String,String> getLabels();
    public A withLabels(Map<String,String> labels);
    public Boolean hasLabels();
    public A addToLinks(int index,AppLink item);
    public A setToLinks(int index,AppLink item);
    public A addToLinks(AppLink... items);
    public A addAllToLinks(Collection<AppLink> items);
    public A removeFromLinks(AppLink... items);
    public A removeAllFromLinks(Collection<AppLink> items);
    public A removeMatchingFromLinks(io.fabric8.kubernetes.api.builder.Predicate<AppLinkBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildLinks instead.
 * @return The buildable object.
 */
@Deprecated public List<AppLink> getLinks();
    public List<AppLink> buildLinks();
    public AppLink buildLink(int index);
    public AppLink buildFirstLink();
    public AppLink buildLastLink();
    public AppLink buildMatchingLink(io.fabric8.kubernetes.api.builder.Predicate<AppLinkBuilder> predicate);
    public Boolean hasMatchingLink(io.fabric8.kubernetes.api.builder.Predicate<AppLinkBuilder> predicate);
    public A withLinks(List<AppLink> links);
    public A withLinks(AppLink... links);
    public Boolean hasLinks();
    public A addNewLink(String name,String url);
    public ClusterServiceVersionSpecFluent.LinksNested<A> addNewLink();
    public ClusterServiceVersionSpecFluent.LinksNested<A> addNewLinkLike(AppLink item);
    public ClusterServiceVersionSpecFluent.LinksNested<A> setNewLinkLike(int index,AppLink item);
    public ClusterServiceVersionSpecFluent.LinksNested<A> editLink(int index);
    public ClusterServiceVersionSpecFluent.LinksNested<A> editFirstLink();
    public ClusterServiceVersionSpecFluent.LinksNested<A> editLastLink();
    public ClusterServiceVersionSpecFluent.LinksNested<A> editMatchingLink(io.fabric8.kubernetes.api.builder.Predicate<AppLinkBuilder> predicate);
    public A addToMaintainers(int index,Maintainer item);
    public A setToMaintainers(int index,Maintainer item);
    public A addToMaintainers(Maintainer... items);
    public A addAllToMaintainers(Collection<Maintainer> items);
    public A removeFromMaintainers(Maintainer... items);
    public A removeAllFromMaintainers(Collection<Maintainer> items);
    public A removeMatchingFromMaintainers(io.fabric8.kubernetes.api.builder.Predicate<MaintainerBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildMaintainers instead.
 * @return The buildable object.
 */
@Deprecated public List<Maintainer> getMaintainers();
    public List<Maintainer> buildMaintainers();
    public Maintainer buildMaintainer(int index);
    public Maintainer buildFirstMaintainer();
    public Maintainer buildLastMaintainer();
    public Maintainer buildMatchingMaintainer(io.fabric8.kubernetes.api.builder.Predicate<MaintainerBuilder> predicate);
    public Boolean hasMatchingMaintainer(io.fabric8.kubernetes.api.builder.Predicate<MaintainerBuilder> predicate);
    public A withMaintainers(List<Maintainer> maintainers);
    public A withMaintainers(Maintainer... maintainers);
    public Boolean hasMaintainers();
    public A addNewMaintainer(String email,String name);
    public ClusterServiceVersionSpecFluent.MaintainersNested<A> addNewMaintainer();
    public ClusterServiceVersionSpecFluent.MaintainersNested<A> addNewMaintainerLike(Maintainer item);
    public ClusterServiceVersionSpecFluent.MaintainersNested<A> setNewMaintainerLike(int index,Maintainer item);
    public ClusterServiceVersionSpecFluent.MaintainersNested<A> editMaintainer(int index);
    public ClusterServiceVersionSpecFluent.MaintainersNested<A> editFirstMaintainer();
    public ClusterServiceVersionSpecFluent.MaintainersNested<A> editLastMaintainer();
    public ClusterServiceVersionSpecFluent.MaintainersNested<A> editMatchingMaintainer(io.fabric8.kubernetes.api.builder.Predicate<MaintainerBuilder> predicate);
    public String getMaturity();
    public A withMaturity(String maturity);
    public Boolean hasMaturity();
    public A withNewMaturity(String arg1);
    public A withNewMaturity(StringBuilder arg1);
    public A withNewMaturity(StringBuffer arg1);
    public String getMinKubeVersion();
    public A withMinKubeVersion(String minKubeVersion);
    public Boolean hasMinKubeVersion();
    public A withNewMinKubeVersion(String arg1);
    public A withNewMinKubeVersion(StringBuilder arg1);
    public A withNewMinKubeVersion(StringBuffer arg1);
    public A addToNativeAPIs(int index,GroupVersionKind item);
    public A setToNativeAPIs(int index,GroupVersionKind item);
    public A addToNativeAPIs(GroupVersionKind... items);
    public A addAllToNativeAPIs(Collection<GroupVersionKind> items);
    public A removeFromNativeAPIs(GroupVersionKind... items);
    public A removeAllFromNativeAPIs(Collection<GroupVersionKind> items);
    public List<GroupVersionKind> getNativeAPIs();
    public GroupVersionKind getNativeAPI(int index);
    public GroupVersionKind getFirstNativeAPI();
    public GroupVersionKind getLastNativeAPI();
    public GroupVersionKind getMatchingNativeAPI(io.fabric8.kubernetes.api.builder.Predicate<GroupVersionKind> predicate);
    public Boolean hasMatchingNativeAPI(io.fabric8.kubernetes.api.builder.Predicate<GroupVersionKind> predicate);
    public A withNativeAPIs(List<GroupVersionKind> nativeAPIs);
    public A withNativeAPIs(GroupVersionKind... nativeAPIs);
    public Boolean hasNativeAPIs();
    public A addNewNativeAPI(String group,String kind,String version);
    
/**
 * This method has been deprecated, please use method buildProvider instead.
 * @return The buildable object.
 */
@Deprecated public AppLink getProvider();
    public AppLink buildProvider();
    public A withProvider(AppLink provider);
    public Boolean hasProvider();
    public A withNewProvider(String name,String url);
    public ClusterServiceVersionSpecFluent.ProviderNested<A> withNewProvider();
    public ClusterServiceVersionSpecFluent.ProviderNested<A> withNewProviderLike(AppLink item);
    public ClusterServiceVersionSpecFluent.ProviderNested<A> editProvider();
    public ClusterServiceVersionSpecFluent.ProviderNested<A> editOrNewProvider();
    public ClusterServiceVersionSpecFluent.ProviderNested<A> editOrNewProviderLike(AppLink item);
    public String getReplaces();
    public A withReplaces(String replaces);
    public Boolean hasReplaces();
    public A withNewReplaces(String arg1);
    public A withNewReplaces(StringBuilder arg1);
    public A withNewReplaces(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildSelector instead.
 * @return The buildable object.
 */
@Deprecated public LabelSelector getSelector();
    public LabelSelector buildSelector();
    public A withSelector(LabelSelector selector);
    public Boolean hasSelector();
    public ClusterServiceVersionSpecFluent.SelectorNested<A> withNewSelector();
    public ClusterServiceVersionSpecFluent.SelectorNested<A> withNewSelectorLike(LabelSelector item);
    public ClusterServiceVersionSpecFluent.SelectorNested<A> editSelector();
    public ClusterServiceVersionSpecFluent.SelectorNested<A> editOrNewSelector();
    public ClusterServiceVersionSpecFluent.SelectorNested<A> editOrNewSelectorLike(LabelSelector item);
    
/**
 * This method has been deprecated, please use method buildVersion instead.
 * @return The buildable object.
 */
@Deprecated public OperatorVersion getVersion();
    public OperatorVersion buildVersion();
    public A withVersion(OperatorVersion version);
    public Boolean hasVersion();
    public ClusterServiceVersionSpecFluent.VersionNested<A> withNewVersion();
    public ClusterServiceVersionSpecFluent.VersionNested<A> withNewVersionLike(OperatorVersion item);
    public ClusterServiceVersionSpecFluent.VersionNested<A> editVersion();
    public ClusterServiceVersionSpecFluent.VersionNested<A> editOrNewVersion();
    public ClusterServiceVersionSpecFluent.VersionNested<A> editOrNewVersionLike(OperatorVersion item);
    public A addToWebhookdefinitions(int index,WebhookDescription item);
    public A setToWebhookdefinitions(int index,WebhookDescription item);
    public A addToWebhookdefinitions(WebhookDescription... items);
    public A addAllToWebhookdefinitions(Collection<WebhookDescription> items);
    public A removeFromWebhookdefinitions(WebhookDescription... items);
    public A removeAllFromWebhookdefinitions(Collection<WebhookDescription> items);
    public A removeMatchingFromWebhookdefinitions(io.fabric8.kubernetes.api.builder.Predicate<WebhookDescriptionBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildWebhookdefinitions instead.
 * @return The buildable object.
 */
@Deprecated public List<WebhookDescription> getWebhookdefinitions();
    public List<WebhookDescription> buildWebhookdefinitions();
    public WebhookDescription buildWebhookdefinition(int index);
    public WebhookDescription buildFirstWebhookdefinition();
    public WebhookDescription buildLastWebhookdefinition();
    public WebhookDescription buildMatchingWebhookdefinition(io.fabric8.kubernetes.api.builder.Predicate<WebhookDescriptionBuilder> predicate);
    public Boolean hasMatchingWebhookdefinition(io.fabric8.kubernetes.api.builder.Predicate<WebhookDescriptionBuilder> predicate);
    public A withWebhookdefinitions(List<WebhookDescription> webhookdefinitions);
    public A withWebhookdefinitions(WebhookDescription... webhookdefinitions);
    public Boolean hasWebhookdefinitions();
    public ClusterServiceVersionSpecFluent.WebhookdefinitionsNested<A> addNewWebhookdefinition();
    public ClusterServiceVersionSpecFluent.WebhookdefinitionsNested<A> addNewWebhookdefinitionLike(WebhookDescription item);
    public ClusterServiceVersionSpecFluent.WebhookdefinitionsNested<A> setNewWebhookdefinitionLike(int index,WebhookDescription item);
    public ClusterServiceVersionSpecFluent.WebhookdefinitionsNested<A> editWebhookdefinition(int index);
    public ClusterServiceVersionSpecFluent.WebhookdefinitionsNested<A> editFirstWebhookdefinition();
    public ClusterServiceVersionSpecFluent.WebhookdefinitionsNested<A> editLastWebhookdefinition();
    public ClusterServiceVersionSpecFluent.WebhookdefinitionsNested<A> editMatchingWebhookdefinition(io.fabric8.kubernetes.api.builder.Predicate<WebhookDescriptionBuilder> predicate);
    public interface ApiservicedefinitionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,APIServiceDefinitionsFluent<ClusterServiceVersionSpecFluent.ApiservicedefinitionsNested<N>> {

        public N and();
        public N endApiservicedefinitions();    }


    public interface CustomresourcedefinitionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,CustomResourceDefinitionsFluent<ClusterServiceVersionSpecFluent.CustomresourcedefinitionsNested<N>> {

        public N and();
        public N endCustomresourcedefinitions();    }


    public interface IconNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,IconFluent<ClusterServiceVersionSpecFluent.IconNested<N>> {

        public N and();
        public N endIcon();    }


    public interface InstallNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NamedInstallStrategyFluent<ClusterServiceVersionSpecFluent.InstallNested<N>> {

        public N and();
        public N endInstall();    }


    public interface InstallModesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,InstallModeFluent<ClusterServiceVersionSpecFluent.InstallModesNested<N>> {

        public N and();
        public N endInstallMode();    }


    public interface LinksNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,AppLinkFluent<ClusterServiceVersionSpecFluent.LinksNested<N>> {

        public N and();
        public N endLink();    }


    public interface MaintainersNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,MaintainerFluent<ClusterServiceVersionSpecFluent.MaintainersNested<N>> {

        public N and();
        public N endMaintainer();    }


    public interface ProviderNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,AppLinkFluent<ClusterServiceVersionSpecFluent.ProviderNested<N>> {

        public N and();
        public N endProvider();    }


    public interface SelectorNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,LabelSelectorFluent<ClusterServiceVersionSpecFluent.SelectorNested<N>> {

        public N and();
        public N endSelector();    }


    public interface VersionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OperatorVersionFluent<ClusterServiceVersionSpecFluent.VersionNested<N>> {

        public N and();
        public N endVersion();    }


    public interface WebhookdefinitionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,WebhookDescriptionFluent<ClusterServiceVersionSpecFluent.WebhookdefinitionsNested<N>> {

        public N and();
        public N endWebhookdefinition();    }


}
