package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class InstallModeBuilder extends InstallModeFluentImpl<InstallModeBuilder> implements VisitableBuilder<InstallMode,InstallModeBuilder> {

    InstallModeFluent<?> fluent;
    Boolean validationEnabled;

    public InstallModeBuilder() { 
        this(true);
    }


    public InstallModeBuilder(Boolean validationEnabled) { 
        this(new InstallMode(), validationEnabled);
    }


    public InstallModeBuilder(InstallModeFluent<?> fluent) { 
        this(fluent, true);
    }


    public InstallModeBuilder(InstallModeFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new InstallMode(), validationEnabled);
    }


    public InstallModeBuilder(InstallModeFluent<?> fluent,InstallMode instance) { 
        this(fluent, instance, true);
    }


    public InstallModeBuilder(InstallModeFluent<?> fluent,InstallMode instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withSupported(instance.getSupported()); 
        fluent.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }


    public InstallModeBuilder(InstallMode instance) { 
        this(instance,true);
    }


    public InstallModeBuilder(InstallMode instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withSupported(instance.getSupported()); 
        this.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }


    public InstallMode build() {
        InstallMode buildable = new InstallMode(fluent.isSupported(),fluent.getType());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        InstallModeBuilder that = (InstallModeBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
