package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;

public class StrategyDetailsDeploymentFluentImpl<A extends StrategyDetailsDeploymentFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements StrategyDetailsDeploymentFluent<A> {

    private List<StrategyDeploymentPermissionsBuilder> clusterPermissions =  new ArrayList<StrategyDeploymentPermissionsBuilder>();
    private List<StrategyDeploymentSpecBuilder> deployments =  new ArrayList<StrategyDeploymentSpecBuilder>();
    private List<StrategyDeploymentPermissionsBuilder> permissions =  new ArrayList<StrategyDeploymentPermissionsBuilder>();

    public StrategyDetailsDeploymentFluentImpl() { 
    }


    public StrategyDetailsDeploymentFluentImpl(StrategyDetailsDeployment instance) { 
        this.withClusterPermissions(instance.getClusterPermissions()); 
        this.withDeployments(instance.getDeployments()); 
        this.withPermissions(instance.getPermissions()); 
    }


    public A addToClusterPermissions(int index,StrategyDeploymentPermissions item) {
        if (this.clusterPermissions == null) {this.clusterPermissions = new ArrayList<StrategyDeploymentPermissionsBuilder>();}
        StrategyDeploymentPermissionsBuilder builder = new StrategyDeploymentPermissionsBuilder(item);_visitables.get("clusterPermissions").add(index >= 0 ? index : _visitables.get("clusterPermissions").size(), builder);this.clusterPermissions.add(index >= 0 ? index : clusterPermissions.size(), builder); return (A)this;
    }

    public A setToClusterPermissions(int index,StrategyDeploymentPermissions item) {
        if (this.clusterPermissions == null) {this.clusterPermissions = new ArrayList<StrategyDeploymentPermissionsBuilder>();}
        StrategyDeploymentPermissionsBuilder builder = new StrategyDeploymentPermissionsBuilder(item);
        if (index < 0 || index >= _visitables.get("clusterPermissions").size()) { _visitables.get("clusterPermissions").add(builder); } else { _visitables.get("clusterPermissions").set(index, builder);}
        if (index < 0 || index >= clusterPermissions.size()) { clusterPermissions.add(builder); } else { clusterPermissions.set(index, builder);}
         return (A)this;
    }

    public A addToClusterPermissions(StrategyDeploymentPermissions... items) {
        if (this.clusterPermissions == null) {this.clusterPermissions = new ArrayList<StrategyDeploymentPermissionsBuilder>();}
        for (StrategyDeploymentPermissions item : items) {StrategyDeploymentPermissionsBuilder builder = new StrategyDeploymentPermissionsBuilder(item);_visitables.get("clusterPermissions").add(builder);this.clusterPermissions.add(builder);} return (A)this;
    }

    public A addAllToClusterPermissions(Collection<StrategyDeploymentPermissions> items) {
        if (this.clusterPermissions == null) {this.clusterPermissions = new ArrayList<StrategyDeploymentPermissionsBuilder>();}
        for (StrategyDeploymentPermissions item : items) {StrategyDeploymentPermissionsBuilder builder = new StrategyDeploymentPermissionsBuilder(item);_visitables.get("clusterPermissions").add(builder);this.clusterPermissions.add(builder);} return (A)this;
    }

    public A removeFromClusterPermissions(StrategyDeploymentPermissions... items) {
        for (StrategyDeploymentPermissions item : items) {StrategyDeploymentPermissionsBuilder builder = new StrategyDeploymentPermissionsBuilder(item);_visitables.get("clusterPermissions").remove(builder);if (this.clusterPermissions != null) {this.clusterPermissions.remove(builder);}} return (A)this;
    }

    public A removeAllFromClusterPermissions(Collection<StrategyDeploymentPermissions> items) {
        for (StrategyDeploymentPermissions item : items) {StrategyDeploymentPermissionsBuilder builder = new StrategyDeploymentPermissionsBuilder(item);_visitables.get("clusterPermissions").remove(builder);if (this.clusterPermissions != null) {this.clusterPermissions.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromClusterPermissions(io.fabric8.kubernetes.api.builder.Predicate<StrategyDeploymentPermissionsBuilder> predicate) {
        if (clusterPermissions == null) return (A) this;
        final Iterator<StrategyDeploymentPermissionsBuilder> each = clusterPermissions.iterator();
        final List visitables = _visitables.get("clusterPermissions");
        while (each.hasNext()) {
          StrategyDeploymentPermissionsBuilder builder = each.next();
          if (predicate.apply(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildClusterPermissions instead.
 * @return The buildable object.
 */
@Deprecated public List<StrategyDeploymentPermissions> getClusterPermissions() {
        return build(clusterPermissions);
    }

    public List<StrategyDeploymentPermissions> buildClusterPermissions() {
        return build(clusterPermissions);
    }

    public StrategyDeploymentPermissions buildClusterPermission(int index) {
        return this.clusterPermissions.get(index).build();
    }

    public StrategyDeploymentPermissions buildFirstClusterPermission() {
        return this.clusterPermissions.get(0).build();
    }

    public StrategyDeploymentPermissions buildLastClusterPermission() {
        return this.clusterPermissions.get(clusterPermissions.size() - 1).build();
    }

    public StrategyDeploymentPermissions buildMatchingClusterPermission(io.fabric8.kubernetes.api.builder.Predicate<StrategyDeploymentPermissionsBuilder> predicate) {
        for (StrategyDeploymentPermissionsBuilder item: clusterPermissions) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingClusterPermission(io.fabric8.kubernetes.api.builder.Predicate<StrategyDeploymentPermissionsBuilder> predicate) {
        for (StrategyDeploymentPermissionsBuilder item: clusterPermissions) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withClusterPermissions(List<StrategyDeploymentPermissions> clusterPermissions) {
        if (this.clusterPermissions != null) { _visitables.get("clusterPermissions").removeAll(this.clusterPermissions);}
        if (clusterPermissions != null) {this.clusterPermissions = new ArrayList<StrategyDeploymentPermissionsBuilder>(); for (StrategyDeploymentPermissions item : clusterPermissions){this.addToClusterPermissions(item);}} else { this.clusterPermissions = null;} return (A) this;
    }

    public A withClusterPermissions(StrategyDeploymentPermissions... clusterPermissions) {
        if (this.clusterPermissions != null) {this.clusterPermissions.clear();}
        if (clusterPermissions != null) {for (StrategyDeploymentPermissions item :clusterPermissions){ this.addToClusterPermissions(item);}} return (A) this;
    }

    public Boolean hasClusterPermissions() {
        return clusterPermissions != null && !clusterPermissions.isEmpty();
    }

    public StrategyDetailsDeploymentFluent.ClusterPermissionsNested<A> addNewClusterPermission() {
        return new ClusterPermissionsNestedImpl();
    }

    public StrategyDetailsDeploymentFluent.ClusterPermissionsNested<A> addNewClusterPermissionLike(StrategyDeploymentPermissions item) {
        return new ClusterPermissionsNestedImpl(-1, item);
    }

    public StrategyDetailsDeploymentFluent.ClusterPermissionsNested<A> setNewClusterPermissionLike(int index,StrategyDeploymentPermissions item) {
        return new ClusterPermissionsNestedImpl(index, item);
    }

    public StrategyDetailsDeploymentFluent.ClusterPermissionsNested<A> editClusterPermission(int index) {
        if (clusterPermissions.size() <= index) throw new RuntimeException("Can't edit clusterPermissions. Index exceeds size.");
        return setNewClusterPermissionLike(index, buildClusterPermission(index));
    }

    public StrategyDetailsDeploymentFluent.ClusterPermissionsNested<A> editFirstClusterPermission() {
        if (clusterPermissions.size() == 0) throw new RuntimeException("Can't edit first clusterPermissions. The list is empty.");
        return setNewClusterPermissionLike(0, buildClusterPermission(0));
    }

    public StrategyDetailsDeploymentFluent.ClusterPermissionsNested<A> editLastClusterPermission() {
        int index = clusterPermissions.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last clusterPermissions. The list is empty.");
        return setNewClusterPermissionLike(index, buildClusterPermission(index));
    }

    public StrategyDetailsDeploymentFluent.ClusterPermissionsNested<A> editMatchingClusterPermission(io.fabric8.kubernetes.api.builder.Predicate<StrategyDeploymentPermissionsBuilder> predicate) {
        int index = -1;
        for (int i=0;i<clusterPermissions.size();i++) { 
        if (predicate.apply(clusterPermissions.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching clusterPermissions. No match found.");
        return setNewClusterPermissionLike(index, buildClusterPermission(index));
    }

    public A addToDeployments(int index,StrategyDeploymentSpec item) {
        if (this.deployments == null) {this.deployments = new ArrayList<StrategyDeploymentSpecBuilder>();}
        StrategyDeploymentSpecBuilder builder = new StrategyDeploymentSpecBuilder(item);_visitables.get("deployments").add(index >= 0 ? index : _visitables.get("deployments").size(), builder);this.deployments.add(index >= 0 ? index : deployments.size(), builder); return (A)this;
    }

    public A setToDeployments(int index,StrategyDeploymentSpec item) {
        if (this.deployments == null) {this.deployments = new ArrayList<StrategyDeploymentSpecBuilder>();}
        StrategyDeploymentSpecBuilder builder = new StrategyDeploymentSpecBuilder(item);
        if (index < 0 || index >= _visitables.get("deployments").size()) { _visitables.get("deployments").add(builder); } else { _visitables.get("deployments").set(index, builder);}
        if (index < 0 || index >= deployments.size()) { deployments.add(builder); } else { deployments.set(index, builder);}
         return (A)this;
    }

    public A addToDeployments(StrategyDeploymentSpec... items) {
        if (this.deployments == null) {this.deployments = new ArrayList<StrategyDeploymentSpecBuilder>();}
        for (StrategyDeploymentSpec item : items) {StrategyDeploymentSpecBuilder builder = new StrategyDeploymentSpecBuilder(item);_visitables.get("deployments").add(builder);this.deployments.add(builder);} return (A)this;
    }

    public A addAllToDeployments(Collection<StrategyDeploymentSpec> items) {
        if (this.deployments == null) {this.deployments = new ArrayList<StrategyDeploymentSpecBuilder>();}
        for (StrategyDeploymentSpec item : items) {StrategyDeploymentSpecBuilder builder = new StrategyDeploymentSpecBuilder(item);_visitables.get("deployments").add(builder);this.deployments.add(builder);} return (A)this;
    }

    public A removeFromDeployments(StrategyDeploymentSpec... items) {
        for (StrategyDeploymentSpec item : items) {StrategyDeploymentSpecBuilder builder = new StrategyDeploymentSpecBuilder(item);_visitables.get("deployments").remove(builder);if (this.deployments != null) {this.deployments.remove(builder);}} return (A)this;
    }

    public A removeAllFromDeployments(Collection<StrategyDeploymentSpec> items) {
        for (StrategyDeploymentSpec item : items) {StrategyDeploymentSpecBuilder builder = new StrategyDeploymentSpecBuilder(item);_visitables.get("deployments").remove(builder);if (this.deployments != null) {this.deployments.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromDeployments(io.fabric8.kubernetes.api.builder.Predicate<StrategyDeploymentSpecBuilder> predicate) {
        if (deployments == null) return (A) this;
        final Iterator<StrategyDeploymentSpecBuilder> each = deployments.iterator();
        final List visitables = _visitables.get("deployments");
        while (each.hasNext()) {
          StrategyDeploymentSpecBuilder builder = each.next();
          if (predicate.apply(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildDeployments instead.
 * @return The buildable object.
 */
@Deprecated public List<StrategyDeploymentSpec> getDeployments() {
        return build(deployments);
    }

    public List<StrategyDeploymentSpec> buildDeployments() {
        return build(deployments);
    }

    public StrategyDeploymentSpec buildDeployment(int index) {
        return this.deployments.get(index).build();
    }

    public StrategyDeploymentSpec buildFirstDeployment() {
        return this.deployments.get(0).build();
    }

    public StrategyDeploymentSpec buildLastDeployment() {
        return this.deployments.get(deployments.size() - 1).build();
    }

    public StrategyDeploymentSpec buildMatchingDeployment(io.fabric8.kubernetes.api.builder.Predicate<StrategyDeploymentSpecBuilder> predicate) {
        for (StrategyDeploymentSpecBuilder item: deployments) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingDeployment(io.fabric8.kubernetes.api.builder.Predicate<StrategyDeploymentSpecBuilder> predicate) {
        for (StrategyDeploymentSpecBuilder item: deployments) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withDeployments(List<StrategyDeploymentSpec> deployments) {
        if (this.deployments != null) { _visitables.get("deployments").removeAll(this.deployments);}
        if (deployments != null) {this.deployments = new ArrayList<StrategyDeploymentSpecBuilder>(); for (StrategyDeploymentSpec item : deployments){this.addToDeployments(item);}} else { this.deployments = null;} return (A) this;
    }

    public A withDeployments(StrategyDeploymentSpec... deployments) {
        if (this.deployments != null) {this.deployments.clear();}
        if (deployments != null) {for (StrategyDeploymentSpec item :deployments){ this.addToDeployments(item);}} return (A) this;
    }

    public Boolean hasDeployments() {
        return deployments != null && !deployments.isEmpty();
    }

    public StrategyDetailsDeploymentFluent.DeploymentsNested<A> addNewDeployment() {
        return new DeploymentsNestedImpl();
    }

    public StrategyDetailsDeploymentFluent.DeploymentsNested<A> addNewDeploymentLike(StrategyDeploymentSpec item) {
        return new DeploymentsNestedImpl(-1, item);
    }

    public StrategyDetailsDeploymentFluent.DeploymentsNested<A> setNewDeploymentLike(int index,StrategyDeploymentSpec item) {
        return new DeploymentsNestedImpl(index, item);
    }

    public StrategyDetailsDeploymentFluent.DeploymentsNested<A> editDeployment(int index) {
        if (deployments.size() <= index) throw new RuntimeException("Can't edit deployments. Index exceeds size.");
        return setNewDeploymentLike(index, buildDeployment(index));
    }

    public StrategyDetailsDeploymentFluent.DeploymentsNested<A> editFirstDeployment() {
        if (deployments.size() == 0) throw new RuntimeException("Can't edit first deployments. The list is empty.");
        return setNewDeploymentLike(0, buildDeployment(0));
    }

    public StrategyDetailsDeploymentFluent.DeploymentsNested<A> editLastDeployment() {
        int index = deployments.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last deployments. The list is empty.");
        return setNewDeploymentLike(index, buildDeployment(index));
    }

    public StrategyDetailsDeploymentFluent.DeploymentsNested<A> editMatchingDeployment(io.fabric8.kubernetes.api.builder.Predicate<StrategyDeploymentSpecBuilder> predicate) {
        int index = -1;
        for (int i=0;i<deployments.size();i++) { 
        if (predicate.apply(deployments.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching deployments. No match found.");
        return setNewDeploymentLike(index, buildDeployment(index));
    }

    public A addToPermissions(int index,StrategyDeploymentPermissions item) {
        if (this.permissions == null) {this.permissions = new ArrayList<StrategyDeploymentPermissionsBuilder>();}
        StrategyDeploymentPermissionsBuilder builder = new StrategyDeploymentPermissionsBuilder(item);_visitables.get("permissions").add(index >= 0 ? index : _visitables.get("permissions").size(), builder);this.permissions.add(index >= 0 ? index : permissions.size(), builder); return (A)this;
    }

    public A setToPermissions(int index,StrategyDeploymentPermissions item) {
        if (this.permissions == null) {this.permissions = new ArrayList<StrategyDeploymentPermissionsBuilder>();}
        StrategyDeploymentPermissionsBuilder builder = new StrategyDeploymentPermissionsBuilder(item);
        if (index < 0 || index >= _visitables.get("permissions").size()) { _visitables.get("permissions").add(builder); } else { _visitables.get("permissions").set(index, builder);}
        if (index < 0 || index >= permissions.size()) { permissions.add(builder); } else { permissions.set(index, builder);}
         return (A)this;
    }

    public A addToPermissions(StrategyDeploymentPermissions... items) {
        if (this.permissions == null) {this.permissions = new ArrayList<StrategyDeploymentPermissionsBuilder>();}
        for (StrategyDeploymentPermissions item : items) {StrategyDeploymentPermissionsBuilder builder = new StrategyDeploymentPermissionsBuilder(item);_visitables.get("permissions").add(builder);this.permissions.add(builder);} return (A)this;
    }

    public A addAllToPermissions(Collection<StrategyDeploymentPermissions> items) {
        if (this.permissions == null) {this.permissions = new ArrayList<StrategyDeploymentPermissionsBuilder>();}
        for (StrategyDeploymentPermissions item : items) {StrategyDeploymentPermissionsBuilder builder = new StrategyDeploymentPermissionsBuilder(item);_visitables.get("permissions").add(builder);this.permissions.add(builder);} return (A)this;
    }

    public A removeFromPermissions(StrategyDeploymentPermissions... items) {
        for (StrategyDeploymentPermissions item : items) {StrategyDeploymentPermissionsBuilder builder = new StrategyDeploymentPermissionsBuilder(item);_visitables.get("permissions").remove(builder);if (this.permissions != null) {this.permissions.remove(builder);}} return (A)this;
    }

    public A removeAllFromPermissions(Collection<StrategyDeploymentPermissions> items) {
        for (StrategyDeploymentPermissions item : items) {StrategyDeploymentPermissionsBuilder builder = new StrategyDeploymentPermissionsBuilder(item);_visitables.get("permissions").remove(builder);if (this.permissions != null) {this.permissions.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromPermissions(io.fabric8.kubernetes.api.builder.Predicate<StrategyDeploymentPermissionsBuilder> predicate) {
        if (permissions == null) return (A) this;
        final Iterator<StrategyDeploymentPermissionsBuilder> each = permissions.iterator();
        final List visitables = _visitables.get("permissions");
        while (each.hasNext()) {
          StrategyDeploymentPermissionsBuilder builder = each.next();
          if (predicate.apply(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildPermissions instead.
 * @return The buildable object.
 */
@Deprecated public List<StrategyDeploymentPermissions> getPermissions() {
        return build(permissions);
    }

    public List<StrategyDeploymentPermissions> buildPermissions() {
        return build(permissions);
    }

    public StrategyDeploymentPermissions buildPermission(int index) {
        return this.permissions.get(index).build();
    }

    public StrategyDeploymentPermissions buildFirstPermission() {
        return this.permissions.get(0).build();
    }

    public StrategyDeploymentPermissions buildLastPermission() {
        return this.permissions.get(permissions.size() - 1).build();
    }

    public StrategyDeploymentPermissions buildMatchingPermission(io.fabric8.kubernetes.api.builder.Predicate<StrategyDeploymentPermissionsBuilder> predicate) {
        for (StrategyDeploymentPermissionsBuilder item: permissions) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingPermission(io.fabric8.kubernetes.api.builder.Predicate<StrategyDeploymentPermissionsBuilder> predicate) {
        for (StrategyDeploymentPermissionsBuilder item: permissions) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withPermissions(List<StrategyDeploymentPermissions> permissions) {
        if (this.permissions != null) { _visitables.get("permissions").removeAll(this.permissions);}
        if (permissions != null) {this.permissions = new ArrayList<StrategyDeploymentPermissionsBuilder>(); for (StrategyDeploymentPermissions item : permissions){this.addToPermissions(item);}} else { this.permissions = null;} return (A) this;
    }

    public A withPermissions(StrategyDeploymentPermissions... permissions) {
        if (this.permissions != null) {this.permissions.clear();}
        if (permissions != null) {for (StrategyDeploymentPermissions item :permissions){ this.addToPermissions(item);}} return (A) this;
    }

    public Boolean hasPermissions() {
        return permissions != null && !permissions.isEmpty();
    }

    public StrategyDetailsDeploymentFluent.PermissionsNested<A> addNewPermission() {
        return new PermissionsNestedImpl();
    }

    public StrategyDetailsDeploymentFluent.PermissionsNested<A> addNewPermissionLike(StrategyDeploymentPermissions item) {
        return new PermissionsNestedImpl(-1, item);
    }

    public StrategyDetailsDeploymentFluent.PermissionsNested<A> setNewPermissionLike(int index,StrategyDeploymentPermissions item) {
        return new PermissionsNestedImpl(index, item);
    }

    public StrategyDetailsDeploymentFluent.PermissionsNested<A> editPermission(int index) {
        if (permissions.size() <= index) throw new RuntimeException("Can't edit permissions. Index exceeds size.");
        return setNewPermissionLike(index, buildPermission(index));
    }

    public StrategyDetailsDeploymentFluent.PermissionsNested<A> editFirstPermission() {
        if (permissions.size() == 0) throw new RuntimeException("Can't edit first permissions. The list is empty.");
        return setNewPermissionLike(0, buildPermission(0));
    }

    public StrategyDetailsDeploymentFluent.PermissionsNested<A> editLastPermission() {
        int index = permissions.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last permissions. The list is empty.");
        return setNewPermissionLike(index, buildPermission(index));
    }

    public StrategyDetailsDeploymentFluent.PermissionsNested<A> editMatchingPermission(io.fabric8.kubernetes.api.builder.Predicate<StrategyDeploymentPermissionsBuilder> predicate) {
        int index = -1;
        for (int i=0;i<permissions.size();i++) { 
        if (predicate.apply(permissions.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching permissions. No match found.");
        return setNewPermissionLike(index, buildPermission(index));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        StrategyDetailsDeploymentFluentImpl that = (StrategyDetailsDeploymentFluentImpl) o;
        if (clusterPermissions != null ? !clusterPermissions.equals(that.clusterPermissions) :that.clusterPermissions != null) return false;
        if (deployments != null ? !deployments.equals(that.deployments) :that.deployments != null) return false;
        if (permissions != null ? !permissions.equals(that.permissions) :that.permissions != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(clusterPermissions,  deployments,  permissions,  super.hashCode());
    }

    public class ClusterPermissionsNestedImpl<N> extends StrategyDeploymentPermissionsFluentImpl<StrategyDetailsDeploymentFluent.ClusterPermissionsNested<N>> implements StrategyDetailsDeploymentFluent.ClusterPermissionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final StrategyDeploymentPermissionsBuilder builder;
        private final int index;

        ClusterPermissionsNestedImpl(int index,StrategyDeploymentPermissions item) {
            this.index = index;
            this.builder = new StrategyDeploymentPermissionsBuilder(this, item);
        }

        ClusterPermissionsNestedImpl() {
            this.index = -1;
            this.builder = new StrategyDeploymentPermissionsBuilder(this);
        }

        public N and() {
             return (N) StrategyDetailsDeploymentFluentImpl.this.setToClusterPermissions(index,builder.build());
        }

        public N endClusterPermission() {
             return and();
        }
    }


    public class DeploymentsNestedImpl<N> extends StrategyDeploymentSpecFluentImpl<StrategyDetailsDeploymentFluent.DeploymentsNested<N>> implements StrategyDetailsDeploymentFluent.DeploymentsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final StrategyDeploymentSpecBuilder builder;
        private final int index;

        DeploymentsNestedImpl(int index,StrategyDeploymentSpec item) {
            this.index = index;
            this.builder = new StrategyDeploymentSpecBuilder(this, item);
        }

        DeploymentsNestedImpl() {
            this.index = -1;
            this.builder = new StrategyDeploymentSpecBuilder(this);
        }

        public N and() {
             return (N) StrategyDetailsDeploymentFluentImpl.this.setToDeployments(index,builder.build());
        }

        public N endDeployment() {
             return and();
        }
    }


    public class PermissionsNestedImpl<N> extends StrategyDeploymentPermissionsFluentImpl<StrategyDetailsDeploymentFluent.PermissionsNested<N>> implements StrategyDetailsDeploymentFluent.PermissionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final StrategyDeploymentPermissionsBuilder builder;
        private final int index;

        PermissionsNestedImpl(int index,StrategyDeploymentPermissions item) {
            this.index = index;
            this.builder = new StrategyDeploymentPermissionsBuilder(this, item);
        }

        PermissionsNestedImpl() {
            this.index = -1;
            this.builder = new StrategyDeploymentPermissionsBuilder(this);
        }

        public N and() {
             return (N) StrategyDetailsDeploymentFluentImpl.this.setToPermissions(index,builder.build());
        }

        public N endPermission() {
             return and();
        }
    }


}
