package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class StepFluentImpl<A extends StepFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements StepFluent<A> {

    private String resolving;
    private StepResourceBuilder resource;
    private String status;

    public StepFluentImpl() {
    }

    public StepFluentImpl(Step instance) {
        this.withResolving(instance.getResolving()); 
        this.withResource(instance.getResource()); 
        this.withStatus(instance.getStatus()); 
    }

    public String getResolving() {
        return this.resolving;
    }

    public A withResolving(String resolving) {
        this.resolving=resolving; return (A) this;
    }

    public Boolean hasResolving() {
        return this.resolving != null;
    }

    public A withNewResolving(String arg1) {
        return (A)withResolving(new String(arg1));
    }

    public A withNewResolving(StringBuilder arg1) {
        return (A)withResolving(new String(arg1));
    }

    public A withNewResolving(StringBuffer arg1) {
        return (A)withResolving(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildResource instead.
 * @return The buildable object.
 */
@Deprecated public StepResource getResource() {
        return this.resource!=null?this.resource.build():null;
    }

    public StepResource buildResource() {
        return this.resource!=null?this.resource.build():null;
    }

    public A withResource(StepResource resource) {
        _visitables.get("resource").remove(this.resource);
        if (resource!=null){ this.resource= new StepResourceBuilder(resource); _visitables.get("resource").add(this.resource);} return (A) this;
    }

    public Boolean hasResource() {
        return this.resource != null;
    }

    public StepFluent.ResourceNested<A> withNewResource() {
        return new ResourceNestedImpl();
    }

    public StepFluent.ResourceNested<A> withNewResourceLike(StepResource item) {
        return new ResourceNestedImpl(item);
    }

    public StepFluent.ResourceNested<A> editResource() {
        return withNewResourceLike(getResource());
    }

    public StepFluent.ResourceNested<A> editOrNewResource() {
        return withNewResourceLike(getResource() != null ? getResource(): new StepResourceBuilder().build());
    }

    public StepFluent.ResourceNested<A> editOrNewResourceLike(StepResource item) {
        return withNewResourceLike(getResource() != null ? getResource(): item);
    }

    public String getStatus() {
        return this.status;
    }

    public A withStatus(String status) {
        this.status=status; return (A) this;
    }

    public Boolean hasStatus() {
        return this.status != null;
    }

    public A withNewStatus(String arg1) {
        return (A)withStatus(new String(arg1));
    }

    public A withNewStatus(StringBuilder arg1) {
        return (A)withStatus(new String(arg1));
    }

    public A withNewStatus(StringBuffer arg1) {
        return (A)withStatus(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        StepFluentImpl that = (StepFluentImpl) o;
        if (resolving != null ? !resolving.equals(that.resolving) :that.resolving != null) return false;
        if (resource != null ? !resource.equals(that.resource) :that.resource != null) return false;
        if (status != null ? !status.equals(that.status) :that.status != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(resolving,  resource,  status,  super.hashCode());
    }

    public class ResourceNestedImpl<N> extends StepResourceFluentImpl<StepFluent.ResourceNested<N>> implements StepFluent.ResourceNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final StepResourceBuilder builder;

            ResourceNestedImpl(StepResource item) {
                this.builder = new StepResourceBuilder(this, item);
                        
            }

            ResourceNestedImpl() {
                this.builder = new StepResourceBuilder(this);
                        
            }

            public N and() {
                return (N) StepFluentImpl.this.withResource(builder.build());
            }

            public N endResource() {
                return and();
            }
    }


}
