package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class SubscriptionConditionBuilder extends SubscriptionConditionFluentImpl<SubscriptionConditionBuilder> implements VisitableBuilder<SubscriptionCondition,SubscriptionConditionBuilder> {

    SubscriptionConditionFluent<?> fluent;
    Boolean validationEnabled;

    public SubscriptionConditionBuilder() {
        this(true);
    }

    public SubscriptionConditionBuilder(Boolean validationEnabled) {
        this(new SubscriptionCondition(), validationEnabled);
    }

    public SubscriptionConditionBuilder(SubscriptionConditionFluent<?> fluent) {
        this(fluent, true);
    }

    public SubscriptionConditionBuilder(SubscriptionConditionFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new SubscriptionCondition(), validationEnabled);
    }

    public SubscriptionConditionBuilder(SubscriptionConditionFluent<?> fluent,SubscriptionCondition instance) {
        this(fluent, instance, true);
    }

    public SubscriptionConditionBuilder(SubscriptionConditionFluent<?> fluent,SubscriptionCondition instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withLastHeartbeatTime(instance.getLastHeartbeatTime()); 
        fluent.withLastTransitionTime(instance.getLastTransitionTime()); 
        fluent.withMessage(instance.getMessage()); 
        fluent.withReason(instance.getReason()); 
        fluent.withStatus(instance.getStatus()); 
        fluent.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }

    public SubscriptionConditionBuilder(SubscriptionCondition instance) {
        this(instance,true);
    }

    public SubscriptionConditionBuilder(SubscriptionCondition instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withLastHeartbeatTime(instance.getLastHeartbeatTime()); 
        this.withLastTransitionTime(instance.getLastTransitionTime()); 
        this.withMessage(instance.getMessage()); 
        this.withReason(instance.getReason()); 
        this.withStatus(instance.getStatus()); 
        this.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }

    public SubscriptionCondition build() {
        SubscriptionCondition buildable = new SubscriptionCondition(fluent.getLastHeartbeatTime(),fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        SubscriptionConditionBuilder that = (SubscriptionConditionBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
