package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ClusterServiceVersionListBuilder extends ClusterServiceVersionListFluentImpl<ClusterServiceVersionListBuilder> implements VisitableBuilder<ClusterServiceVersionList,ClusterServiceVersionListBuilder> {

    ClusterServiceVersionListFluent<?> fluent;
    Boolean validationEnabled;

    public ClusterServiceVersionListBuilder() {
        this(true);
    }

    public ClusterServiceVersionListBuilder(Boolean validationEnabled) {
        this(new ClusterServiceVersionList(), validationEnabled);
    }

    public ClusterServiceVersionListBuilder(ClusterServiceVersionListFluent<?> fluent) {
        this(fluent, true);
    }

    public ClusterServiceVersionListBuilder(ClusterServiceVersionListFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new ClusterServiceVersionList(), validationEnabled);
    }

    public ClusterServiceVersionListBuilder(ClusterServiceVersionListFluent<?> fluent,ClusterServiceVersionList instance) {
        this(fluent, instance, true);
    }

    public ClusterServiceVersionListBuilder(ClusterServiceVersionListFluent<?> fluent,ClusterServiceVersionList instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public ClusterServiceVersionListBuilder(ClusterServiceVersionList instance) {
        this(instance,true);
    }

    public ClusterServiceVersionListBuilder(ClusterServiceVersionList instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public ClusterServiceVersionList build() {
        ClusterServiceVersionList buildable = new ClusterServiceVersionList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ClusterServiceVersionListBuilder that = (ClusterServiceVersionListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
