package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class CustomResourceDefinitionsBuilder extends CustomResourceDefinitionsFluentImpl<CustomResourceDefinitionsBuilder> implements VisitableBuilder<CustomResourceDefinitions,CustomResourceDefinitionsBuilder> {

    CustomResourceDefinitionsFluent<?> fluent;
    Boolean validationEnabled;

    public CustomResourceDefinitionsBuilder() {
        this(true);
    }

    public CustomResourceDefinitionsBuilder(Boolean validationEnabled) {
        this(new CustomResourceDefinitions(), validationEnabled);
    }

    public CustomResourceDefinitionsBuilder(CustomResourceDefinitionsFluent<?> fluent) {
        this(fluent, true);
    }

    public CustomResourceDefinitionsBuilder(CustomResourceDefinitionsFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new CustomResourceDefinitions(), validationEnabled);
    }

    public CustomResourceDefinitionsBuilder(CustomResourceDefinitionsFluent<?> fluent,CustomResourceDefinitions instance) {
        this(fluent, instance, true);
    }

    public CustomResourceDefinitionsBuilder(CustomResourceDefinitionsFluent<?> fluent,CustomResourceDefinitions instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withOwned(instance.getOwned()); 
        fluent.withRequired(instance.getRequired()); 
        this.validationEnabled = validationEnabled; 
    }

    public CustomResourceDefinitionsBuilder(CustomResourceDefinitions instance) {
        this(instance,true);
    }

    public CustomResourceDefinitionsBuilder(CustomResourceDefinitions instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withOwned(instance.getOwned()); 
        this.withRequired(instance.getRequired()); 
        this.validationEnabled = validationEnabled; 
    }

    public CustomResourceDefinitions build() {
        CustomResourceDefinitions buildable = new CustomResourceDefinitions(fluent.getOwned(),fluent.getRequired());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        CustomResourceDefinitionsBuilder that = (CustomResourceDefinitionsBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
