package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ClusterServiceVersionBuilder extends ClusterServiceVersionFluentImpl<ClusterServiceVersionBuilder> implements VisitableBuilder<ClusterServiceVersion,ClusterServiceVersionBuilder> {

    ClusterServiceVersionFluent<?> fluent;
    Boolean validationEnabled;

    public ClusterServiceVersionBuilder() {
        this(true);
    }

    public ClusterServiceVersionBuilder(Boolean validationEnabled) {
        this(new ClusterServiceVersion(), validationEnabled);
    }

    public ClusterServiceVersionBuilder(ClusterServiceVersionFluent<?> fluent) {
        this(fluent, true);
    }

    public ClusterServiceVersionBuilder(ClusterServiceVersionFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new ClusterServiceVersion(), validationEnabled);
    }

    public ClusterServiceVersionBuilder(ClusterServiceVersionFluent<?> fluent,ClusterServiceVersion instance) {
        this(fluent, instance, true);
    }

    public ClusterServiceVersionBuilder(ClusterServiceVersionFluent<?> fluent,ClusterServiceVersion instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        fluent.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public ClusterServiceVersionBuilder(ClusterServiceVersion instance) {
        this(instance,true);
    }

    public ClusterServiceVersionBuilder(ClusterServiceVersion instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public ClusterServiceVersion build() {
        ClusterServiceVersion buildable = new ClusterServiceVersion(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ClusterServiceVersionBuilder that = (ClusterServiceVersionBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
