package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface StatusDescriptorFluent<A extends StatusDescriptorFluent<A>> extends Fluent<A> {


    public String getDescription();
    public A withDescription(String description);
    public Boolean hasDescription();
    public A withNewDescription(String arg1);
    public A withNewDescription(StringBuilder arg1);
    public A withNewDescription(StringBuffer arg1);
    public String getDisplayName();
    public A withDisplayName(String displayName);
    public Boolean hasDisplayName();
    public A withNewDisplayName(String arg1);
    public A withNewDisplayName(StringBuilder arg1);
    public A withNewDisplayName(StringBuffer arg1);
    public String getPath();
    public A withPath(String path);
    public Boolean hasPath();
    public A withNewPath(String arg1);
    public A withNewPath(StringBuilder arg1);
    public A withNewPath(StringBuffer arg1);
    public String getValue();
    public A withValue(String value);
    public Boolean hasValue();
    public A withNewValue(String arg1);
    public A withNewValue(StringBuilder arg1);
    public A withNewValue(StringBuffer arg1);
    public A addToXDescriptors(int index,String item);
    public A setToXDescriptors(int index,String item);
    public A addToXDescriptors(String... items);
    public A addAllToXDescriptors(Collection<String> items);
    public A removeFromXDescriptors(String... items);
    public A removeAllFromXDescriptors(Collection<String> items);
    public List<String> getXDescriptors();
    public String getXDescriptor(int index);
    public String getFirstXDescriptor();
    public String getLastXDescriptor();
    public String getMatchingXDescriptor(Predicate<String> predicate);
    public Boolean hasMatchingXDescriptor(Predicate<String> predicate);
    public A withXDescriptors(List<String> xDescriptors);
    public A withXDescriptors(String... xDescriptors);
    public Boolean hasXDescriptors();
    public A addNewXDescriptor(String arg1);
    public A addNewXDescriptor(StringBuilder arg1);
    public A addNewXDescriptor(StringBuffer arg1);
}
