package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class APIServiceDefinitionsBuilder extends APIServiceDefinitionsFluentImpl<APIServiceDefinitionsBuilder> implements VisitableBuilder<APIServiceDefinitions,APIServiceDefinitionsBuilder> {

    APIServiceDefinitionsFluent<?> fluent;
    Boolean validationEnabled;

    public APIServiceDefinitionsBuilder() {
        this(true);
    }

    public APIServiceDefinitionsBuilder(Boolean validationEnabled) {
        this(new APIServiceDefinitions(), validationEnabled);
    }

    public APIServiceDefinitionsBuilder(APIServiceDefinitionsFluent<?> fluent) {
        this(fluent, true);
    }

    public APIServiceDefinitionsBuilder(APIServiceDefinitionsFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new APIServiceDefinitions(), validationEnabled);
    }

    public APIServiceDefinitionsBuilder(APIServiceDefinitionsFluent<?> fluent,APIServiceDefinitions instance) {
        this(fluent, instance, true);
    }

    public APIServiceDefinitionsBuilder(APIServiceDefinitionsFluent<?> fluent,APIServiceDefinitions instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withOwned(instance.getOwned()); 
        fluent.withRequired(instance.getRequired()); 
        this.validationEnabled = validationEnabled; 
    }

    public APIServiceDefinitionsBuilder(APIServiceDefinitions instance) {
        this(instance,true);
    }

    public APIServiceDefinitionsBuilder(APIServiceDefinitions instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withOwned(instance.getOwned()); 
        this.withRequired(instance.getRequired()); 
        this.validationEnabled = validationEnabled; 
    }

    public APIServiceDefinitions build() {
        APIServiceDefinitions buildable = new APIServiceDefinitions(fluent.getOwned(),fluent.getRequired());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        APIServiceDefinitionsBuilder that = (APIServiceDefinitionsBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
