package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface ClusterServiceVersionStatusFluent<A extends ClusterServiceVersionStatusFluent<A>> extends Fluent<A> {


    public String getCertsLastUpdated();
    public A withCertsLastUpdated(String certsLastUpdated);
    public Boolean hasCertsLastUpdated();
    public A withNewCertsLastUpdated(String arg1);
    public A withNewCertsLastUpdated(StringBuilder arg1);
    public A withNewCertsLastUpdated(StringBuffer arg1);
    public String getCertsRotateAt();
    public A withCertsRotateAt(String certsRotateAt);
    public Boolean hasCertsRotateAt();
    public A withNewCertsRotateAt(String arg1);
    public A withNewCertsRotateAt(StringBuilder arg1);
    public A withNewCertsRotateAt(StringBuffer arg1);
    public A addToConditions(int index,ClusterServiceVersionCondition item);
    public A setToConditions(int index,ClusterServiceVersionCondition item);
    public A addToConditions(ClusterServiceVersionCondition... items);
    public A addAllToConditions(Collection<ClusterServiceVersionCondition> items);
    public A removeFromConditions(ClusterServiceVersionCondition... items);
    public A removeAllFromConditions(Collection<ClusterServiceVersionCondition> items);
    public A removeMatchingFromConditions(Predicate<ClusterServiceVersionConditionBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<ClusterServiceVersionCondition> getConditions();
    public List<ClusterServiceVersionCondition> buildConditions();
    public ClusterServiceVersionCondition buildCondition(int index);
    public ClusterServiceVersionCondition buildFirstCondition();
    public ClusterServiceVersionCondition buildLastCondition();
    public ClusterServiceVersionCondition buildMatchingCondition(Predicate<ClusterServiceVersionConditionBuilder> predicate);
    public Boolean hasMatchingCondition(Predicate<ClusterServiceVersionConditionBuilder> predicate);
    public A withConditions(List<ClusterServiceVersionCondition> conditions);
    public A withConditions(ClusterServiceVersionCondition... conditions);
    public Boolean hasConditions();
    public A addNewCondition(String lastTransitionTime,String lastUpdateTime,String message,String phase,String reason);
    public ClusterServiceVersionStatusFluent.ConditionsNested<A> addNewCondition();
    public ClusterServiceVersionStatusFluent.ConditionsNested<A> addNewConditionLike(ClusterServiceVersionCondition item);
    public ClusterServiceVersionStatusFluent.ConditionsNested<A> setNewConditionLike(int index,ClusterServiceVersionCondition item);
    public ClusterServiceVersionStatusFluent.ConditionsNested<A> editCondition(int index);
    public ClusterServiceVersionStatusFluent.ConditionsNested<A> editFirstCondition();
    public ClusterServiceVersionStatusFluent.ConditionsNested<A> editLastCondition();
    public ClusterServiceVersionStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<ClusterServiceVersionConditionBuilder> predicate);
    public String getLastTransitionTime();
    public A withLastTransitionTime(String lastTransitionTime);
    public Boolean hasLastTransitionTime();
    public A withNewLastTransitionTime(String arg1);
    public A withNewLastTransitionTime(StringBuilder arg1);
    public A withNewLastTransitionTime(StringBuffer arg1);
    public String getLastUpdateTime();
    public A withLastUpdateTime(String lastUpdateTime);
    public Boolean hasLastUpdateTime();
    public A withNewLastUpdateTime(String arg1);
    public A withNewLastUpdateTime(StringBuilder arg1);
    public A withNewLastUpdateTime(StringBuffer arg1);
    public String getMessage();
    public A withMessage(String message);
    public Boolean hasMessage();
    public A withNewMessage(String arg1);
    public A withNewMessage(StringBuilder arg1);
    public A withNewMessage(StringBuffer arg1);
    public String getPhase();
    public A withPhase(String phase);
    public Boolean hasPhase();
    public A withNewPhase(String arg1);
    public A withNewPhase(StringBuilder arg1);
    public A withNewPhase(StringBuffer arg1);
    public String getReason();
    public A withReason(String reason);
    public Boolean hasReason();
    public A withNewReason(String arg1);
    public A withNewReason(StringBuilder arg1);
    public A withNewReason(StringBuffer arg1);
    public A addToRequirementStatus(int index,RequirementStatus item);
    public A setToRequirementStatus(int index,RequirementStatus item);
    public A addToRequirementStatus(RequirementStatus... items);
    public A addAllToRequirementStatus(Collection<RequirementStatus> items);
    public A removeFromRequirementStatus(RequirementStatus... items);
    public A removeAllFromRequirementStatus(Collection<RequirementStatus> items);
    public A removeMatchingFromRequirementStatus(Predicate<RequirementStatusBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildRequirementStatus instead.
 * @return The buildable object.
 */
@Deprecated public List<RequirementStatus> getRequirementStatus();
    public List<RequirementStatus> buildRequirementStatus();
    public RequirementStatus buildRequirementStatus(int index);
    public RequirementStatus buildFirstRequirementStatus();
    public RequirementStatus buildLastRequirementStatus();
    public RequirementStatus buildMatchingRequirementStatus(Predicate<RequirementStatusBuilder> predicate);
    public Boolean hasMatchingRequirementStatus(Predicate<RequirementStatusBuilder> predicate);
    public A withRequirementStatus(List<RequirementStatus> requirementStatus);
    public A withRequirementStatus(RequirementStatus... requirementStatus);
    public Boolean hasRequirementStatus();
    public ClusterServiceVersionStatusFluent.RequirementStatusNested<A> addNewRequirementStatus();
    public ClusterServiceVersionStatusFluent.RequirementStatusNested<A> addNewRequirementStatusLike(RequirementStatus item);
    public ClusterServiceVersionStatusFluent.RequirementStatusNested<A> setNewRequirementStatusLike(int index,RequirementStatus item);
    public ClusterServiceVersionStatusFluent.RequirementStatusNested<A> editRequirementStatus(int index);
    public ClusterServiceVersionStatusFluent.RequirementStatusNested<A> editFirstRequirementStatus();
    public ClusterServiceVersionStatusFluent.RequirementStatusNested<A> editLastRequirementStatus();
    public ClusterServiceVersionStatusFluent.RequirementStatusNested<A> editMatchingRequirementStatus(Predicate<RequirementStatusBuilder> predicate);
    public interface ConditionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ClusterServiceVersionConditionFluent<ClusterServiceVersionStatusFluent.ConditionsNested<N>> {

            public N and();
            public N endCondition();    }


    public interface RequirementStatusNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,RequirementStatusFluent<ClusterServiceVersionStatusFluent.RequirementStatusNested<N>> {

            public N and();
            public N endRequirementStatus();    }


}
