package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class DependentStatusFluentImpl<A extends DependentStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements DependentStatusFluent<A> {

    private String group;
    private String kind;
    private String message;
    private String status;
    private String uuid;
    private String version;

    public DependentStatusFluentImpl() {
    }

    public DependentStatusFluentImpl(DependentStatus instance) {
        this.withGroup(instance.getGroup()); 
        this.withKind(instance.getKind()); 
        this.withMessage(instance.getMessage()); 
        this.withStatus(instance.getStatus()); 
        this.withUuid(instance.getUuid()); 
        this.withVersion(instance.getVersion()); 
    }

    public String getGroup() {
        return this.group;
    }

    public A withGroup(String group) {
        this.group=group; return (A) this;
    }

    public Boolean hasGroup() {
        return this.group != null;
    }

    public A withNewGroup(String arg1) {
        return (A)withGroup(new String(arg1));
    }

    public A withNewGroup(StringBuilder arg1) {
        return (A)withGroup(new String(arg1));
    }

    public A withNewGroup(StringBuffer arg1) {
        return (A)withGroup(new String(arg1));
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind=kind; return (A) this;
    }

    public Boolean hasKind() {
        return this.kind != null;
    }

    public A withNewKind(String arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1) {
        return (A)withKind(new String(arg1));
    }

    public String getMessage() {
        return this.message;
    }

    public A withMessage(String message) {
        this.message=message; return (A) this;
    }

    public Boolean hasMessage() {
        return this.message != null;
    }

    public A withNewMessage(String arg1) {
        return (A)withMessage(new String(arg1));
    }

    public A withNewMessage(StringBuilder arg1) {
        return (A)withMessage(new String(arg1));
    }

    public A withNewMessage(StringBuffer arg1) {
        return (A)withMessage(new String(arg1));
    }

    public String getStatus() {
        return this.status;
    }

    public A withStatus(String status) {
        this.status=status; return (A) this;
    }

    public Boolean hasStatus() {
        return this.status != null;
    }

    public A withNewStatus(String arg1) {
        return (A)withStatus(new String(arg1));
    }

    public A withNewStatus(StringBuilder arg1) {
        return (A)withStatus(new String(arg1));
    }

    public A withNewStatus(StringBuffer arg1) {
        return (A)withStatus(new String(arg1));
    }

    public String getUuid() {
        return this.uuid;
    }

    public A withUuid(String uuid) {
        this.uuid=uuid; return (A) this;
    }

    public Boolean hasUuid() {
        return this.uuid != null;
    }

    public A withNewUuid(String arg1) {
        return (A)withUuid(new String(arg1));
    }

    public A withNewUuid(StringBuilder arg1) {
        return (A)withUuid(new String(arg1));
    }

    public A withNewUuid(StringBuffer arg1) {
        return (A)withUuid(new String(arg1));
    }

    public String getVersion() {
        return this.version;
    }

    public A withVersion(String version) {
        this.version=version; return (A) this;
    }

    public Boolean hasVersion() {
        return this.version != null;
    }

    public A withNewVersion(String arg1) {
        return (A)withVersion(new String(arg1));
    }

    public A withNewVersion(StringBuilder arg1) {
        return (A)withVersion(new String(arg1));
    }

    public A withNewVersion(StringBuffer arg1) {
        return (A)withVersion(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        DependentStatusFluentImpl that = (DependentStatusFluentImpl) o;
        if (group != null ? !group.equals(that.group) :that.group != null) return false;
        if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
        if (message != null ? !message.equals(that.message) :that.message != null) return false;
        if (status != null ? !status.equals(that.status) :that.status != null) return false;
        if (uuid != null ? !uuid.equals(that.uuid) :that.uuid != null) return false;
        if (version != null ? !version.equals(that.version) :that.version != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(group,  kind,  message,  status,  uuid,  version,  super.hashCode());
    }

}
