package io.fabric8.openshift.api.model.operatorhub.v1;

import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class OperatorGroupSpecFluentImpl<A extends OperatorGroupSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements OperatorGroupSpecFluent<A> {

    private LabelSelectorBuilder selector;
    private String serviceAccountName;
    private Boolean staticProvidedAPIs;
    private List<String> targetNamespaces = new ArrayList<String>();

    public OperatorGroupSpecFluentImpl() {
    }

    public OperatorGroupSpecFluentImpl(OperatorGroupSpec instance) {
        this.withSelector(instance.getSelector()); 
        this.withServiceAccountName(instance.getServiceAccountName()); 
        this.withStaticProvidedAPIs(instance.getStaticProvidedAPIs()); 
        this.withTargetNamespaces(instance.getTargetNamespaces()); 
    }

    
/**
 * This method has been deprecated, please use method buildSelector instead.
 * @return The buildable object.
 */
@Deprecated public LabelSelector getSelector() {
        return this.selector!=null?this.selector.build():null;
    }

    public LabelSelector buildSelector() {
        return this.selector!=null?this.selector.build():null;
    }

    public A withSelector(LabelSelector selector) {
        _visitables.get("selector").remove(this.selector);
        if (selector!=null){ this.selector= new LabelSelectorBuilder(selector); _visitables.get("selector").add(this.selector);} return (A) this;
    }

    public Boolean hasSelector() {
        return this.selector != null;
    }

    public io.fabric8.openshift.api.model.operatorhub.v1.OperatorGroupSpecFluent.SelectorNested<A> withNewSelector() {
        return new SelectorNestedImpl();
    }

    public io.fabric8.openshift.api.model.operatorhub.v1.OperatorGroupSpecFluent.SelectorNested<A> withNewSelectorLike(LabelSelector item) {
        return new SelectorNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.operatorhub.v1.OperatorGroupSpecFluent.SelectorNested<A> editSelector() {
        return withNewSelectorLike(getSelector());
    }

    public io.fabric8.openshift.api.model.operatorhub.v1.OperatorGroupSpecFluent.SelectorNested<A> editOrNewSelector() {
        return withNewSelectorLike(getSelector() != null ? getSelector(): new LabelSelectorBuilder().build());
    }

    public io.fabric8.openshift.api.model.operatorhub.v1.OperatorGroupSpecFluent.SelectorNested<A> editOrNewSelectorLike(LabelSelector item) {
        return withNewSelectorLike(getSelector() != null ? getSelector(): item);
    }

    public String getServiceAccountName() {
        return this.serviceAccountName;
    }

    public A withServiceAccountName(String serviceAccountName) {
        this.serviceAccountName=serviceAccountName; return (A) this;
    }

    public Boolean hasServiceAccountName() {
        return this.serviceAccountName != null;
    }

    public A withNewServiceAccountName(StringBuilder arg1) {
        return (A)withServiceAccountName(new String(arg1));
    }

    public A withNewServiceAccountName(int[] arg1,int arg2,int arg3) {
        return (A)withServiceAccountName(new String(arg1, arg2, arg3));
    }

    public A withNewServiceAccountName(char[] arg1) {
        return (A)withServiceAccountName(new String(arg1));
    }

    public A withNewServiceAccountName(StringBuffer arg1) {
        return (A)withServiceAccountName(new String(arg1));
    }

    public A withNewServiceAccountName(byte[] arg1,int arg2) {
        return (A)withServiceAccountName(new String(arg1, arg2));
    }

    public A withNewServiceAccountName(byte[] arg1) {
        return (A)withServiceAccountName(new String(arg1));
    }

    public A withNewServiceAccountName(char[] arg1,int arg2,int arg3) {
        return (A)withServiceAccountName(new String(arg1, arg2, arg3));
    }

    public A withNewServiceAccountName(byte[] arg1,int arg2,int arg3) {
        return (A)withServiceAccountName(new String(arg1, arg2, arg3));
    }

    public A withNewServiceAccountName(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withServiceAccountName(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewServiceAccountName(String arg1) {
        return (A)withServiceAccountName(new String(arg1));
    }

    public Boolean getStaticProvidedAPIs() {
        return this.staticProvidedAPIs;
    }

    public A withStaticProvidedAPIs(Boolean staticProvidedAPIs) {
        this.staticProvidedAPIs=staticProvidedAPIs; return (A) this;
    }

    public Boolean hasStaticProvidedAPIs() {
        return this.staticProvidedAPIs != null;
    }

    public A withNewStaticProvidedAPIs(String arg1) {
        return (A)withStaticProvidedAPIs(new Boolean(arg1));
    }

    public A withNewStaticProvidedAPIs(boolean arg1) {
        return (A)withStaticProvidedAPIs(new Boolean(arg1));
    }

    public A addToTargetNamespaces(int index,String item) {
        if (this.targetNamespaces == null) {this.targetNamespaces = new ArrayList<String>();}
        this.targetNamespaces.add(index, item);
        return (A)this;
    }

    public A setToTargetNamespaces(int index,String item) {
        if (this.targetNamespaces == null) {this.targetNamespaces = new ArrayList<String>();}
        this.targetNamespaces.set(index, item); return (A)this;
    }

    public A addToTargetNamespaces(String... items) {
        if (this.targetNamespaces == null) {this.targetNamespaces = new ArrayList<String>();}
        for (String item : items) {this.targetNamespaces.add(item);} return (A)this;
    }

    public A addAllToTargetNamespaces(Collection<String> items) {
        if (this.targetNamespaces == null) {this.targetNamespaces = new ArrayList<String>();}
        for (String item : items) {this.targetNamespaces.add(item);} return (A)this;
    }

    public A removeFromTargetNamespaces(String... items) {
        for (String item : items) {if (this.targetNamespaces!= null){ this.targetNamespaces.remove(item);}} return (A)this;
    }

    public A removeAllFromTargetNamespaces(Collection<String> items) {
        for (String item : items) {if (this.targetNamespaces!= null){ this.targetNamespaces.remove(item);}} return (A)this;
    }

    public List<String> getTargetNamespaces() {
        return this.targetNamespaces;
    }

    public String getTargetNamespace(int index) {
        return this.targetNamespaces.get(index);
    }

    public String getFirstTargetNamespace() {
        return this.targetNamespaces.get(0);
    }

    public String getLastTargetNamespace() {
        return this.targetNamespaces.get(targetNamespaces.size() - 1);
    }

    public String getMatchingTargetNamespace(Predicate<String> predicate) {
        for (String item: targetNamespaces) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingTargetNamespace(Predicate<String> predicate) {
        for (String item: targetNamespaces) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withTargetNamespaces(List<String> targetNamespaces) {
        if (this.targetNamespaces != null) { _visitables.get("targetNamespaces").removeAll(this.targetNamespaces);}
        if (targetNamespaces != null) {this.targetNamespaces = new ArrayList<String>(); for (String item : targetNamespaces){this.addToTargetNamespaces(item);}} else { this.targetNamespaces = null;} return (A) this;
    }

    public A withTargetNamespaces(String... targetNamespaces) {
        if (this.targetNamespaces != null) {this.targetNamespaces.clear();}
        if (targetNamespaces != null) {for (String item :targetNamespaces){ this.addToTargetNamespaces(item);}} return (A) this;
    }

    public Boolean hasTargetNamespaces() {
        return targetNamespaces != null && !targetNamespaces.isEmpty();
    }

    public A addNewTargetNamespace(StringBuilder arg1) {
        return (A)addToTargetNamespaces(new String(arg1));
    }

    public A addNewTargetNamespace(int[] arg1,int arg2,int arg3) {
        return (A)addToTargetNamespaces(new String(arg1, arg2, arg3));
    }

    public A addNewTargetNamespace(char[] arg1) {
        return (A)addToTargetNamespaces(new String(arg1));
    }

    public A addNewTargetNamespace(StringBuffer arg1) {
        return (A)addToTargetNamespaces(new String(arg1));
    }

    public A addNewTargetNamespace(byte[] arg1,int arg2) {
        return (A)addToTargetNamespaces(new String(arg1, arg2));
    }

    public A addNewTargetNamespace(byte[] arg1) {
        return (A)addToTargetNamespaces(new String(arg1));
    }

    public A addNewTargetNamespace(char[] arg1,int arg2,int arg3) {
        return (A)addToTargetNamespaces(new String(arg1, arg2, arg3));
    }

    public A addNewTargetNamespace(byte[] arg1,int arg2,int arg3) {
        return (A)addToTargetNamespaces(new String(arg1, arg2, arg3));
    }

    public A addNewTargetNamespace(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)addToTargetNamespaces(new String(arg1, arg2, arg3, arg4));
    }

    public A addNewTargetNamespace(String arg1) {
        return (A)addToTargetNamespaces(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        OperatorGroupSpecFluentImpl that = (OperatorGroupSpecFluentImpl) o;
        if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
        if (serviceAccountName != null ? !serviceAccountName.equals(that.serviceAccountName) :that.serviceAccountName != null) return false;
        if (staticProvidedAPIs != null ? !staticProvidedAPIs.equals(that.staticProvidedAPIs) :that.staticProvidedAPIs != null) return false;
        if (targetNamespaces != null ? !targetNamespaces.equals(that.targetNamespaces) :that.targetNamespaces != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(selector,  serviceAccountName,  staticProvidedAPIs,  targetNamespaces,  super.hashCode());
    }

    public class SelectorNestedImpl<N> extends LabelSelectorFluentImpl<io.fabric8.openshift.api.model.operatorhub.v1.OperatorGroupSpecFluent.SelectorNested<N>> implements io.fabric8.openshift.api.model.operatorhub.v1.OperatorGroupSpecFluent.SelectorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final LabelSelectorBuilder builder;

            SelectorNestedImpl(LabelSelector item) {
                this.builder = new LabelSelectorBuilder(this, item);
                        
            }

            SelectorNestedImpl() {
                this.builder = new LabelSelectorBuilder(this);
                        
            }

            public N and() {
                return (N) OperatorGroupSpecFluentImpl.this.withSelector(builder.build());
            }

            public N endSelector() {
                return and();
            }
    }


}
