package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class APIResourceReferenceBuilder extends APIResourceReferenceFluentImpl<APIResourceReferenceBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<APIResourceReference,APIResourceReferenceBuilder> {

    APIResourceReferenceFluent<?> fluent;
    Boolean validationEnabled;

    public APIResourceReferenceBuilder() {
        this(true);
    }

    public APIResourceReferenceBuilder(Boolean validationEnabled) {
        this(new APIResourceReference(), validationEnabled);
    }

    public APIResourceReferenceBuilder(APIResourceReferenceFluent<?> fluent) {
        this(fluent, true);
    }

    public APIResourceReferenceBuilder(APIResourceReferenceFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new APIResourceReference(), validationEnabled);
    }

    public APIResourceReferenceBuilder(APIResourceReferenceFluent<?> fluent,APIResourceReference instance) {
        this(fluent, instance, true);
    }

    public APIResourceReferenceBuilder(APIResourceReferenceFluent<?> fluent,APIResourceReference instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withKind(instance.getKind()); 
        fluent.withName(instance.getName()); 
        fluent.withVersion(instance.getVersion()); 
        this.validationEnabled = validationEnabled; 
    }

    public APIResourceReferenceBuilder(APIResourceReference instance) {
        this(instance,true);
    }

    public APIResourceReferenceBuilder(APIResourceReference instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withKind(instance.getKind()); 
        this.withName(instance.getName()); 
        this.withVersion(instance.getVersion()); 
        this.validationEnabled = validationEnabled; 
    }

    public APIResourceReference build() {
        APIResourceReference buildable = new APIResourceReference(fluent.getKind(),fluent.getName(),fluent.getVersion());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        APIResourceReferenceBuilder that = (APIResourceReferenceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
