package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class GRPCConnectionStateFluentImpl<A extends GRPCConnectionStateFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements GRPCConnectionStateFluent<A> {

    private String address;
    private String lastConnect;
    private String lastObservedState;

    public GRPCConnectionStateFluentImpl() {
    }

    public GRPCConnectionStateFluentImpl(GRPCConnectionState instance) {
        this.withAddress(instance.getAddress()); 
        this.withLastConnect(instance.getLastConnect()); 
        this.withLastObservedState(instance.getLastObservedState()); 
    }

    public String getAddress() {
        return this.address;
    }

    public A withAddress(String address) {
        this.address=address; return (A) this;
    }

    public Boolean hasAddress() {
        return this.address != null;
    }

    public A withNewAddress(StringBuilder arg1) {
        return (A)withAddress(new String(arg1));
    }

    public A withNewAddress(int[] arg1,int arg2,int arg3) {
        return (A)withAddress(new String(arg1, arg2, arg3));
    }

    public A withNewAddress(char[] arg1) {
        return (A)withAddress(new String(arg1));
    }

    public A withNewAddress(StringBuffer arg1) {
        return (A)withAddress(new String(arg1));
    }

    public A withNewAddress(byte[] arg1,int arg2) {
        return (A)withAddress(new String(arg1, arg2));
    }

    public A withNewAddress(byte[] arg1) {
        return (A)withAddress(new String(arg1));
    }

    public A withNewAddress(char[] arg1,int arg2,int arg3) {
        return (A)withAddress(new String(arg1, arg2, arg3));
    }

    public A withNewAddress(byte[] arg1,int arg2,int arg3) {
        return (A)withAddress(new String(arg1, arg2, arg3));
    }

    public A withNewAddress(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withAddress(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewAddress(String arg1) {
        return (A)withAddress(new String(arg1));
    }

    public String getLastConnect() {
        return this.lastConnect;
    }

    public A withLastConnect(String lastConnect) {
        this.lastConnect=lastConnect; return (A) this;
    }

    public Boolean hasLastConnect() {
        return this.lastConnect != null;
    }

    public A withNewLastConnect(StringBuilder arg1) {
        return (A)withLastConnect(new String(arg1));
    }

    public A withNewLastConnect(int[] arg1,int arg2,int arg3) {
        return (A)withLastConnect(new String(arg1, arg2, arg3));
    }

    public A withNewLastConnect(char[] arg1) {
        return (A)withLastConnect(new String(arg1));
    }

    public A withNewLastConnect(StringBuffer arg1) {
        return (A)withLastConnect(new String(arg1));
    }

    public A withNewLastConnect(byte[] arg1,int arg2) {
        return (A)withLastConnect(new String(arg1, arg2));
    }

    public A withNewLastConnect(byte[] arg1) {
        return (A)withLastConnect(new String(arg1));
    }

    public A withNewLastConnect(char[] arg1,int arg2,int arg3) {
        return (A)withLastConnect(new String(arg1, arg2, arg3));
    }

    public A withNewLastConnect(byte[] arg1,int arg2,int arg3) {
        return (A)withLastConnect(new String(arg1, arg2, arg3));
    }

    public A withNewLastConnect(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withLastConnect(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewLastConnect(String arg1) {
        return (A)withLastConnect(new String(arg1));
    }

    public String getLastObservedState() {
        return this.lastObservedState;
    }

    public A withLastObservedState(String lastObservedState) {
        this.lastObservedState=lastObservedState; return (A) this;
    }

    public Boolean hasLastObservedState() {
        return this.lastObservedState != null;
    }

    public A withNewLastObservedState(StringBuilder arg1) {
        return (A)withLastObservedState(new String(arg1));
    }

    public A withNewLastObservedState(int[] arg1,int arg2,int arg3) {
        return (A)withLastObservedState(new String(arg1, arg2, arg3));
    }

    public A withNewLastObservedState(char[] arg1) {
        return (A)withLastObservedState(new String(arg1));
    }

    public A withNewLastObservedState(StringBuffer arg1) {
        return (A)withLastObservedState(new String(arg1));
    }

    public A withNewLastObservedState(byte[] arg1,int arg2) {
        return (A)withLastObservedState(new String(arg1, arg2));
    }

    public A withNewLastObservedState(byte[] arg1) {
        return (A)withLastObservedState(new String(arg1));
    }

    public A withNewLastObservedState(char[] arg1,int arg2,int arg3) {
        return (A)withLastObservedState(new String(arg1, arg2, arg3));
    }

    public A withNewLastObservedState(byte[] arg1,int arg2,int arg3) {
        return (A)withLastObservedState(new String(arg1, arg2, arg3));
    }

    public A withNewLastObservedState(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withLastObservedState(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewLastObservedState(String arg1) {
        return (A)withLastObservedState(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        GRPCConnectionStateFluentImpl that = (GRPCConnectionStateFluentImpl) o;
        if (address != null ? !address.equals(that.address) :that.address != null) return false;
        if (lastConnect != null ? !lastConnect.equals(that.lastConnect) :that.lastConnect != null) return false;
        if (lastObservedState != null ? !lastObservedState.equals(that.lastObservedState) :that.lastObservedState != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(address,  lastConnect,  lastObservedState,  super.hashCode());
    }

}
