package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class InstallPlanConditionBuilder extends InstallPlanConditionFluentImpl<InstallPlanConditionBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<InstallPlanCondition,InstallPlanConditionBuilder> {

    InstallPlanConditionFluent<?> fluent;
    Boolean validationEnabled;

    public InstallPlanConditionBuilder() {
        this(true);
    }

    public InstallPlanConditionBuilder(Boolean validationEnabled) {
        this(new InstallPlanCondition(), validationEnabled);
    }

    public InstallPlanConditionBuilder(InstallPlanConditionFluent<?> fluent) {
        this(fluent, true);
    }

    public InstallPlanConditionBuilder(InstallPlanConditionFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new InstallPlanCondition(), validationEnabled);
    }

    public InstallPlanConditionBuilder(InstallPlanConditionFluent<?> fluent,InstallPlanCondition instance) {
        this(fluent, instance, true);
    }

    public InstallPlanConditionBuilder(InstallPlanConditionFluent<?> fluent,InstallPlanCondition instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withLastTransitionTime(instance.getLastTransitionTime()); 
        fluent.withLastUpdateTime(instance.getLastUpdateTime()); 
        fluent.withMessage(instance.getMessage()); 
        fluent.withReason(instance.getReason()); 
        fluent.withStatus(instance.getStatus()); 
        fluent.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }

    public InstallPlanConditionBuilder(InstallPlanCondition instance) {
        this(instance,true);
    }

    public InstallPlanConditionBuilder(InstallPlanCondition instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withLastTransitionTime(instance.getLastTransitionTime()); 
        this.withLastUpdateTime(instance.getLastUpdateTime()); 
        this.withMessage(instance.getMessage()); 
        this.withReason(instance.getReason()); 
        this.withStatus(instance.getStatus()); 
        this.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }

    public InstallPlanCondition build() {
        InstallPlanCondition buildable = new InstallPlanCondition(fluent.getLastTransitionTime(),fluent.getLastUpdateTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        InstallPlanConditionBuilder that = (InstallPlanConditionBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
