package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class InstallPlanReferenceBuilder extends InstallPlanReferenceFluentImpl<InstallPlanReferenceBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<InstallPlanReference,InstallPlanReferenceBuilder> {

    InstallPlanReferenceFluent<?> fluent;
    Boolean validationEnabled;

    public InstallPlanReferenceBuilder() {
        this(true);
    }

    public InstallPlanReferenceBuilder(Boolean validationEnabled) {
        this(new InstallPlanReference(), validationEnabled);
    }

    public InstallPlanReferenceBuilder(InstallPlanReferenceFluent<?> fluent) {
        this(fluent, true);
    }

    public InstallPlanReferenceBuilder(InstallPlanReferenceFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new InstallPlanReference(), validationEnabled);
    }

    public InstallPlanReferenceBuilder(InstallPlanReferenceFluent<?> fluent,InstallPlanReference instance) {
        this(fluent, instance, true);
    }

    public InstallPlanReferenceBuilder(InstallPlanReferenceFluent<?> fluent,InstallPlanReference instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withName(instance.getName()); 
        fluent.withUuid(instance.getUuid()); 
        this.validationEnabled = validationEnabled; 
    }

    public InstallPlanReferenceBuilder(InstallPlanReference instance) {
        this(instance,true);
    }

    public InstallPlanReferenceBuilder(InstallPlanReference instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withName(instance.getName()); 
        this.withUuid(instance.getUuid()); 
        this.validationEnabled = validationEnabled; 
    }

    public InstallPlanReference build() {
        InstallPlanReference buildable = new InstallPlanReference(fluent.getApiVersion(),fluent.getKind(),fluent.getName(),fluent.getUuid());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        InstallPlanReferenceBuilder that = (InstallPlanReferenceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
