package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class MaintainerBuilder extends MaintainerFluentImpl<MaintainerBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<Maintainer,MaintainerBuilder> {

    MaintainerFluent<?> fluent;
    Boolean validationEnabled;

    public MaintainerBuilder() {
        this(true);
    }

    public MaintainerBuilder(Boolean validationEnabled) {
        this(new Maintainer(), validationEnabled);
    }

    public MaintainerBuilder(MaintainerFluent<?> fluent) {
        this(fluent, true);
    }

    public MaintainerBuilder(MaintainerFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new Maintainer(), validationEnabled);
    }

    public MaintainerBuilder(MaintainerFluent<?> fluent,Maintainer instance) {
        this(fluent, instance, true);
    }

    public MaintainerBuilder(MaintainerFluent<?> fluent,Maintainer instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withEmail(instance.getEmail()); 
        fluent.withName(instance.getName()); 
        this.validationEnabled = validationEnabled; 
    }

    public MaintainerBuilder(Maintainer instance) {
        this(instance,true);
    }

    public MaintainerBuilder(Maintainer instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withEmail(instance.getEmail()); 
        this.withName(instance.getName()); 
        this.validationEnabled = validationEnabled; 
    }

    public Maintainer build() {
        Maintainer buildable = new Maintainer(fluent.getEmail(),fluent.getName());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        MaintainerBuilder that = (MaintainerBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
