package io.fabric8.openshift.api.model.operatorhub.manifests;

import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class PackageChannelFluentImpl<A extends PackageChannelFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements PackageChannelFluent<A> {

    private String currentCSV;
    private String name;

    public PackageChannelFluentImpl() {
    }

    public PackageChannelFluentImpl(PackageChannel instance) {
        this.withCurrentCSV(instance.getCurrentCSV()); 
        this.withName(instance.getName()); 
    }

    public String getCurrentCSV() {
        return this.currentCSV;
    }

    public A withCurrentCSV(String currentCSV) {
        this.currentCSV=currentCSV; return (A) this;
    }

    public Boolean hasCurrentCSV() {
        return this.currentCSV != null;
    }

    public A withNewCurrentCSV(StringBuilder arg1) {
        return (A)withCurrentCSV(new String(arg1));
    }

    public A withNewCurrentCSV(int[] arg1,int arg2,int arg3) {
        return (A)withCurrentCSV(new String(arg1, arg2, arg3));
    }

    public A withNewCurrentCSV(char[] arg1) {
        return (A)withCurrentCSV(new String(arg1));
    }

    public A withNewCurrentCSV(StringBuffer arg1) {
        return (A)withCurrentCSV(new String(arg1));
    }

    public A withNewCurrentCSV(byte[] arg1,int arg2) {
        return (A)withCurrentCSV(new String(arg1, arg2));
    }

    public A withNewCurrentCSV(byte[] arg1) {
        return (A)withCurrentCSV(new String(arg1));
    }

    public A withNewCurrentCSV(char[] arg1,int arg2,int arg3) {
        return (A)withCurrentCSV(new String(arg1, arg2, arg3));
    }

    public A withNewCurrentCSV(byte[] arg1,int arg2,int arg3) {
        return (A)withCurrentCSV(new String(arg1, arg2, arg3));
    }

    public A withNewCurrentCSV(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withCurrentCSV(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewCurrentCSV(String arg1) {
        return (A)withCurrentCSV(new String(arg1));
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name=name; return (A) this;
    }

    public Boolean hasName() {
        return this.name != null;
    }

    public A withNewName(StringBuilder arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(int[] arg1,int arg2,int arg3) {
        return (A)withName(new String(arg1, arg2, arg3));
    }

    public A withNewName(char[] arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(byte[] arg1,int arg2) {
        return (A)withName(new String(arg1, arg2));
    }

    public A withNewName(byte[] arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(char[] arg1,int arg2,int arg3) {
        return (A)withName(new String(arg1, arg2, arg3));
    }

    public A withNewName(byte[] arg1,int arg2,int arg3) {
        return (A)withName(new String(arg1, arg2, arg3));
    }

    public A withNewName(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withName(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewName(String arg1) {
        return (A)withName(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PackageChannelFluentImpl that = (PackageChannelFluentImpl) o;
        if (currentCSV != null ? !currentCSV.equals(that.currentCSV) :that.currentCSV != null) return false;
        if (name != null ? !name.equals(that.name) :that.name != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(currentCSV,  name,  super.hashCode());
    }

}
