package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class InstallPlanListBuilder extends InstallPlanListFluentImpl<InstallPlanListBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<InstallPlanList,InstallPlanListBuilder> {

    InstallPlanListFluent<?> fluent;
    Boolean validationEnabled;

    public InstallPlanListBuilder() {
        this(true);
    }

    public InstallPlanListBuilder(Boolean validationEnabled) {
        this(new InstallPlanList(), validationEnabled);
    }

    public InstallPlanListBuilder(InstallPlanListFluent<?> fluent) {
        this(fluent, true);
    }

    public InstallPlanListBuilder(InstallPlanListFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new InstallPlanList(), validationEnabled);
    }

    public InstallPlanListBuilder(InstallPlanListFluent<?> fluent,InstallPlanList instance) {
        this(fluent, instance, true);
    }

    public InstallPlanListBuilder(InstallPlanListFluent<?> fluent,InstallPlanList instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public InstallPlanListBuilder(InstallPlanList instance) {
        this(instance,true);
    }

    public InstallPlanListBuilder(InstallPlanList instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public InstallPlanList build() {
        InstallPlanList buildable = new InstallPlanList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        InstallPlanListBuilder that = (InstallPlanListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
