package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.admissionregistration.v1.RuleWithOperations;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class WebhookDescriptionFluentImpl<A extends WebhookDescriptionFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements WebhookDescriptionFluent<A> {

    private List<String> admissionReviewVersions = new ArrayList<String>();
    private Integer containerPort;
    private List<String> conversionCRDs = new ArrayList<String>();
    private String deploymentName;
    private String failurePolicy;
    private String generateName;
    private String matchPolicy;
    private LabelSelectorBuilder objectSelector;
    private String reinvocationPolicy;
    private List<RuleWithOperations> rules = new ArrayList<RuleWithOperations>();
    private String sideEffects;
    private Integer timeoutSeconds;
    private String type;
    private String webhookPath;

    public WebhookDescriptionFluentImpl() {
    }

    public WebhookDescriptionFluentImpl(WebhookDescription instance) {
        this.withAdmissionReviewVersions(instance.getAdmissionReviewVersions()); 
        this.withContainerPort(instance.getContainerPort()); 
        this.withConversionCRDs(instance.getConversionCRDs()); 
        this.withDeploymentName(instance.getDeploymentName()); 
        this.withFailurePolicy(instance.getFailurePolicy()); 
        this.withGenerateName(instance.getGenerateName()); 
        this.withMatchPolicy(instance.getMatchPolicy()); 
        this.withObjectSelector(instance.getObjectSelector()); 
        this.withReinvocationPolicy(instance.getReinvocationPolicy()); 
        this.withRules(instance.getRules()); 
        this.withSideEffects(instance.getSideEffects()); 
        this.withTimeoutSeconds(instance.getTimeoutSeconds()); 
        this.withType(instance.getType()); 
        this.withWebhookPath(instance.getWebhookPath()); 
    }

    public A addToAdmissionReviewVersions(int index,String item) {
        if (this.admissionReviewVersions == null) {this.admissionReviewVersions = new ArrayList<String>();}
        this.admissionReviewVersions.add(index, item);
        return (A)this;
    }

    public A setToAdmissionReviewVersions(int index,String item) {
        if (this.admissionReviewVersions == null) {this.admissionReviewVersions = new ArrayList<String>();}
        this.admissionReviewVersions.set(index, item); return (A)this;
    }

    public A addToAdmissionReviewVersions(String... items) {
        if (this.admissionReviewVersions == null) {this.admissionReviewVersions = new ArrayList<String>();}
        for (String item : items) {this.admissionReviewVersions.add(item);} return (A)this;
    }

    public A addAllToAdmissionReviewVersions(Collection<String> items) {
        if (this.admissionReviewVersions == null) {this.admissionReviewVersions = new ArrayList<String>();}
        for (String item : items) {this.admissionReviewVersions.add(item);} return (A)this;
    }

    public A removeFromAdmissionReviewVersions(String... items) {
        for (String item : items) {if (this.admissionReviewVersions!= null){ this.admissionReviewVersions.remove(item);}} return (A)this;
    }

    public A removeAllFromAdmissionReviewVersions(Collection<String> items) {
        for (String item : items) {if (this.admissionReviewVersions!= null){ this.admissionReviewVersions.remove(item);}} return (A)this;
    }

    public List<String> getAdmissionReviewVersions() {
        return this.admissionReviewVersions;
    }

    public String getAdmissionReviewVersion(int index) {
        return this.admissionReviewVersions.get(index);
    }

    public String getFirstAdmissionReviewVersion() {
        return this.admissionReviewVersions.get(0);
    }

    public String getLastAdmissionReviewVersion() {
        return this.admissionReviewVersions.get(admissionReviewVersions.size() - 1);
    }

    public String getMatchingAdmissionReviewVersion(Predicate<String> predicate) {
        for (String item: admissionReviewVersions) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingAdmissionReviewVersion(Predicate<String> predicate) {
        for (String item: admissionReviewVersions) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withAdmissionReviewVersions(List<String> admissionReviewVersions) {
        if (this.admissionReviewVersions != null) { _visitables.get("admissionReviewVersions").removeAll(this.admissionReviewVersions);}
        if (admissionReviewVersions != null) {this.admissionReviewVersions = new ArrayList<String>(); for (String item : admissionReviewVersions){this.addToAdmissionReviewVersions(item);}} else { this.admissionReviewVersions = null;} return (A) this;
    }

    public A withAdmissionReviewVersions(String... admissionReviewVersions) {
        if (this.admissionReviewVersions != null) {this.admissionReviewVersions.clear();}
        if (admissionReviewVersions != null) {for (String item :admissionReviewVersions){ this.addToAdmissionReviewVersions(item);}} return (A) this;
    }

    public Boolean hasAdmissionReviewVersions() {
        return admissionReviewVersions != null && !admissionReviewVersions.isEmpty();
    }

    public A addNewAdmissionReviewVersion(StringBuilder arg1) {
        return (A)addToAdmissionReviewVersions(new String(arg1));
    }

    public A addNewAdmissionReviewVersion(int[] arg1,int arg2,int arg3) {
        return (A)addToAdmissionReviewVersions(new String(arg1, arg2, arg3));
    }

    public A addNewAdmissionReviewVersion(char[] arg1) {
        return (A)addToAdmissionReviewVersions(new String(arg1));
    }

    public A addNewAdmissionReviewVersion(StringBuffer arg1) {
        return (A)addToAdmissionReviewVersions(new String(arg1));
    }

    public A addNewAdmissionReviewVersion(byte[] arg1,int arg2) {
        return (A)addToAdmissionReviewVersions(new String(arg1, arg2));
    }

    public A addNewAdmissionReviewVersion(byte[] arg1) {
        return (A)addToAdmissionReviewVersions(new String(arg1));
    }

    public A addNewAdmissionReviewVersion(char[] arg1,int arg2,int arg3) {
        return (A)addToAdmissionReviewVersions(new String(arg1, arg2, arg3));
    }

    public A addNewAdmissionReviewVersion(byte[] arg1,int arg2,int arg3) {
        return (A)addToAdmissionReviewVersions(new String(arg1, arg2, arg3));
    }

    public A addNewAdmissionReviewVersion(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)addToAdmissionReviewVersions(new String(arg1, arg2, arg3, arg4));
    }

    public A addNewAdmissionReviewVersion(String arg1) {
        return (A)addToAdmissionReviewVersions(new String(arg1));
    }

    public Integer getContainerPort() {
        return this.containerPort;
    }

    public A withContainerPort(Integer containerPort) {
        this.containerPort=containerPort; return (A) this;
    }

    public Boolean hasContainerPort() {
        return this.containerPort != null;
    }

    public A withNewContainerPort(int arg0) {
        return (A)withContainerPort(new Integer(arg0));
    }

    public A addToConversionCRDs(int index,String item) {
        if (this.conversionCRDs == null) {this.conversionCRDs = new ArrayList<String>();}
        this.conversionCRDs.add(index, item);
        return (A)this;
    }

    public A setToConversionCRDs(int index,String item) {
        if (this.conversionCRDs == null) {this.conversionCRDs = new ArrayList<String>();}
        this.conversionCRDs.set(index, item); return (A)this;
    }

    public A addToConversionCRDs(String... items) {
        if (this.conversionCRDs == null) {this.conversionCRDs = new ArrayList<String>();}
        for (String item : items) {this.conversionCRDs.add(item);} return (A)this;
    }

    public A addAllToConversionCRDs(Collection<String> items) {
        if (this.conversionCRDs == null) {this.conversionCRDs = new ArrayList<String>();}
        for (String item : items) {this.conversionCRDs.add(item);} return (A)this;
    }

    public A removeFromConversionCRDs(String... items) {
        for (String item : items) {if (this.conversionCRDs!= null){ this.conversionCRDs.remove(item);}} return (A)this;
    }

    public A removeAllFromConversionCRDs(Collection<String> items) {
        for (String item : items) {if (this.conversionCRDs!= null){ this.conversionCRDs.remove(item);}} return (A)this;
    }

    public List<String> getConversionCRDs() {
        return this.conversionCRDs;
    }

    public String getConversionCRD(int index) {
        return this.conversionCRDs.get(index);
    }

    public String getFirstConversionCRD() {
        return this.conversionCRDs.get(0);
    }

    public String getLastConversionCRD() {
        return this.conversionCRDs.get(conversionCRDs.size() - 1);
    }

    public String getMatchingConversionCRD(Predicate<String> predicate) {
        for (String item: conversionCRDs) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingConversionCRD(Predicate<String> predicate) {
        for (String item: conversionCRDs) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withConversionCRDs(List<String> conversionCRDs) {
        if (this.conversionCRDs != null) { _visitables.get("conversionCRDs").removeAll(this.conversionCRDs);}
        if (conversionCRDs != null) {this.conversionCRDs = new ArrayList<String>(); for (String item : conversionCRDs){this.addToConversionCRDs(item);}} else { this.conversionCRDs = null;} return (A) this;
    }

    public A withConversionCRDs(String... conversionCRDs) {
        if (this.conversionCRDs != null) {this.conversionCRDs.clear();}
        if (conversionCRDs != null) {for (String item :conversionCRDs){ this.addToConversionCRDs(item);}} return (A) this;
    }

    public Boolean hasConversionCRDs() {
        return conversionCRDs != null && !conversionCRDs.isEmpty();
    }

    public A addNewConversionCRD(StringBuilder arg1) {
        return (A)addToConversionCRDs(new String(arg1));
    }

    public A addNewConversionCRD(int[] arg1,int arg2,int arg3) {
        return (A)addToConversionCRDs(new String(arg1, arg2, arg3));
    }

    public A addNewConversionCRD(char[] arg1) {
        return (A)addToConversionCRDs(new String(arg1));
    }

    public A addNewConversionCRD(StringBuffer arg1) {
        return (A)addToConversionCRDs(new String(arg1));
    }

    public A addNewConversionCRD(byte[] arg1,int arg2) {
        return (A)addToConversionCRDs(new String(arg1, arg2));
    }

    public A addNewConversionCRD(byte[] arg1) {
        return (A)addToConversionCRDs(new String(arg1));
    }

    public A addNewConversionCRD(char[] arg1,int arg2,int arg3) {
        return (A)addToConversionCRDs(new String(arg1, arg2, arg3));
    }

    public A addNewConversionCRD(byte[] arg1,int arg2,int arg3) {
        return (A)addToConversionCRDs(new String(arg1, arg2, arg3));
    }

    public A addNewConversionCRD(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)addToConversionCRDs(new String(arg1, arg2, arg3, arg4));
    }

    public A addNewConversionCRD(String arg1) {
        return (A)addToConversionCRDs(new String(arg1));
    }

    public String getDeploymentName() {
        return this.deploymentName;
    }

    public A withDeploymentName(String deploymentName) {
        this.deploymentName=deploymentName; return (A) this;
    }

    public Boolean hasDeploymentName() {
        return this.deploymentName != null;
    }

    public A withNewDeploymentName(StringBuilder arg1) {
        return (A)withDeploymentName(new String(arg1));
    }

    public A withNewDeploymentName(int[] arg1,int arg2,int arg3) {
        return (A)withDeploymentName(new String(arg1, arg2, arg3));
    }

    public A withNewDeploymentName(char[] arg1) {
        return (A)withDeploymentName(new String(arg1));
    }

    public A withNewDeploymentName(StringBuffer arg1) {
        return (A)withDeploymentName(new String(arg1));
    }

    public A withNewDeploymentName(byte[] arg1,int arg2) {
        return (A)withDeploymentName(new String(arg1, arg2));
    }

    public A withNewDeploymentName(byte[] arg1) {
        return (A)withDeploymentName(new String(arg1));
    }

    public A withNewDeploymentName(char[] arg1,int arg2,int arg3) {
        return (A)withDeploymentName(new String(arg1, arg2, arg3));
    }

    public A withNewDeploymentName(byte[] arg1,int arg2,int arg3) {
        return (A)withDeploymentName(new String(arg1, arg2, arg3));
    }

    public A withNewDeploymentName(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withDeploymentName(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewDeploymentName(String arg1) {
        return (A)withDeploymentName(new String(arg1));
    }

    public String getFailurePolicy() {
        return this.failurePolicy;
    }

    public A withFailurePolicy(String failurePolicy) {
        this.failurePolicy=failurePolicy; return (A) this;
    }

    public Boolean hasFailurePolicy() {
        return this.failurePolicy != null;
    }

    public A withNewFailurePolicy(StringBuilder arg1) {
        return (A)withFailurePolicy(new String(arg1));
    }

    public A withNewFailurePolicy(int[] arg1,int arg2,int arg3) {
        return (A)withFailurePolicy(new String(arg1, arg2, arg3));
    }

    public A withNewFailurePolicy(char[] arg1) {
        return (A)withFailurePolicy(new String(arg1));
    }

    public A withNewFailurePolicy(StringBuffer arg1) {
        return (A)withFailurePolicy(new String(arg1));
    }

    public A withNewFailurePolicy(byte[] arg1,int arg2) {
        return (A)withFailurePolicy(new String(arg1, arg2));
    }

    public A withNewFailurePolicy(byte[] arg1) {
        return (A)withFailurePolicy(new String(arg1));
    }

    public A withNewFailurePolicy(char[] arg1,int arg2,int arg3) {
        return (A)withFailurePolicy(new String(arg1, arg2, arg3));
    }

    public A withNewFailurePolicy(byte[] arg1,int arg2,int arg3) {
        return (A)withFailurePolicy(new String(arg1, arg2, arg3));
    }

    public A withNewFailurePolicy(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withFailurePolicy(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewFailurePolicy(String arg1) {
        return (A)withFailurePolicy(new String(arg1));
    }

    public String getGenerateName() {
        return this.generateName;
    }

    public A withGenerateName(String generateName) {
        this.generateName=generateName; return (A) this;
    }

    public Boolean hasGenerateName() {
        return this.generateName != null;
    }

    public A withNewGenerateName(StringBuilder arg1) {
        return (A)withGenerateName(new String(arg1));
    }

    public A withNewGenerateName(int[] arg1,int arg2,int arg3) {
        return (A)withGenerateName(new String(arg1, arg2, arg3));
    }

    public A withNewGenerateName(char[] arg1) {
        return (A)withGenerateName(new String(arg1));
    }

    public A withNewGenerateName(StringBuffer arg1) {
        return (A)withGenerateName(new String(arg1));
    }

    public A withNewGenerateName(byte[] arg1,int arg2) {
        return (A)withGenerateName(new String(arg1, arg2));
    }

    public A withNewGenerateName(byte[] arg1) {
        return (A)withGenerateName(new String(arg1));
    }

    public A withNewGenerateName(char[] arg1,int arg2,int arg3) {
        return (A)withGenerateName(new String(arg1, arg2, arg3));
    }

    public A withNewGenerateName(byte[] arg1,int arg2,int arg3) {
        return (A)withGenerateName(new String(arg1, arg2, arg3));
    }

    public A withNewGenerateName(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withGenerateName(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewGenerateName(String arg1) {
        return (A)withGenerateName(new String(arg1));
    }

    public String getMatchPolicy() {
        return this.matchPolicy;
    }

    public A withMatchPolicy(String matchPolicy) {
        this.matchPolicy=matchPolicy; return (A) this;
    }

    public Boolean hasMatchPolicy() {
        return this.matchPolicy != null;
    }

    public A withNewMatchPolicy(StringBuilder arg1) {
        return (A)withMatchPolicy(new String(arg1));
    }

    public A withNewMatchPolicy(int[] arg1,int arg2,int arg3) {
        return (A)withMatchPolicy(new String(arg1, arg2, arg3));
    }

    public A withNewMatchPolicy(char[] arg1) {
        return (A)withMatchPolicy(new String(arg1));
    }

    public A withNewMatchPolicy(StringBuffer arg1) {
        return (A)withMatchPolicy(new String(arg1));
    }

    public A withNewMatchPolicy(byte[] arg1,int arg2) {
        return (A)withMatchPolicy(new String(arg1, arg2));
    }

    public A withNewMatchPolicy(byte[] arg1) {
        return (A)withMatchPolicy(new String(arg1));
    }

    public A withNewMatchPolicy(char[] arg1,int arg2,int arg3) {
        return (A)withMatchPolicy(new String(arg1, arg2, arg3));
    }

    public A withNewMatchPolicy(byte[] arg1,int arg2,int arg3) {
        return (A)withMatchPolicy(new String(arg1, arg2, arg3));
    }

    public A withNewMatchPolicy(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withMatchPolicy(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewMatchPolicy(String arg1) {
        return (A)withMatchPolicy(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildObjectSelector instead.
 * @return The buildable object.
 */
@Deprecated public LabelSelector getObjectSelector() {
        return this.objectSelector!=null?this.objectSelector.build():null;
    }

    public LabelSelector buildObjectSelector() {
        return this.objectSelector!=null?this.objectSelector.build():null;
    }

    public A withObjectSelector(LabelSelector objectSelector) {
        _visitables.get("objectSelector").remove(this.objectSelector);
        if (objectSelector!=null){ this.objectSelector= new LabelSelectorBuilder(objectSelector); _visitables.get("objectSelector").add(this.objectSelector);} return (A) this;
    }

    public Boolean hasObjectSelector() {
        return this.objectSelector != null;
    }

    public io.fabric8.openshift.api.model.operatorhub.v1alpha1.WebhookDescriptionFluent.ObjectSelectorNested<A> withNewObjectSelector() {
        return new ObjectSelectorNestedImpl();
    }

    public io.fabric8.openshift.api.model.operatorhub.v1alpha1.WebhookDescriptionFluent.ObjectSelectorNested<A> withNewObjectSelectorLike(LabelSelector item) {
        return new ObjectSelectorNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.operatorhub.v1alpha1.WebhookDescriptionFluent.ObjectSelectorNested<A> editObjectSelector() {
        return withNewObjectSelectorLike(getObjectSelector());
    }

    public io.fabric8.openshift.api.model.operatorhub.v1alpha1.WebhookDescriptionFluent.ObjectSelectorNested<A> editOrNewObjectSelector() {
        return withNewObjectSelectorLike(getObjectSelector() != null ? getObjectSelector(): new LabelSelectorBuilder().build());
    }

    public io.fabric8.openshift.api.model.operatorhub.v1alpha1.WebhookDescriptionFluent.ObjectSelectorNested<A> editOrNewObjectSelectorLike(LabelSelector item) {
        return withNewObjectSelectorLike(getObjectSelector() != null ? getObjectSelector(): item);
    }

    public String getReinvocationPolicy() {
        return this.reinvocationPolicy;
    }

    public A withReinvocationPolicy(String reinvocationPolicy) {
        this.reinvocationPolicy=reinvocationPolicy; return (A) this;
    }

    public Boolean hasReinvocationPolicy() {
        return this.reinvocationPolicy != null;
    }

    public A withNewReinvocationPolicy(StringBuilder arg1) {
        return (A)withReinvocationPolicy(new String(arg1));
    }

    public A withNewReinvocationPolicy(int[] arg1,int arg2,int arg3) {
        return (A)withReinvocationPolicy(new String(arg1, arg2, arg3));
    }

    public A withNewReinvocationPolicy(char[] arg1) {
        return (A)withReinvocationPolicy(new String(arg1));
    }

    public A withNewReinvocationPolicy(StringBuffer arg1) {
        return (A)withReinvocationPolicy(new String(arg1));
    }

    public A withNewReinvocationPolicy(byte[] arg1,int arg2) {
        return (A)withReinvocationPolicy(new String(arg1, arg2));
    }

    public A withNewReinvocationPolicy(byte[] arg1) {
        return (A)withReinvocationPolicy(new String(arg1));
    }

    public A withNewReinvocationPolicy(char[] arg1,int arg2,int arg3) {
        return (A)withReinvocationPolicy(new String(arg1, arg2, arg3));
    }

    public A withNewReinvocationPolicy(byte[] arg1,int arg2,int arg3) {
        return (A)withReinvocationPolicy(new String(arg1, arg2, arg3));
    }

    public A withNewReinvocationPolicy(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withReinvocationPolicy(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewReinvocationPolicy(String arg1) {
        return (A)withReinvocationPolicy(new String(arg1));
    }

    public A addToRules(int index,RuleWithOperations item) {
        if (this.rules == null) {this.rules = new ArrayList<RuleWithOperations>();}
        this.rules.add(index, item);
        return (A)this;
    }

    public A setToRules(int index,RuleWithOperations item) {
        if (this.rules == null) {this.rules = new ArrayList<RuleWithOperations>();}
        this.rules.set(index, item); return (A)this;
    }

    public A addToRules(RuleWithOperations... items) {
        if (this.rules == null) {this.rules = new ArrayList<RuleWithOperations>();}
        for (RuleWithOperations item : items) {this.rules.add(item);} return (A)this;
    }

    public A addAllToRules(Collection<RuleWithOperations> items) {
        if (this.rules == null) {this.rules = new ArrayList<RuleWithOperations>();}
        for (RuleWithOperations item : items) {this.rules.add(item);} return (A)this;
    }

    public A removeFromRules(RuleWithOperations... items) {
        for (RuleWithOperations item : items) {if (this.rules!= null){ this.rules.remove(item);}} return (A)this;
    }

    public A removeAllFromRules(Collection<RuleWithOperations> items) {
        for (RuleWithOperations item : items) {if (this.rules!= null){ this.rules.remove(item);}} return (A)this;
    }

    public List<RuleWithOperations> getRules() {
        return this.rules;
    }

    public RuleWithOperations getRule(int index) {
        return this.rules.get(index);
    }

    public RuleWithOperations getFirstRule() {
        return this.rules.get(0);
    }

    public RuleWithOperations getLastRule() {
        return this.rules.get(rules.size() - 1);
    }

    public RuleWithOperations getMatchingRule(Predicate<RuleWithOperations> predicate) {
        for (RuleWithOperations item: rules) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingRule(Predicate<RuleWithOperations> predicate) {
        for (RuleWithOperations item: rules) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withRules(List<RuleWithOperations> rules) {
        if (this.rules != null) { _visitables.get("rules").removeAll(this.rules);}
        if (rules != null) {this.rules = new ArrayList<RuleWithOperations>(); for (RuleWithOperations item : rules){this.addToRules(item);}} else { this.rules = null;} return (A) this;
    }

    public A withRules(RuleWithOperations... rules) {
        if (this.rules != null) {this.rules.clear();}
        if (rules != null) {for (RuleWithOperations item :rules){ this.addToRules(item);}} return (A) this;
    }

    public Boolean hasRules() {
        return rules != null && !rules.isEmpty();
    }

    public String getSideEffects() {
        return this.sideEffects;
    }

    public A withSideEffects(String sideEffects) {
        this.sideEffects=sideEffects; return (A) this;
    }

    public Boolean hasSideEffects() {
        return this.sideEffects != null;
    }

    public A withNewSideEffects(StringBuilder arg1) {
        return (A)withSideEffects(new String(arg1));
    }

    public A withNewSideEffects(int[] arg1,int arg2,int arg3) {
        return (A)withSideEffects(new String(arg1, arg2, arg3));
    }

    public A withNewSideEffects(char[] arg1) {
        return (A)withSideEffects(new String(arg1));
    }

    public A withNewSideEffects(StringBuffer arg1) {
        return (A)withSideEffects(new String(arg1));
    }

    public A withNewSideEffects(byte[] arg1,int arg2) {
        return (A)withSideEffects(new String(arg1, arg2));
    }

    public A withNewSideEffects(byte[] arg1) {
        return (A)withSideEffects(new String(arg1));
    }

    public A withNewSideEffects(char[] arg1,int arg2,int arg3) {
        return (A)withSideEffects(new String(arg1, arg2, arg3));
    }

    public A withNewSideEffects(byte[] arg1,int arg2,int arg3) {
        return (A)withSideEffects(new String(arg1, arg2, arg3));
    }

    public A withNewSideEffects(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withSideEffects(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewSideEffects(String arg1) {
        return (A)withSideEffects(new String(arg1));
    }

    public Integer getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    public A withTimeoutSeconds(Integer timeoutSeconds) {
        this.timeoutSeconds=timeoutSeconds; return (A) this;
    }

    public Boolean hasTimeoutSeconds() {
        return this.timeoutSeconds != null;
    }

    public A withNewTimeoutSeconds(int arg0) {
        return (A)withTimeoutSeconds(new Integer(arg0));
    }

    public String getType() {
        return this.type;
    }

    public A withType(String type) {
        this.type=type; return (A) this;
    }

    public Boolean hasType() {
        return this.type != null;
    }

    public A withNewType(StringBuilder arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(int[] arg1,int arg2,int arg3) {
        return (A)withType(new String(arg1, arg2, arg3));
    }

    public A withNewType(char[] arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(StringBuffer arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(byte[] arg1,int arg2) {
        return (A)withType(new String(arg1, arg2));
    }

    public A withNewType(byte[] arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(char[] arg1,int arg2,int arg3) {
        return (A)withType(new String(arg1, arg2, arg3));
    }

    public A withNewType(byte[] arg1,int arg2,int arg3) {
        return (A)withType(new String(arg1, arg2, arg3));
    }

    public A withNewType(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withType(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewType(String arg1) {
        return (A)withType(new String(arg1));
    }

    public String getWebhookPath() {
        return this.webhookPath;
    }

    public A withWebhookPath(String webhookPath) {
        this.webhookPath=webhookPath; return (A) this;
    }

    public Boolean hasWebhookPath() {
        return this.webhookPath != null;
    }

    public A withNewWebhookPath(StringBuilder arg1) {
        return (A)withWebhookPath(new String(arg1));
    }

    public A withNewWebhookPath(int[] arg1,int arg2,int arg3) {
        return (A)withWebhookPath(new String(arg1, arg2, arg3));
    }

    public A withNewWebhookPath(char[] arg1) {
        return (A)withWebhookPath(new String(arg1));
    }

    public A withNewWebhookPath(StringBuffer arg1) {
        return (A)withWebhookPath(new String(arg1));
    }

    public A withNewWebhookPath(byte[] arg1,int arg2) {
        return (A)withWebhookPath(new String(arg1, arg2));
    }

    public A withNewWebhookPath(byte[] arg1) {
        return (A)withWebhookPath(new String(arg1));
    }

    public A withNewWebhookPath(char[] arg1,int arg2,int arg3) {
        return (A)withWebhookPath(new String(arg1, arg2, arg3));
    }

    public A withNewWebhookPath(byte[] arg1,int arg2,int arg3) {
        return (A)withWebhookPath(new String(arg1, arg2, arg3));
    }

    public A withNewWebhookPath(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withWebhookPath(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewWebhookPath(String arg1) {
        return (A)withWebhookPath(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        WebhookDescriptionFluentImpl that = (WebhookDescriptionFluentImpl) o;
        if (admissionReviewVersions != null ? !admissionReviewVersions.equals(that.admissionReviewVersions) :that.admissionReviewVersions != null) return false;
        if (containerPort != null ? !containerPort.equals(that.containerPort) :that.containerPort != null) return false;
        if (conversionCRDs != null ? !conversionCRDs.equals(that.conversionCRDs) :that.conversionCRDs != null) return false;
        if (deploymentName != null ? !deploymentName.equals(that.deploymentName) :that.deploymentName != null) return false;
        if (failurePolicy != null ? !failurePolicy.equals(that.failurePolicy) :that.failurePolicy != null) return false;
        if (generateName != null ? !generateName.equals(that.generateName) :that.generateName != null) return false;
        if (matchPolicy != null ? !matchPolicy.equals(that.matchPolicy) :that.matchPolicy != null) return false;
        if (objectSelector != null ? !objectSelector.equals(that.objectSelector) :that.objectSelector != null) return false;
        if (reinvocationPolicy != null ? !reinvocationPolicy.equals(that.reinvocationPolicy) :that.reinvocationPolicy != null) return false;
        if (rules != null ? !rules.equals(that.rules) :that.rules != null) return false;
        if (sideEffects != null ? !sideEffects.equals(that.sideEffects) :that.sideEffects != null) return false;
        if (timeoutSeconds != null ? !timeoutSeconds.equals(that.timeoutSeconds) :that.timeoutSeconds != null) return false;
        if (type != null ? !type.equals(that.type) :that.type != null) return false;
        if (webhookPath != null ? !webhookPath.equals(that.webhookPath) :that.webhookPath != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(admissionReviewVersions,  containerPort,  conversionCRDs,  deploymentName,  failurePolicy,  generateName,  matchPolicy,  objectSelector,  reinvocationPolicy,  rules,  sideEffects,  timeoutSeconds,  type,  webhookPath,  super.hashCode());
    }

    public class ObjectSelectorNestedImpl<N> extends LabelSelectorFluentImpl<io.fabric8.openshift.api.model.operatorhub.v1alpha1.WebhookDescriptionFluent.ObjectSelectorNested<N>> implements io.fabric8.openshift.api.model.operatorhub.v1alpha1.WebhookDescriptionFluent.ObjectSelectorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final LabelSelectorBuilder builder;

            ObjectSelectorNestedImpl(LabelSelector item) {
                this.builder = new LabelSelectorBuilder(this, item);
                        
            }

            ObjectSelectorNestedImpl() {
                this.builder = new LabelSelectorBuilder(this);
                        
            }

            public N and() {
                return (N) WebhookDescriptionFluentImpl.this.withObjectSelector(builder.build());
            }

            public N endObjectSelector() {
                return and();
            }
    }


}
