package io.fabric8.openshift.api.model.operatorhub.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class OperatorBuilder extends io.fabric8.openshift.api.model.operatorhub.v1.OperatorFluentImpl<io.fabric8.openshift.api.model.operatorhub.v1.OperatorBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.operatorhub.v1.Operator,io.fabric8.openshift.api.model.operatorhub.v1.OperatorBuilder> {

    io.fabric8.openshift.api.model.operatorhub.v1.OperatorFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public OperatorBuilder() {
        this(true);
    }

    public OperatorBuilder(java.lang.Boolean validationEnabled) {
        this(new Operator(), validationEnabled);
    }

    public OperatorBuilder(io.fabric8.openshift.api.model.operatorhub.v1.OperatorFluent<?> fluent) {
        this(fluent, true);
    }

    public OperatorBuilder(io.fabric8.openshift.api.model.operatorhub.v1.OperatorFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new Operator(), validationEnabled);
    }

    public OperatorBuilder(io.fabric8.openshift.api.model.operatorhub.v1.OperatorFluent<?> fluent,io.fabric8.openshift.api.model.operatorhub.v1.Operator instance) {
        this(fluent, instance, true);
    }

    public OperatorBuilder(io.fabric8.openshift.api.model.operatorhub.v1.OperatorFluent<?> fluent,io.fabric8.openshift.api.model.operatorhub.v1.Operator instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        fluent.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public OperatorBuilder(io.fabric8.openshift.api.model.operatorhub.v1.Operator instance) {
        this(instance,true);
    }

    public OperatorBuilder(io.fabric8.openshift.api.model.operatorhub.v1.Operator instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.operatorhub.v1.Operator build() {
        Operator buildable = new Operator(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        OperatorBuilder that = (OperatorBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
