package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.model.admissionregistration.v1.RuleWithOperations;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.IntOrStringFluentImpl;

public class WebhookDescriptionFluentImpl<A extends io.fabric8.openshift.api.model.operatorhub.v1alpha1.WebhookDescriptionFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.operatorhub.v1alpha1.WebhookDescriptionFluent<A> {

    private java.util.List<java.lang.String> admissionReviewVersions = new java.util.ArrayList<java.lang.String>();
    private java.lang.Integer containerPort;
    private java.util.List<java.lang.String> conversionCRDs = new java.util.ArrayList<java.lang.String>();
    private java.lang.String deploymentName;
    private java.lang.String failurePolicy;
    private java.lang.String generateName;
    private java.lang.String matchPolicy;
    private io.fabric8.kubernetes.api.model.LabelSelectorBuilder objectSelector;
    private java.lang.String reinvocationPolicy;
    private java.util.List<io.fabric8.kubernetes.api.model.admissionregistration.v1.RuleWithOperations> rules = new java.util.ArrayList<io.fabric8.kubernetes.api.model.admissionregistration.v1.RuleWithOperations>();
    private java.lang.String sideEffects;
    private io.fabric8.kubernetes.api.model.IntOrStringBuilder targetPort;
    private java.lang.Integer timeoutSeconds;
    private java.lang.String type;
    private java.lang.String webhookPath;

    public WebhookDescriptionFluentImpl() {
    }

    public WebhookDescriptionFluentImpl(io.fabric8.openshift.api.model.operatorhub.v1alpha1.WebhookDescription instance) {
        this.withAdmissionReviewVersions(instance.getAdmissionReviewVersions()); 
        this.withContainerPort(instance.getContainerPort()); 
        this.withConversionCRDs(instance.getConversionCRDs()); 
        this.withDeploymentName(instance.getDeploymentName()); 
        this.withFailurePolicy(instance.getFailurePolicy()); 
        this.withGenerateName(instance.getGenerateName()); 
        this.withMatchPolicy(instance.getMatchPolicy()); 
        this.withObjectSelector(instance.getObjectSelector()); 
        this.withReinvocationPolicy(instance.getReinvocationPolicy()); 
        this.withRules(instance.getRules()); 
        this.withSideEffects(instance.getSideEffects()); 
        this.withTargetPort(instance.getTargetPort()); 
        this.withTimeoutSeconds(instance.getTimeoutSeconds()); 
        this.withType(instance.getType()); 
        this.withWebhookPath(instance.getWebhookPath()); 
    }

    public A addToAdmissionReviewVersions(int index,java.lang.String item) {
        if (this.admissionReviewVersions == null) {this.admissionReviewVersions = new java.util.ArrayList<java.lang.String>();}
        this.admissionReviewVersions.add(index, item);
        return (A)this;
    }

    public A setToAdmissionReviewVersions(int index,java.lang.String item) {
        if (this.admissionReviewVersions == null) {this.admissionReviewVersions = new java.util.ArrayList<java.lang.String>();}
        this.admissionReviewVersions.set(index, item); return (A)this;
    }

    public A addToAdmissionReviewVersions(java.lang.String... items) {
        if (this.admissionReviewVersions == null) {this.admissionReviewVersions = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.admissionReviewVersions.add(item);} return (A)this;
    }

    public A addAllToAdmissionReviewVersions(java.util.Collection<java.lang.String> items) {
        if (this.admissionReviewVersions == null) {this.admissionReviewVersions = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.admissionReviewVersions.add(item);} return (A)this;
    }

    public A removeFromAdmissionReviewVersions(java.lang.String... items) {
        for (java.lang.String item : items) {if (this.admissionReviewVersions!= null){ this.admissionReviewVersions.remove(item);}} return (A)this;
    }

    public A removeAllFromAdmissionReviewVersions(java.util.Collection<java.lang.String> items) {
        for (java.lang.String item : items) {if (this.admissionReviewVersions!= null){ this.admissionReviewVersions.remove(item);}} return (A)this;
    }

    public java.util.List<java.lang.String> getAdmissionReviewVersions() {
        return this.admissionReviewVersions;
    }

    public java.lang.String getAdmissionReviewVersion(int index) {
        return this.admissionReviewVersions.get(index);
    }

    public java.lang.String getFirstAdmissionReviewVersion() {
        return this.admissionReviewVersions.get(0);
    }

    public java.lang.String getLastAdmissionReviewVersion() {
        return this.admissionReviewVersions.get(admissionReviewVersions.size() - 1);
    }

    public java.lang.String getMatchingAdmissionReviewVersion(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: admissionReviewVersions) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingAdmissionReviewVersion(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: admissionReviewVersions) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withAdmissionReviewVersions(java.util.List<java.lang.String> admissionReviewVersions) {
        if (this.admissionReviewVersions != null) { _visitables.get("admissionReviewVersions").removeAll(this.admissionReviewVersions);}
        if (admissionReviewVersions != null) {this.admissionReviewVersions = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : admissionReviewVersions){this.addToAdmissionReviewVersions(item);}} else { this.admissionReviewVersions = null;} return (A) this;
    }

    public A withAdmissionReviewVersions(java.lang.String... admissionReviewVersions) {
        if (this.admissionReviewVersions != null) {this.admissionReviewVersions.clear();}
        if (admissionReviewVersions != null) {for (java.lang.String item :admissionReviewVersions){ this.addToAdmissionReviewVersions(item);}} return (A) this;
    }

    public java.lang.Boolean hasAdmissionReviewVersions() {
        return admissionReviewVersions != null && !admissionReviewVersions.isEmpty();
    }

    public A addNewAdmissionReviewVersion(java.lang.String arg0) {
        return (A)addToAdmissionReviewVersions(new String(arg0));
    }

    public java.lang.Integer getContainerPort() {
        return this.containerPort;
    }

    public A withContainerPort(java.lang.Integer containerPort) {
        this.containerPort=containerPort; return (A) this;
    }

    public java.lang.Boolean hasContainerPort() {
        return this.containerPort != null;
    }

    public A addToConversionCRDs(int index,java.lang.String item) {
        if (this.conversionCRDs == null) {this.conversionCRDs = new java.util.ArrayList<java.lang.String>();}
        this.conversionCRDs.add(index, item);
        return (A)this;
    }

    public A setToConversionCRDs(int index,java.lang.String item) {
        if (this.conversionCRDs == null) {this.conversionCRDs = new java.util.ArrayList<java.lang.String>();}
        this.conversionCRDs.set(index, item); return (A)this;
    }

    public A addToConversionCRDs(java.lang.String... items) {
        if (this.conversionCRDs == null) {this.conversionCRDs = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.conversionCRDs.add(item);} return (A)this;
    }

    public A addAllToConversionCRDs(java.util.Collection<java.lang.String> items) {
        if (this.conversionCRDs == null) {this.conversionCRDs = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.conversionCRDs.add(item);} return (A)this;
    }

    public A removeFromConversionCRDs(java.lang.String... items) {
        for (java.lang.String item : items) {if (this.conversionCRDs!= null){ this.conversionCRDs.remove(item);}} return (A)this;
    }

    public A removeAllFromConversionCRDs(java.util.Collection<java.lang.String> items) {
        for (java.lang.String item : items) {if (this.conversionCRDs!= null){ this.conversionCRDs.remove(item);}} return (A)this;
    }

    public java.util.List<java.lang.String> getConversionCRDs() {
        return this.conversionCRDs;
    }

    public java.lang.String getConversionCRD(int index) {
        return this.conversionCRDs.get(index);
    }

    public java.lang.String getFirstConversionCRD() {
        return this.conversionCRDs.get(0);
    }

    public java.lang.String getLastConversionCRD() {
        return this.conversionCRDs.get(conversionCRDs.size() - 1);
    }

    public java.lang.String getMatchingConversionCRD(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: conversionCRDs) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingConversionCRD(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: conversionCRDs) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withConversionCRDs(java.util.List<java.lang.String> conversionCRDs) {
        if (this.conversionCRDs != null) { _visitables.get("conversionCRDs").removeAll(this.conversionCRDs);}
        if (conversionCRDs != null) {this.conversionCRDs = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : conversionCRDs){this.addToConversionCRDs(item);}} else { this.conversionCRDs = null;} return (A) this;
    }

    public A withConversionCRDs(java.lang.String... conversionCRDs) {
        if (this.conversionCRDs != null) {this.conversionCRDs.clear();}
        if (conversionCRDs != null) {for (java.lang.String item :conversionCRDs){ this.addToConversionCRDs(item);}} return (A) this;
    }

    public java.lang.Boolean hasConversionCRDs() {
        return conversionCRDs != null && !conversionCRDs.isEmpty();
    }

    public A addNewConversionCRD(java.lang.String arg0) {
        return (A)addToConversionCRDs(new String(arg0));
    }

    public java.lang.String getDeploymentName() {
        return this.deploymentName;
    }

    public A withDeploymentName(java.lang.String deploymentName) {
        this.deploymentName=deploymentName; return (A) this;
    }

    public java.lang.Boolean hasDeploymentName() {
        return this.deploymentName != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withDeploymentName instead.
     */
        public A withNewDeploymentName(java.lang.String arg0) {
        return (A)withDeploymentName(new String(arg0));
    }

    public java.lang.String getFailurePolicy() {
        return this.failurePolicy;
    }

    public A withFailurePolicy(java.lang.String failurePolicy) {
        this.failurePolicy=failurePolicy; return (A) this;
    }

    public java.lang.Boolean hasFailurePolicy() {
        return this.failurePolicy != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withFailurePolicy instead.
     */
        public A withNewFailurePolicy(java.lang.String arg0) {
        return (A)withFailurePolicy(new String(arg0));
    }

    public java.lang.String getGenerateName() {
        return this.generateName;
    }

    public A withGenerateName(java.lang.String generateName) {
        this.generateName=generateName; return (A) this;
    }

    public java.lang.Boolean hasGenerateName() {
        return this.generateName != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withGenerateName instead.
     */
        public A withNewGenerateName(java.lang.String arg0) {
        return (A)withGenerateName(new String(arg0));
    }

    public java.lang.String getMatchPolicy() {
        return this.matchPolicy;
    }

    public A withMatchPolicy(java.lang.String matchPolicy) {
        this.matchPolicy=matchPolicy; return (A) this;
    }

    public java.lang.Boolean hasMatchPolicy() {
        return this.matchPolicy != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withMatchPolicy instead.
     */
        public A withNewMatchPolicy(java.lang.String arg0) {
        return (A)withMatchPolicy(new String(arg0));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildObjectSelector instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.LabelSelector getObjectSelector() {
        return this.objectSelector!=null?this.objectSelector.build():null;
    }

    public io.fabric8.kubernetes.api.model.LabelSelector buildObjectSelector() {
        return this.objectSelector!=null?this.objectSelector.build():null;
    }

    public A withObjectSelector(io.fabric8.kubernetes.api.model.LabelSelector objectSelector) {
        _visitables.get("objectSelector").remove(this.objectSelector);
        if (objectSelector!=null){ this.objectSelector= new io.fabric8.kubernetes.api.model.LabelSelectorBuilder(objectSelector); _visitables.get("objectSelector").add(this.objectSelector);} return (A) this;
    }

    public java.lang.Boolean hasObjectSelector() {
        return this.objectSelector != null;
    }

    public io.fabric8.openshift.api.model.operatorhub.v1alpha1.WebhookDescriptionFluent.ObjectSelectorNested<A> withNewObjectSelector() {
        return new io.fabric8.openshift.api.model.operatorhub.v1alpha1.WebhookDescriptionFluentImpl.ObjectSelectorNestedImpl();
    }

    public io.fabric8.openshift.api.model.operatorhub.v1alpha1.WebhookDescriptionFluent.ObjectSelectorNested<A> withNewObjectSelectorLike(io.fabric8.kubernetes.api.model.LabelSelector item) {
        return new io.fabric8.openshift.api.model.operatorhub.v1alpha1.WebhookDescriptionFluentImpl.ObjectSelectorNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.operatorhub.v1alpha1.WebhookDescriptionFluent.ObjectSelectorNested<A> editObjectSelector() {
        return withNewObjectSelectorLike(getObjectSelector());
    }

    public io.fabric8.openshift.api.model.operatorhub.v1alpha1.WebhookDescriptionFluent.ObjectSelectorNested<A> editOrNewObjectSelector() {
        return withNewObjectSelectorLike(getObjectSelector() != null ? getObjectSelector(): new io.fabric8.kubernetes.api.model.LabelSelectorBuilder().build());
    }

    public io.fabric8.openshift.api.model.operatorhub.v1alpha1.WebhookDescriptionFluent.ObjectSelectorNested<A> editOrNewObjectSelectorLike(io.fabric8.kubernetes.api.model.LabelSelector item) {
        return withNewObjectSelectorLike(getObjectSelector() != null ? getObjectSelector(): item);
    }

    public java.lang.String getReinvocationPolicy() {
        return this.reinvocationPolicy;
    }

    public A withReinvocationPolicy(java.lang.String reinvocationPolicy) {
        this.reinvocationPolicy=reinvocationPolicy; return (A) this;
    }

    public java.lang.Boolean hasReinvocationPolicy() {
        return this.reinvocationPolicy != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withReinvocationPolicy instead.
     */
        public A withNewReinvocationPolicy(java.lang.String arg0) {
        return (A)withReinvocationPolicy(new String(arg0));
    }

    public A addToRules(int index,io.fabric8.kubernetes.api.model.admissionregistration.v1.RuleWithOperations item) {
        if (this.rules == null) {this.rules = new java.util.ArrayList<io.fabric8.kubernetes.api.model.admissionregistration.v1.RuleWithOperations>();}
        this.rules.add(index, item);
        return (A)this;
    }

    public A setToRules(int index,io.fabric8.kubernetes.api.model.admissionregistration.v1.RuleWithOperations item) {
        if (this.rules == null) {this.rules = new java.util.ArrayList<io.fabric8.kubernetes.api.model.admissionregistration.v1.RuleWithOperations>();}
        this.rules.set(index, item); return (A)this;
    }

    public A addToRules(io.fabric8.kubernetes.api.model.admissionregistration.v1.RuleWithOperations... items) {
        if (this.rules == null) {this.rules = new java.util.ArrayList<io.fabric8.kubernetes.api.model.admissionregistration.v1.RuleWithOperations>();}
        for (io.fabric8.kubernetes.api.model.admissionregistration.v1.RuleWithOperations item : items) {this.rules.add(item);} return (A)this;
    }

    public A addAllToRules(java.util.Collection<io.fabric8.kubernetes.api.model.admissionregistration.v1.RuleWithOperations> items) {
        if (this.rules == null) {this.rules = new java.util.ArrayList<io.fabric8.kubernetes.api.model.admissionregistration.v1.RuleWithOperations>();}
        for (io.fabric8.kubernetes.api.model.admissionregistration.v1.RuleWithOperations item : items) {this.rules.add(item);} return (A)this;
    }

    public A removeFromRules(io.fabric8.kubernetes.api.model.admissionregistration.v1.RuleWithOperations... items) {
        for (io.fabric8.kubernetes.api.model.admissionregistration.v1.RuleWithOperations item : items) {if (this.rules!= null){ this.rules.remove(item);}} return (A)this;
    }

    public A removeAllFromRules(java.util.Collection<io.fabric8.kubernetes.api.model.admissionregistration.v1.RuleWithOperations> items) {
        for (io.fabric8.kubernetes.api.model.admissionregistration.v1.RuleWithOperations item : items) {if (this.rules!= null){ this.rules.remove(item);}} return (A)this;
    }

    public java.util.List<io.fabric8.kubernetes.api.model.admissionregistration.v1.RuleWithOperations> getRules() {
        return this.rules;
    }

    public io.fabric8.kubernetes.api.model.admissionregistration.v1.RuleWithOperations getRule(int index) {
        return this.rules.get(index);
    }

    public io.fabric8.kubernetes.api.model.admissionregistration.v1.RuleWithOperations getFirstRule() {
        return this.rules.get(0);
    }

    public io.fabric8.kubernetes.api.model.admissionregistration.v1.RuleWithOperations getLastRule() {
        return this.rules.get(rules.size() - 1);
    }

    public io.fabric8.kubernetes.api.model.admissionregistration.v1.RuleWithOperations getMatchingRule(java.util.function.Predicate<io.fabric8.kubernetes.api.model.admissionregistration.v1.RuleWithOperations> predicate) {
        for (io.fabric8.kubernetes.api.model.admissionregistration.v1.RuleWithOperations item: rules) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingRule(java.util.function.Predicate<io.fabric8.kubernetes.api.model.admissionregistration.v1.RuleWithOperations> predicate) {
        for (io.fabric8.kubernetes.api.model.admissionregistration.v1.RuleWithOperations item: rules) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withRules(java.util.List<io.fabric8.kubernetes.api.model.admissionregistration.v1.RuleWithOperations> rules) {
        if (this.rules != null) { _visitables.get("rules").removeAll(this.rules);}
        if (rules != null) {this.rules = new java.util.ArrayList<io.fabric8.kubernetes.api.model.admissionregistration.v1.RuleWithOperations>(); for (io.fabric8.kubernetes.api.model.admissionregistration.v1.RuleWithOperations item : rules){this.addToRules(item);}} else { this.rules = null;} return (A) this;
    }

    public A withRules(io.fabric8.kubernetes.api.model.admissionregistration.v1.RuleWithOperations... rules) {
        if (this.rules != null) {this.rules.clear();}
        if (rules != null) {for (io.fabric8.kubernetes.api.model.admissionregistration.v1.RuleWithOperations item :rules){ this.addToRules(item);}} return (A) this;
    }

    public java.lang.Boolean hasRules() {
        return rules != null && !rules.isEmpty();
    }

    public java.lang.String getSideEffects() {
        return this.sideEffects;
    }

    public A withSideEffects(java.lang.String sideEffects) {
        this.sideEffects=sideEffects; return (A) this;
    }

    public java.lang.Boolean hasSideEffects() {
        return this.sideEffects != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withSideEffects instead.
     */
        public A withNewSideEffects(java.lang.String arg0) {
        return (A)withSideEffects(new String(arg0));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildTargetPort instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.IntOrString getTargetPort() {
        return this.targetPort!=null?this.targetPort.build():null;
    }

    public io.fabric8.kubernetes.api.model.IntOrString buildTargetPort() {
        return this.targetPort!=null?this.targetPort.build():null;
    }

    public A withTargetPort(io.fabric8.kubernetes.api.model.IntOrString targetPort) {
        _visitables.get("targetPort").remove(this.targetPort);
        if (targetPort!=null){ this.targetPort= new io.fabric8.kubernetes.api.model.IntOrStringBuilder(targetPort); _visitables.get("targetPort").add(this.targetPort);} return (A) this;
    }

    public java.lang.Boolean hasTargetPort() {
        return this.targetPort != null;
    }

    public A withNewTargetPort(java.lang.Integer intVal) {
        return (A)withTargetPort(new IntOrString(intVal));
    }

    public A withNewTargetPort(java.lang.String strVal) {
        return (A)withTargetPort(new IntOrString(strVal));
    }

    public io.fabric8.openshift.api.model.operatorhub.v1alpha1.WebhookDescriptionFluent.TargetPortNested<A> withNewTargetPort() {
        return new io.fabric8.openshift.api.model.operatorhub.v1alpha1.WebhookDescriptionFluentImpl.TargetPortNestedImpl();
    }

    public io.fabric8.openshift.api.model.operatorhub.v1alpha1.WebhookDescriptionFluent.TargetPortNested<A> withNewTargetPortLike(io.fabric8.kubernetes.api.model.IntOrString item) {
        return new io.fabric8.openshift.api.model.operatorhub.v1alpha1.WebhookDescriptionFluentImpl.TargetPortNestedImpl(item);
    }

    public io.fabric8.openshift.api.model.operatorhub.v1alpha1.WebhookDescriptionFluent.TargetPortNested<A> editTargetPort() {
        return withNewTargetPortLike(getTargetPort());
    }

    public io.fabric8.openshift.api.model.operatorhub.v1alpha1.WebhookDescriptionFluent.TargetPortNested<A> editOrNewTargetPort() {
        return withNewTargetPortLike(getTargetPort() != null ? getTargetPort(): new io.fabric8.kubernetes.api.model.IntOrStringBuilder().build());
    }

    public io.fabric8.openshift.api.model.operatorhub.v1alpha1.WebhookDescriptionFluent.TargetPortNested<A> editOrNewTargetPortLike(io.fabric8.kubernetes.api.model.IntOrString item) {
        return withNewTargetPortLike(getTargetPort() != null ? getTargetPort(): item);
    }

    public java.lang.Integer getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    public A withTimeoutSeconds(java.lang.Integer timeoutSeconds) {
        this.timeoutSeconds=timeoutSeconds; return (A) this;
    }

    public java.lang.Boolean hasTimeoutSeconds() {
        return this.timeoutSeconds != null;
    }

    public java.lang.String getType() {
        return this.type;
    }

    public A withType(java.lang.String type) {
        this.type=type; return (A) this;
    }

    public java.lang.Boolean hasType() {
        return this.type != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withType instead.
     */
        public A withNewType(java.lang.String arg0) {
        return (A)withType(new String(arg0));
    }

    public java.lang.String getWebhookPath() {
        return this.webhookPath;
    }

    public A withWebhookPath(java.lang.String webhookPath) {
        this.webhookPath=webhookPath; return (A) this;
    }

    public java.lang.Boolean hasWebhookPath() {
        return this.webhookPath != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withWebhookPath instead.
     */
        public A withNewWebhookPath(java.lang.String arg0) {
        return (A)withWebhookPath(new String(arg0));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        WebhookDescriptionFluentImpl that = (WebhookDescriptionFluentImpl) o;
        if (admissionReviewVersions != null ? !admissionReviewVersions.equals(that.admissionReviewVersions) :that.admissionReviewVersions != null) return false;
        if (containerPort != null ? !containerPort.equals(that.containerPort) :that.containerPort != null) return false;
        if (conversionCRDs != null ? !conversionCRDs.equals(that.conversionCRDs) :that.conversionCRDs != null) return false;
        if (deploymentName != null ? !deploymentName.equals(that.deploymentName) :that.deploymentName != null) return false;
        if (failurePolicy != null ? !failurePolicy.equals(that.failurePolicy) :that.failurePolicy != null) return false;
        if (generateName != null ? !generateName.equals(that.generateName) :that.generateName != null) return false;
        if (matchPolicy != null ? !matchPolicy.equals(that.matchPolicy) :that.matchPolicy != null) return false;
        if (objectSelector != null ? !objectSelector.equals(that.objectSelector) :that.objectSelector != null) return false;
        if (reinvocationPolicy != null ? !reinvocationPolicy.equals(that.reinvocationPolicy) :that.reinvocationPolicy != null) return false;
        if (rules != null ? !rules.equals(that.rules) :that.rules != null) return false;
        if (sideEffects != null ? !sideEffects.equals(that.sideEffects) :that.sideEffects != null) return false;
        if (targetPort != null ? !targetPort.equals(that.targetPort) :that.targetPort != null) return false;
        if (timeoutSeconds != null ? !timeoutSeconds.equals(that.timeoutSeconds) :that.timeoutSeconds != null) return false;
        if (type != null ? !type.equals(that.type) :that.type != null) return false;
        if (webhookPath != null ? !webhookPath.equals(that.webhookPath) :that.webhookPath != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(admissionReviewVersions,  containerPort,  conversionCRDs,  deploymentName,  failurePolicy,  generateName,  matchPolicy,  objectSelector,  reinvocationPolicy,  rules,  sideEffects,  targetPort,  timeoutSeconds,  type,  webhookPath,  super.hashCode());
    }

    public class ObjectSelectorNestedImpl<N> extends io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl<io.fabric8.openshift.api.model.operatorhub.v1alpha1.WebhookDescriptionFluent.ObjectSelectorNested<N>> implements io.fabric8.openshift.api.model.operatorhub.v1alpha1.WebhookDescriptionFluent.ObjectSelectorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.LabelSelectorBuilder builder;

            ObjectSelectorNestedImpl(io.fabric8.kubernetes.api.model.LabelSelector item) {
                this.builder = new io.fabric8.kubernetes.api.model.LabelSelectorBuilder(this, item);
                        
            }

            ObjectSelectorNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.LabelSelectorBuilder(this);
                        
            }

            public N and() {
                return (N) WebhookDescriptionFluentImpl.this.withObjectSelector(builder.build());
            }

            public N endObjectSelector() {
                return and();
            }
    }


    public class TargetPortNestedImpl<N> extends io.fabric8.kubernetes.api.model.IntOrStringFluentImpl<io.fabric8.openshift.api.model.operatorhub.v1alpha1.WebhookDescriptionFluent.TargetPortNested<N>> implements io.fabric8.openshift.api.model.operatorhub.v1alpha1.WebhookDescriptionFluent.TargetPortNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.IntOrStringBuilder builder;

            TargetPortNestedImpl(io.fabric8.kubernetes.api.model.IntOrString item) {
                this.builder = new io.fabric8.kubernetes.api.model.IntOrStringBuilder(this, item);
                        
            }

            TargetPortNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.IntOrStringBuilder(this);
                        
            }

            public N and() {
                return (N) WebhookDescriptionFluentImpl.this.withTargetPort(builder.build());
            }

            public N endTargetPort() {
                return and();
            }
    }


}
