package io.fabric8.openshift.api.model.operatorhub.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OperatorStatusBuilder extends OperatorStatusFluentImpl<OperatorStatusBuilder> implements VisitableBuilder<OperatorStatus,OperatorStatusBuilder>{
  public OperatorStatusBuilder() {
    this(false);
  }
  public OperatorStatusBuilder(Boolean validationEnabled) {
    this(new OperatorStatus(), validationEnabled);
  }
  public OperatorStatusBuilder(OperatorStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public OperatorStatusBuilder(OperatorStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new OperatorStatus(), validationEnabled);
  }
  public OperatorStatusBuilder(OperatorStatusFluent<?> fluent,OperatorStatus instance) {
    this(fluent, instance, false);
  }
  public OperatorStatusBuilder(OperatorStatusFluent<?> fluent,OperatorStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withComponents(instance.getComponents()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public OperatorStatusBuilder(OperatorStatus instance) {
    this(instance,false);
  }
  public OperatorStatusBuilder(OperatorStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withComponents(instance.getComponents()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  OperatorStatusFluent<?> fluent;
  Boolean validationEnabled;
  public OperatorStatus build() {
    OperatorStatus buildable = new OperatorStatus(fluent.getComponents());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}