package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SubscriptionConditionBuilder extends SubscriptionConditionFluentImpl<SubscriptionConditionBuilder> implements VisitableBuilder<SubscriptionCondition,SubscriptionConditionBuilder>{
  public SubscriptionConditionBuilder() {
    this(false);
  }
  public SubscriptionConditionBuilder(Boolean validationEnabled) {
    this(new SubscriptionCondition(), validationEnabled);
  }
  public SubscriptionConditionBuilder(SubscriptionConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public SubscriptionConditionBuilder(SubscriptionConditionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SubscriptionCondition(), validationEnabled);
  }
  public SubscriptionConditionBuilder(SubscriptionConditionFluent<?> fluent,SubscriptionCondition instance) {
    this(fluent, instance, false);
  }
  public SubscriptionConditionBuilder(SubscriptionConditionFluent<?> fluent,SubscriptionCondition instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withLastHeartbeatTime(instance.getLastHeartbeatTime()); 
    fluent.withLastTransitionTime(instance.getLastTransitionTime()); 
    fluent.withMessage(instance.getMessage()); 
    fluent.withReason(instance.getReason()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withType(instance.getType()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public SubscriptionConditionBuilder(SubscriptionCondition instance) {
    this(instance,false);
  }
  public SubscriptionConditionBuilder(SubscriptionCondition instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withLastHeartbeatTime(instance.getLastHeartbeatTime()); 
    this.withLastTransitionTime(instance.getLastTransitionTime()); 
    this.withMessage(instance.getMessage()); 
    this.withReason(instance.getReason()); 
    this.withStatus(instance.getStatus()); 
    this.withType(instance.getType()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  SubscriptionConditionFluent<?> fluent;
  Boolean validationEnabled;
  public SubscriptionCondition build() {
    SubscriptionCondition buildable = new SubscriptionCondition(fluent.getLastHeartbeatTime(),fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}