package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CustomResourceDefinitionsBuilder extends CustomResourceDefinitionsFluentImpl<CustomResourceDefinitionsBuilder> implements VisitableBuilder<CustomResourceDefinitions,CustomResourceDefinitionsBuilder>{
  public CustomResourceDefinitionsBuilder() {
    this(false);
  }
  public CustomResourceDefinitionsBuilder(Boolean validationEnabled) {
    this(new CustomResourceDefinitions(), validationEnabled);
  }
  public CustomResourceDefinitionsBuilder(CustomResourceDefinitionsFluent<?> fluent) {
    this(fluent, false);
  }
  public CustomResourceDefinitionsBuilder(CustomResourceDefinitionsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CustomResourceDefinitions(), validationEnabled);
  }
  public CustomResourceDefinitionsBuilder(CustomResourceDefinitionsFluent<?> fluent,CustomResourceDefinitions instance) {
    this(fluent, instance, false);
  }
  public CustomResourceDefinitionsBuilder(CustomResourceDefinitionsFluent<?> fluent,CustomResourceDefinitions instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withOwned(instance.getOwned()); 
    fluent.withRequired(instance.getRequired()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public CustomResourceDefinitionsBuilder(CustomResourceDefinitions instance) {
    this(instance,false);
  }
  public CustomResourceDefinitionsBuilder(CustomResourceDefinitions instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withOwned(instance.getOwned()); 
    this.withRequired(instance.getRequired()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  CustomResourceDefinitionsFluent<?> fluent;
  Boolean validationEnabled;
  public CustomResourceDefinitions build() {
    CustomResourceDefinitions buildable = new CustomResourceDefinitions(fluent.getOwned(),fluent.getRequired());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}