package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class CatalogSourceSpecFluentImpl<A extends CatalogSourceSpecFluent<A>> extends BaseFluent<A> implements CatalogSourceSpecFluent<A>{
  public CatalogSourceSpecFluentImpl() {
  }
  public CatalogSourceSpecFluentImpl(CatalogSourceSpec instance) {
    this.withAddress(instance.getAddress()); 
    this.withConfigMap(instance.getConfigMap()); 
    this.withDescription(instance.getDescription()); 
    this.withDisplayName(instance.getDisplayName()); 
    this.withIcon(instance.getIcon()); 
    this.withImage(instance.getImage()); 
    this.withPriority(instance.getPriority()); 
    this.withPublisher(instance.getPublisher()); 
    this.withSecrets(instance.getSecrets()); 
    this.withSourceType(instance.getSourceType()); 
    this.withUpdateStrategy(instance.getUpdateStrategy()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String address;
  private String configMap;
  private String description;
  private String displayName;
  private IconBuilder icon;
  private String image;
  private Integer priority;
  private String publisher;
  private List<String> secrets = new ArrayList<String>();
  private String sourceType;
  private UpdateStrategyBuilder updateStrategy;
  private Map<String,Object> additionalProperties;
  public String getAddress() {
    return this.address;
  }
  public A withAddress(String address) {
    this.address=address; return (A) this;
  }
  public Boolean hasAddress() {
    return this.address != null;
  }
  public String getConfigMap() {
    return this.configMap;
  }
  public A withConfigMap(String configMap) {
    this.configMap=configMap; return (A) this;
  }
  public Boolean hasConfigMap() {
    return this.configMap != null;
  }
  public String getDescription() {
    return this.description;
  }
  public A withDescription(String description) {
    this.description=description; return (A) this;
  }
  public Boolean hasDescription() {
    return this.description != null;
  }
  public String getDisplayName() {
    return this.displayName;
  }
  public A withDisplayName(String displayName) {
    this.displayName=displayName; return (A) this;
  }
  public Boolean hasDisplayName() {
    return this.displayName != null;
  }
  
  /**
   * This method has been deprecated, please use method buildIcon instead.
   * @return The buildable object.
   */
  @Deprecated
  public Icon getIcon() {
    return this.icon!=null ?this.icon.build():null;
  }
  public Icon buildIcon() {
    return this.icon!=null ?this.icon.build():null;
  }
  public A withIcon(Icon icon) {
    _visitables.get("icon").remove(this.icon);
    if (icon!=null){ this.icon= new IconBuilder(icon); _visitables.get("icon").add(this.icon);} else { this.icon = null; _visitables.get("icon").remove(this.icon); } return (A) this;
  }
  public Boolean hasIcon() {
    return this.icon != null;
  }
  public A withNewIcon(String base64data,String mediatype) {
    return (A)withIcon(new Icon(base64data, mediatype));
  }
  public CatalogSourceSpecFluent.IconNested<A> withNewIcon() {
    return new CatalogSourceSpecFluentImpl.IconNestedImpl();
  }
  public CatalogSourceSpecFluent.IconNested<A> withNewIconLike(Icon item) {
    return new CatalogSourceSpecFluentImpl.IconNestedImpl(item);
  }
  public CatalogSourceSpecFluent.IconNested<A> editIcon() {
    return withNewIconLike(getIcon());
  }
  public CatalogSourceSpecFluent.IconNested<A> editOrNewIcon() {
    return withNewIconLike(getIcon() != null ? getIcon(): new IconBuilder().build());
  }
  public CatalogSourceSpecFluent.IconNested<A> editOrNewIconLike(Icon item) {
    return withNewIconLike(getIcon() != null ? getIcon(): item);
  }
  public String getImage() {
    return this.image;
  }
  public A withImage(String image) {
    this.image=image; return (A) this;
  }
  public Boolean hasImage() {
    return this.image != null;
  }
  public Integer getPriority() {
    return this.priority;
  }
  public A withPriority(Integer priority) {
    this.priority=priority; return (A) this;
  }
  public Boolean hasPriority() {
    return this.priority != null;
  }
  public String getPublisher() {
    return this.publisher;
  }
  public A withPublisher(String publisher) {
    this.publisher=publisher; return (A) this;
  }
  public Boolean hasPublisher() {
    return this.publisher != null;
  }
  public A addToSecrets(Integer index,String item) {
    if (this.secrets == null) {this.secrets = new ArrayList<String>();}
    this.secrets.add(index, item);
    return (A)this;
  }
  public A setToSecrets(Integer index,String item) {
    if (this.secrets == null) {this.secrets = new ArrayList<String>();}
    this.secrets.set(index, item); return (A)this;
  }
  public A addToSecrets(java.lang.String... items) {
    if (this.secrets == null) {this.secrets = new ArrayList<String>();}
    for (String item : items) {this.secrets.add(item);} return (A)this;
  }
  public A addAllToSecrets(Collection<String> items) {
    if (this.secrets == null) {this.secrets = new ArrayList<String>();}
    for (String item : items) {this.secrets.add(item);} return (A)this;
  }
  public A removeFromSecrets(java.lang.String... items) {
    for (String item : items) {if (this.secrets!= null){ this.secrets.remove(item);}} return (A)this;
  }
  public A removeAllFromSecrets(Collection<String> items) {
    for (String item : items) {if (this.secrets!= null){ this.secrets.remove(item);}} return (A)this;
  }
  public List<String> getSecrets() {
    return this.secrets;
  }
  public String getSecret(Integer index) {
    return this.secrets.get(index);
  }
  public String getFirstSecret() {
    return this.secrets.get(0);
  }
  public String getLastSecret() {
    return this.secrets.get(secrets.size() - 1);
  }
  public String getMatchingSecret(Predicate<String> predicate) {
    for (String item: secrets) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingSecret(Predicate<String> predicate) {
    for (String item: secrets) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withSecrets(List<String> secrets) {
    if (secrets != null) {this.secrets = new ArrayList(); for (String item : secrets){this.addToSecrets(item);}} else { this.secrets = null;} return (A) this;
  }
  public A withSecrets(java.lang.String... secrets) {
    if (this.secrets != null) {this.secrets.clear();}
    if (secrets != null) {for (String item :secrets){ this.addToSecrets(item);}} return (A) this;
  }
  public Boolean hasSecrets() {
    return secrets != null && !secrets.isEmpty();
  }
  public String getSourceType() {
    return this.sourceType;
  }
  public A withSourceType(String sourceType) {
    this.sourceType=sourceType; return (A) this;
  }
  public Boolean hasSourceType() {
    return this.sourceType != null;
  }
  
  /**
   * This method has been deprecated, please use method buildUpdateStrategy instead.
   * @return The buildable object.
   */
  @Deprecated
  public UpdateStrategy getUpdateStrategy() {
    return this.updateStrategy!=null ?this.updateStrategy.build():null;
  }
  public UpdateStrategy buildUpdateStrategy() {
    return this.updateStrategy!=null ?this.updateStrategy.build():null;
  }
  public A withUpdateStrategy(UpdateStrategy updateStrategy) {
    _visitables.get("updateStrategy").remove(this.updateStrategy);
    if (updateStrategy!=null){ this.updateStrategy= new UpdateStrategyBuilder(updateStrategy); _visitables.get("updateStrategy").add(this.updateStrategy);} else { this.updateStrategy = null; _visitables.get("updateStrategy").remove(this.updateStrategy); } return (A) this;
  }
  public Boolean hasUpdateStrategy() {
    return this.updateStrategy != null;
  }
  public CatalogSourceSpecFluent.UpdateStrategyNested<A> withNewUpdateStrategy() {
    return new CatalogSourceSpecFluentImpl.UpdateStrategyNestedImpl();
  }
  public CatalogSourceSpecFluent.UpdateStrategyNested<A> withNewUpdateStrategyLike(UpdateStrategy item) {
    return new CatalogSourceSpecFluentImpl.UpdateStrategyNestedImpl(item);
  }
  public CatalogSourceSpecFluent.UpdateStrategyNested<A> editUpdateStrategy() {
    return withNewUpdateStrategyLike(getUpdateStrategy());
  }
  public CatalogSourceSpecFluent.UpdateStrategyNested<A> editOrNewUpdateStrategy() {
    return withNewUpdateStrategyLike(getUpdateStrategy() != null ? getUpdateStrategy(): new UpdateStrategyBuilder().build());
  }
  public CatalogSourceSpecFluent.UpdateStrategyNested<A> editOrNewUpdateStrategyLike(UpdateStrategy item) {
    return withNewUpdateStrategyLike(getUpdateStrategy() != null ? getUpdateStrategy(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CatalogSourceSpecFluentImpl that = (CatalogSourceSpecFluentImpl) o;
    if (address != null ? !address.equals(that.address) :that.address != null) return false;
    if (configMap != null ? !configMap.equals(that.configMap) :that.configMap != null) return false;
    if (description != null ? !description.equals(that.description) :that.description != null) return false;
    if (displayName != null ? !displayName.equals(that.displayName) :that.displayName != null) return false;
    if (icon != null ? !icon.equals(that.icon) :that.icon != null) return false;
    if (image != null ? !image.equals(that.image) :that.image != null) return false;
    if (priority != null ? !priority.equals(that.priority) :that.priority != null) return false;
    if (publisher != null ? !publisher.equals(that.publisher) :that.publisher != null) return false;
    if (secrets != null ? !secrets.equals(that.secrets) :that.secrets != null) return false;
    if (sourceType != null ? !sourceType.equals(that.sourceType) :that.sourceType != null) return false;
    if (updateStrategy != null ? !updateStrategy.equals(that.updateStrategy) :that.updateStrategy != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(address,  configMap,  description,  displayName,  icon,  image,  priority,  publisher,  secrets,  sourceType,  updateStrategy,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (address != null) { sb.append("address:"); sb.append(address + ","); }
    if (configMap != null) { sb.append("configMap:"); sb.append(configMap + ","); }
    if (description != null) { sb.append("description:"); sb.append(description + ","); }
    if (displayName != null) { sb.append("displayName:"); sb.append(displayName + ","); }
    if (icon != null) { sb.append("icon:"); sb.append(icon + ","); }
    if (image != null) { sb.append("image:"); sb.append(image + ","); }
    if (priority != null) { sb.append("priority:"); sb.append(priority + ","); }
    if (publisher != null) { sb.append("publisher:"); sb.append(publisher + ","); }
    if (secrets != null && !secrets.isEmpty()) { sb.append("secrets:"); sb.append(secrets + ","); }
    if (sourceType != null) { sb.append("sourceType:"); sb.append(sourceType + ","); }
    if (updateStrategy != null) { sb.append("updateStrategy:"); sb.append(updateStrategy + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class IconNestedImpl<N> extends IconFluentImpl<CatalogSourceSpecFluent.IconNested<N>> implements CatalogSourceSpecFluent.IconNested<N>,Nested<N>{
    IconNestedImpl(Icon item) {
      this.builder = new IconBuilder(this, item);
    }
    IconNestedImpl() {
      this.builder = new IconBuilder(this);
    }
    IconBuilder builder;
    public N and() {
      return (N) CatalogSourceSpecFluentImpl.this.withIcon(builder.build());
    }
    public N endIcon() {
      return and();
    }
    
  }
  class UpdateStrategyNestedImpl<N> extends UpdateStrategyFluentImpl<CatalogSourceSpecFluent.UpdateStrategyNested<N>> implements CatalogSourceSpecFluent.UpdateStrategyNested<N>,Nested<N>{
    UpdateStrategyNestedImpl(UpdateStrategy item) {
      this.builder = new UpdateStrategyBuilder(this, item);
    }
    UpdateStrategyNestedImpl() {
      this.builder = new UpdateStrategyBuilder(this);
    }
    UpdateStrategyBuilder builder;
    public N and() {
      return (N) CatalogSourceSpecFluentImpl.this.withUpdateStrategy(builder.build());
    }
    public N endUpdateStrategy() {
      return and();
    }
    
  }
  
}