package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SubscriptionCatalogHealthBuilder extends SubscriptionCatalogHealthFluentImpl<SubscriptionCatalogHealthBuilder> implements VisitableBuilder<SubscriptionCatalogHealth,SubscriptionCatalogHealthBuilder>{
  public SubscriptionCatalogHealthBuilder() {
    this(false);
  }
  public SubscriptionCatalogHealthBuilder(Boolean validationEnabled) {
    this(new SubscriptionCatalogHealth(), validationEnabled);
  }
  public SubscriptionCatalogHealthBuilder(SubscriptionCatalogHealthFluent<?> fluent) {
    this(fluent, false);
  }
  public SubscriptionCatalogHealthBuilder(SubscriptionCatalogHealthFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SubscriptionCatalogHealth(), validationEnabled);
  }
  public SubscriptionCatalogHealthBuilder(SubscriptionCatalogHealthFluent<?> fluent,SubscriptionCatalogHealth instance) {
    this(fluent, instance, false);
  }
  public SubscriptionCatalogHealthBuilder(SubscriptionCatalogHealthFluent<?> fluent,SubscriptionCatalogHealth instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCatalogSourceRef(instance.getCatalogSourceRef()); 
    fluent.withHealthy(instance.getHealthy()); 
    fluent.withLastUpdated(instance.getLastUpdated()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public SubscriptionCatalogHealthBuilder(SubscriptionCatalogHealth instance) {
    this(instance,false);
  }
  public SubscriptionCatalogHealthBuilder(SubscriptionCatalogHealth instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withCatalogSourceRef(instance.getCatalogSourceRef()); 
    this.withHealthy(instance.getHealthy()); 
    this.withLastUpdated(instance.getLastUpdated()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  SubscriptionCatalogHealthFluent<?> fluent;
  Boolean validationEnabled;
  public SubscriptionCatalogHealth build() {
    SubscriptionCatalogHealth buildable = new SubscriptionCatalogHealth(fluent.getCatalogSourceRef(),fluent.getHealthy(),fluent.getLastUpdated());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}