package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ResourceInstanceBuilder extends ResourceInstanceFluent<ResourceInstanceBuilder> implements VisitableBuilder<ResourceInstance,ResourceInstanceBuilder>{
  public ResourceInstanceBuilder() {
    this(false);
  }
  public ResourceInstanceBuilder(Boolean validationEnabled) {
    this(new ResourceInstance(), validationEnabled);
  }
  public ResourceInstanceBuilder(ResourceInstanceFluent<?> fluent) {
    this(fluent, false);
  }
  public ResourceInstanceBuilder(ResourceInstanceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ResourceInstance(), validationEnabled);
  }
  public ResourceInstanceBuilder(ResourceInstanceFluent<?> fluent,ResourceInstance instance) {
    this(fluent, instance, false);
  }
  public ResourceInstanceBuilder(ResourceInstanceFluent<?> fluent,ResourceInstance instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ResourceInstance());

    if (instance != null) {
      fluent.withName(instance.getName());
      fluent.withNamespace(instance.getNamespace());
      fluent.withName(instance.getName());
      fluent.withNamespace(instance.getNamespace());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ResourceInstanceBuilder(ResourceInstance instance) {
    this(instance,false);
  }
  public ResourceInstanceBuilder(ResourceInstance instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ResourceInstance());

    if (instance != null) {
      this.withName(instance.getName());
      this.withNamespace(instance.getNamespace());
      this.withName(instance.getName());
      this.withNamespace(instance.getNamespace());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ResourceInstanceFluent<?> fluent;
  Boolean validationEnabled;
  public ResourceInstance build() {
    ResourceInstance buildable = new ResourceInstance(fluent.getName(),fluent.getNamespace());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}