package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class StatusDescriptorBuilder extends StatusDescriptorFluent<StatusDescriptorBuilder> implements VisitableBuilder<StatusDescriptor,StatusDescriptorBuilder>{
  public StatusDescriptorBuilder() {
    this(false);
  }
  public StatusDescriptorBuilder(Boolean validationEnabled) {
    this(new StatusDescriptor(), validationEnabled);
  }
  public StatusDescriptorBuilder(StatusDescriptorFluent<?> fluent) {
    this(fluent, false);
  }
  public StatusDescriptorBuilder(StatusDescriptorFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new StatusDescriptor(), validationEnabled);
  }
  public StatusDescriptorBuilder(StatusDescriptorFluent<?> fluent,StatusDescriptor instance) {
    this(fluent, instance, false);
  }
  public StatusDescriptorBuilder(StatusDescriptorFluent<?> fluent,StatusDescriptor instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new StatusDescriptor());

    if (instance != null) {
      fluent.withDescription(instance.getDescription());
      fluent.withDisplayName(instance.getDisplayName());
      fluent.withPath(instance.getPath());
      fluent.withValue(instance.getValue());
      fluent.withXDescriptors(instance.getXDescriptors());
      fluent.withDescription(instance.getDescription());
      fluent.withDisplayName(instance.getDisplayName());
      fluent.withPath(instance.getPath());
      fluent.withValue(instance.getValue());
      fluent.withXDescriptors(instance.getXDescriptors());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public StatusDescriptorBuilder(StatusDescriptor instance) {
    this(instance,false);
  }
  public StatusDescriptorBuilder(StatusDescriptor instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new StatusDescriptor());

    if (instance != null) {
      this.withDescription(instance.getDescription());
      this.withDisplayName(instance.getDisplayName());
      this.withPath(instance.getPath());
      this.withValue(instance.getValue());
      this.withXDescriptors(instance.getXDescriptors());
      this.withDescription(instance.getDescription());
      this.withDisplayName(instance.getDisplayName());
      this.withPath(instance.getPath());
      this.withValue(instance.getValue());
      this.withXDescriptors(instance.getXDescriptors());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  StatusDescriptorFluent<?> fluent;
  Boolean validationEnabled;
  public StatusDescriptor build() {
    StatusDescriptor buildable = new StatusDescriptor(fluent.getDescription(),fluent.getDisplayName(),fluent.getPath(),fluent.getValue(),fluent.getXDescriptors());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}