package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class APIServiceDefinitionsBuilder extends APIServiceDefinitionsFluent<APIServiceDefinitionsBuilder> implements VisitableBuilder<APIServiceDefinitions,APIServiceDefinitionsBuilder>{
  public APIServiceDefinitionsBuilder() {
    this(false);
  }
  public APIServiceDefinitionsBuilder(Boolean validationEnabled) {
    this(new APIServiceDefinitions(), validationEnabled);
  }
  public APIServiceDefinitionsBuilder(APIServiceDefinitionsFluent<?> fluent) {
    this(fluent, false);
  }
  public APIServiceDefinitionsBuilder(APIServiceDefinitionsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new APIServiceDefinitions(), validationEnabled);
  }
  public APIServiceDefinitionsBuilder(APIServiceDefinitionsFluent<?> fluent,APIServiceDefinitions instance) {
    this(fluent, instance, false);
  }
  public APIServiceDefinitionsBuilder(APIServiceDefinitionsFluent<?> fluent,APIServiceDefinitions instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new APIServiceDefinitions());

    if (instance != null) {
      fluent.withOwned(instance.getOwned());
      fluent.withRequired(instance.getRequired());
      fluent.withOwned(instance.getOwned());
      fluent.withRequired(instance.getRequired());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public APIServiceDefinitionsBuilder(APIServiceDefinitions instance) {
    this(instance,false);
  }
  public APIServiceDefinitionsBuilder(APIServiceDefinitions instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new APIServiceDefinitions());

    if (instance != null) {
      this.withOwned(instance.getOwned());
      this.withRequired(instance.getRequired());
      this.withOwned(instance.getOwned());
      this.withRequired(instance.getRequired());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  APIServiceDefinitionsFluent<?> fluent;
  Boolean validationEnabled;
  public APIServiceDefinitions build() {
    APIServiceDefinitions buildable = new APIServiceDefinitions(fluent.buildOwned(),fluent.buildRequired());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}