package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ActionDescriptorBuilder extends ActionDescriptorFluent<ActionDescriptorBuilder> implements VisitableBuilder<ActionDescriptor,ActionDescriptorBuilder>{
  public ActionDescriptorBuilder() {
    this(false);
  }
  public ActionDescriptorBuilder(Boolean validationEnabled) {
    this(new ActionDescriptor(), validationEnabled);
  }
  public ActionDescriptorBuilder(ActionDescriptorFluent<?> fluent) {
    this(fluent, false);
  }
  public ActionDescriptorBuilder(ActionDescriptorFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ActionDescriptor(), validationEnabled);
  }
  public ActionDescriptorBuilder(ActionDescriptorFluent<?> fluent,ActionDescriptor instance) {
    this(fluent, instance, false);
  }
  public ActionDescriptorBuilder(ActionDescriptorFluent<?> fluent,ActionDescriptor instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ActionDescriptor());

    if (instance != null) {
      fluent.withDescription(instance.getDescription());
      fluent.withDisplayName(instance.getDisplayName());
      fluent.withPath(instance.getPath());
      fluent.withValue(instance.getValue());
      fluent.withXDescriptors(instance.getXDescriptors());
      fluent.withDescription(instance.getDescription());
      fluent.withDisplayName(instance.getDisplayName());
      fluent.withPath(instance.getPath());
      fluent.withValue(instance.getValue());
      fluent.withXDescriptors(instance.getXDescriptors());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ActionDescriptorBuilder(ActionDescriptor instance) {
    this(instance,false);
  }
  public ActionDescriptorBuilder(ActionDescriptor instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ActionDescriptor());

    if (instance != null) {
      this.withDescription(instance.getDescription());
      this.withDisplayName(instance.getDisplayName());
      this.withPath(instance.getPath());
      this.withValue(instance.getValue());
      this.withXDescriptors(instance.getXDescriptors());
      this.withDescription(instance.getDescription());
      this.withDisplayName(instance.getDisplayName());
      this.withPath(instance.getPath());
      this.withValue(instance.getValue());
      this.withXDescriptors(instance.getXDescriptors());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ActionDescriptorFluent<?> fluent;
  Boolean validationEnabled;
  public ActionDescriptor build() {
    ActionDescriptor buildable = new ActionDescriptor(fluent.getDescription(),fluent.getDisplayName(),fluent.getPath(),fluent.getValue(),fluent.getXDescriptors());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}