package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CatalogSourceStatusBuilder extends CatalogSourceStatusFluent<CatalogSourceStatusBuilder> implements VisitableBuilder<CatalogSourceStatus,CatalogSourceStatusBuilder>{
  public CatalogSourceStatusBuilder() {
    this(false);
  }
  public CatalogSourceStatusBuilder(Boolean validationEnabled) {
    this(new CatalogSourceStatus(), validationEnabled);
  }
  public CatalogSourceStatusBuilder(CatalogSourceStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public CatalogSourceStatusBuilder(CatalogSourceStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CatalogSourceStatus(), validationEnabled);
  }
  public CatalogSourceStatusBuilder(CatalogSourceStatusFluent<?> fluent,CatalogSourceStatus instance) {
    this(fluent, instance, false);
  }
  public CatalogSourceStatusBuilder(CatalogSourceStatusFluent<?> fluent,CatalogSourceStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new CatalogSourceStatus());

    if (instance != null) {
      fluent.withConditions(instance.getConditions());
      fluent.withConfigMapReference(instance.getConfigMapReference());
      fluent.withConnectionState(instance.getConnectionState());
      fluent.withLatestImageRegistryPoll(instance.getLatestImageRegistryPoll());
      fluent.withMessage(instance.getMessage());
      fluent.withReason(instance.getReason());
      fluent.withRegistryService(instance.getRegistryService());
      fluent.withConditions(instance.getConditions());
      fluent.withConfigMapReference(instance.getConfigMapReference());
      fluent.withConnectionState(instance.getConnectionState());
      fluent.withLatestImageRegistryPoll(instance.getLatestImageRegistryPoll());
      fluent.withMessage(instance.getMessage());
      fluent.withReason(instance.getReason());
      fluent.withRegistryService(instance.getRegistryService());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CatalogSourceStatusBuilder(CatalogSourceStatus instance) {
    this(instance,false);
  }
  public CatalogSourceStatusBuilder(CatalogSourceStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new CatalogSourceStatus());

    if (instance != null) {
      this.withConditions(instance.getConditions());
      this.withConfigMapReference(instance.getConfigMapReference());
      this.withConnectionState(instance.getConnectionState());
      this.withLatestImageRegistryPoll(instance.getLatestImageRegistryPoll());
      this.withMessage(instance.getMessage());
      this.withReason(instance.getReason());
      this.withRegistryService(instance.getRegistryService());
      this.withConditions(instance.getConditions());
      this.withConfigMapReference(instance.getConfigMapReference());
      this.withConnectionState(instance.getConnectionState());
      this.withLatestImageRegistryPoll(instance.getLatestImageRegistryPoll());
      this.withMessage(instance.getMessage());
      this.withReason(instance.getReason());
      this.withRegistryService(instance.getRegistryService());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  CatalogSourceStatusFluent<?> fluent;
  Boolean validationEnabled;
  public CatalogSourceStatus build() {
    CatalogSourceStatus buildable = new CatalogSourceStatus(fluent.getConditions(),fluent.buildConfigMapReference(),fluent.buildConnectionState(),fluent.getLatestImageRegistryPoll(),fluent.getMessage(),fluent.getReason(),fluent.buildRegistryService());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}