package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.util.Collection;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import java.util.Map;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.GroupVersionKind;
import java.util.Iterator;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ClusterServiceVersionSpecFluent<A extends ClusterServiceVersionSpecFluent<A>> extends BaseFluent<A>{
  public ClusterServiceVersionSpecFluent() {
  }
  public ClusterServiceVersionSpecFluent(ClusterServiceVersionSpec instance) {
    instance = (instance != null ? instance : new ClusterServiceVersionSpec());

    if (instance != null) {
      this.withAnnotations(instance.getAnnotations());
      this.withApiservicedefinitions(instance.getApiservicedefinitions());
      this.withCleanup(instance.getCleanup());
      this.withCustomresourcedefinitions(instance.getCustomresourcedefinitions());
      this.withDescription(instance.getDescription());
      this.withDisplayName(instance.getDisplayName());
      this.withIcon(instance.getIcon());
      this.withInstall(instance.getInstall());
      this.withInstallModes(instance.getInstallModes());
      this.withKeywords(instance.getKeywords());
      this.withLabels(instance.getLabels());
      this.withLinks(instance.getLinks());
      this.withMaintainers(instance.getMaintainers());
      this.withMaturity(instance.getMaturity());
      this.withMinKubeVersion(instance.getMinKubeVersion());
      this.withNativeAPIs(instance.getNativeAPIs());
      this.withProvider(instance.getProvider());
      this.withRelatedImages(instance.getRelatedImages());
      this.withReplaces(instance.getReplaces());
      this.withSelector(instance.getSelector());
      this.withSkips(instance.getSkips());
      this.withVersion(instance.getVersion());
      this.withWebhookdefinitions(instance.getWebhookdefinitions());
      this.withAnnotations(instance.getAnnotations());
      this.withApiservicedefinitions(instance.getApiservicedefinitions());
      this.withCleanup(instance.getCleanup());
      this.withCustomresourcedefinitions(instance.getCustomresourcedefinitions());
      this.withDescription(instance.getDescription());
      this.withDisplayName(instance.getDisplayName());
      this.withIcon(instance.getIcon());
      this.withInstall(instance.getInstall());
      this.withInstallModes(instance.getInstallModes());
      this.withKeywords(instance.getKeywords());
      this.withLabels(instance.getLabels());
      this.withLinks(instance.getLinks());
      this.withMaintainers(instance.getMaintainers());
      this.withMaturity(instance.getMaturity());
      this.withMinKubeVersion(instance.getMinKubeVersion());
      this.withNativeAPIs(instance.getNativeAPIs());
      this.withProvider(instance.getProvider());
      this.withRelatedImages(instance.getRelatedImages());
      this.withReplaces(instance.getReplaces());
      this.withSelector(instance.getSelector());
      this.withSkips(instance.getSkips());
      this.withVersion(instance.getVersion());
      this.withWebhookdefinitions(instance.getWebhookdefinitions());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private Map<String,String> annotations;
  private APIServiceDefinitionsBuilder apiservicedefinitions;
  private CleanupSpecBuilder cleanup;
  private CustomResourceDefinitionsBuilder customresourcedefinitions;
  private String description;
  private String displayName;
  private ArrayList<IconBuilder> icon = new ArrayList<IconBuilder>();
  private NamedInstallStrategyBuilder install;
  private ArrayList<InstallModeBuilder> installModes = new ArrayList<InstallModeBuilder>();
  private List<String> keywords = new ArrayList<String>();
  private Map<String,String> labels;
  private ArrayList<AppLinkBuilder> links = new ArrayList<AppLinkBuilder>();
  private ArrayList<MaintainerBuilder> maintainers = new ArrayList<MaintainerBuilder>();
  private String maturity;
  private String minKubeVersion;
  private List<GroupVersionKind> nativeAPIs = new ArrayList<GroupVersionKind>();
  private AppLinkBuilder provider;
  private ArrayList<RelatedImageBuilder> relatedImages = new ArrayList<RelatedImageBuilder>();
  private String replaces;
  private LabelSelectorBuilder selector;
  private List<String> skips = new ArrayList<String>();
  private String version;
  private ArrayList<WebhookDescriptionBuilder> webhookdefinitions = new ArrayList<WebhookDescriptionBuilder>();
  private Map<String,Object> additionalProperties;
  public A addToAnnotations(String key,String value) {
    if(this.annotations == null && key != null && value != null) { this.annotations = new LinkedHashMap(); }
    if(key != null && value != null) {this.annotations.put(key, value);} return (A)this;
  }
  public A addToAnnotations(Map<String,String> map) {
    if(this.annotations == null && map != null) { this.annotations = new LinkedHashMap(); }
    if(map != null) { this.annotations.putAll(map);} return (A)this;
  }
  public A removeFromAnnotations(String key) {
    if(this.annotations == null) { return (A) this; }
    if(key != null && this.annotations != null) {this.annotations.remove(key);} return (A)this;
  }
  public A removeFromAnnotations(Map<String,String> map) {
    if(this.annotations == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.annotations != null){this.annotations.remove(key);}}} return (A)this;
  }
  public Map<String,String> getAnnotations() {
    return this.annotations;
  }
  public <K,V>A withAnnotations(Map<String,String> annotations) {
    if (annotations == null) { this.annotations =  null;} else {this.annotations = new LinkedHashMap(annotations);} return (A) this;
  }
  public boolean hasAnnotations() {
    return this.annotations != null;
  }
  public APIServiceDefinitions buildApiservicedefinitions() {
    return this.apiservicedefinitions!=null ?this.apiservicedefinitions.build():null;
  }
  public A withApiservicedefinitions(APIServiceDefinitions apiservicedefinitions) {
    _visitables.get("apiservicedefinitions").remove(this.apiservicedefinitions);
    if (apiservicedefinitions!=null){ this.apiservicedefinitions= new APIServiceDefinitionsBuilder(apiservicedefinitions); _visitables.get("apiservicedefinitions").add(this.apiservicedefinitions);} else { this.apiservicedefinitions = null; _visitables.get("apiservicedefinitions").remove(this.apiservicedefinitions); } return (A) this;
  }
  public boolean hasApiservicedefinitions() {
    return this.apiservicedefinitions != null;
  }
  public ApiservicedefinitionsNested<A> withNewApiservicedefinitions() {
    return new ApiservicedefinitionsNested(null);
  }
  public ApiservicedefinitionsNested<A> withNewApiservicedefinitionsLike(APIServiceDefinitions item) {
    return new ApiservicedefinitionsNested(item);
  }
  public ApiservicedefinitionsNested<A> editApiservicedefinitions() {
    return withNewApiservicedefinitionsLike(java.util.Optional.ofNullable(buildApiservicedefinitions()).orElse(null));
  }
  public ApiservicedefinitionsNested<A> editOrNewApiservicedefinitions() {
    return withNewApiservicedefinitionsLike(java.util.Optional.ofNullable(buildApiservicedefinitions()).orElse(new APIServiceDefinitionsBuilder().build()));
  }
  public ApiservicedefinitionsNested<A> editOrNewApiservicedefinitionsLike(APIServiceDefinitions item) {
    return withNewApiservicedefinitionsLike(java.util.Optional.ofNullable(buildApiservicedefinitions()).orElse(item));
  }
  public CleanupSpec buildCleanup() {
    return this.cleanup!=null ?this.cleanup.build():null;
  }
  public A withCleanup(CleanupSpec cleanup) {
    _visitables.get("cleanup").remove(this.cleanup);
    if (cleanup!=null){ this.cleanup= new CleanupSpecBuilder(cleanup); _visitables.get("cleanup").add(this.cleanup);} else { this.cleanup = null; _visitables.get("cleanup").remove(this.cleanup); } return (A) this;
  }
  public boolean hasCleanup() {
    return this.cleanup != null;
  }
  public A withNewCleanup(Boolean enabled) {
    return (A)withCleanup(new CleanupSpec(enabled));
  }
  public CleanupNested<A> withNewCleanup() {
    return new CleanupNested(null);
  }
  public CleanupNested<A> withNewCleanupLike(CleanupSpec item) {
    return new CleanupNested(item);
  }
  public CleanupNested<A> editCleanup() {
    return withNewCleanupLike(java.util.Optional.ofNullable(buildCleanup()).orElse(null));
  }
  public CleanupNested<A> editOrNewCleanup() {
    return withNewCleanupLike(java.util.Optional.ofNullable(buildCleanup()).orElse(new CleanupSpecBuilder().build()));
  }
  public CleanupNested<A> editOrNewCleanupLike(CleanupSpec item) {
    return withNewCleanupLike(java.util.Optional.ofNullable(buildCleanup()).orElse(item));
  }
  public CustomResourceDefinitions buildCustomresourcedefinitions() {
    return this.customresourcedefinitions!=null ?this.customresourcedefinitions.build():null;
  }
  public A withCustomresourcedefinitions(CustomResourceDefinitions customresourcedefinitions) {
    _visitables.get("customresourcedefinitions").remove(this.customresourcedefinitions);
    if (customresourcedefinitions!=null){ this.customresourcedefinitions= new CustomResourceDefinitionsBuilder(customresourcedefinitions); _visitables.get("customresourcedefinitions").add(this.customresourcedefinitions);} else { this.customresourcedefinitions = null; _visitables.get("customresourcedefinitions").remove(this.customresourcedefinitions); } return (A) this;
  }
  public boolean hasCustomresourcedefinitions() {
    return this.customresourcedefinitions != null;
  }
  public CustomresourcedefinitionsNested<A> withNewCustomresourcedefinitions() {
    return new CustomresourcedefinitionsNested(null);
  }
  public CustomresourcedefinitionsNested<A> withNewCustomresourcedefinitionsLike(CustomResourceDefinitions item) {
    return new CustomresourcedefinitionsNested(item);
  }
  public CustomresourcedefinitionsNested<A> editCustomresourcedefinitions() {
    return withNewCustomresourcedefinitionsLike(java.util.Optional.ofNullable(buildCustomresourcedefinitions()).orElse(null));
  }
  public CustomresourcedefinitionsNested<A> editOrNewCustomresourcedefinitions() {
    return withNewCustomresourcedefinitionsLike(java.util.Optional.ofNullable(buildCustomresourcedefinitions()).orElse(new CustomResourceDefinitionsBuilder().build()));
  }
  public CustomresourcedefinitionsNested<A> editOrNewCustomresourcedefinitionsLike(CustomResourceDefinitions item) {
    return withNewCustomresourcedefinitionsLike(java.util.Optional.ofNullable(buildCustomresourcedefinitions()).orElse(item));
  }
  public String getDescription() {
    return this.description;
  }
  public A withDescription(String description) {
    this.description=description; return (A) this;
  }
  public boolean hasDescription() {
    return this.description != null;
  }
  public String getDisplayName() {
    return this.displayName;
  }
  public A withDisplayName(String displayName) {
    this.displayName=displayName; return (A) this;
  }
  public boolean hasDisplayName() {
    return this.displayName != null;
  }
  public A addToIcon(int index,Icon item) {
    if (this.icon == null) {this.icon = new ArrayList<IconBuilder>();}
    IconBuilder builder = new IconBuilder(item);
    if (index < 0 || index >= icon.size()) { _visitables.get("icon").add(builder); icon.add(builder); } else { _visitables.get("icon").add(index, builder); icon.add(index, builder);}
    return (A)this;
  }
  public A setToIcon(int index,Icon item) {
    if (this.icon == null) {this.icon = new ArrayList<IconBuilder>();}
    IconBuilder builder = new IconBuilder(item);
    if (index < 0 || index >= icon.size()) { _visitables.get("icon").add(builder); icon.add(builder); } else { _visitables.get("icon").set(index, builder); icon.set(index, builder);}
    return (A)this;
  }
  public A addToIcon(io.fabric8.openshift.api.model.operatorhub.v1alpha1.Icon... items) {
    if (this.icon == null) {this.icon = new ArrayList<IconBuilder>();}
    for (Icon item : items) {IconBuilder builder = new IconBuilder(item);_visitables.get("icon").add(builder);this.icon.add(builder);} return (A)this;
  }
  public A addAllToIcon(Collection<Icon> items) {
    if (this.icon == null) {this.icon = new ArrayList<IconBuilder>();}
    for (Icon item : items) {IconBuilder builder = new IconBuilder(item);_visitables.get("icon").add(builder);this.icon.add(builder);} return (A)this;
  }
  public A removeFromIcon(io.fabric8.openshift.api.model.operatorhub.v1alpha1.Icon... items) {
    if (this.icon == null) return (A)this;
    for (Icon item : items) {IconBuilder builder = new IconBuilder(item);_visitables.get("icon").remove(builder); this.icon.remove(builder);} return (A)this;
  }
  public A removeAllFromIcon(Collection<Icon> items) {
    if (this.icon == null) return (A)this;
    for (Icon item : items) {IconBuilder builder = new IconBuilder(item);_visitables.get("icon").remove(builder); this.icon.remove(builder);} return (A)this;
  }
  public A removeMatchingFromIcon(Predicate<IconBuilder> predicate) {
    if (icon == null) return (A) this;
    final Iterator<IconBuilder> each = icon.iterator();
    final List visitables = _visitables.get("icon");
    while (each.hasNext()) {
      IconBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<Icon> buildIcon() {
    return icon != null ? build(icon) : null;
  }
  public Icon buildIcon(int index) {
    return this.icon.get(index).build();
  }
  public Icon buildFirstIcon() {
    return this.icon.get(0).build();
  }
  public Icon buildLastIcon() {
    return this.icon.get(icon.size() - 1).build();
  }
  public Icon buildMatchingIcon(Predicate<IconBuilder> predicate) {
    for (IconBuilder item: icon) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingIcon(Predicate<IconBuilder> predicate) {
    for (IconBuilder item: icon) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withIcon(List<Icon> icon) {
    if (this.icon != null) { _visitables.get("icon").clear();}
    if (icon != null) {this.icon = new ArrayList(); for (Icon item : icon){this.addToIcon(item);}} else { this.icon = null;} return (A) this;
  }
  public A withIcon(io.fabric8.openshift.api.model.operatorhub.v1alpha1.Icon... icon) {
    if (this.icon != null) {this.icon.clear(); _visitables.remove("icon"); }
    if (icon != null) {for (Icon item :icon){ this.addToIcon(item);}} return (A) this;
  }
  public boolean hasIcon() {
    return icon != null && !icon.isEmpty();
  }
  public A addNewIcon(String base64data,String mediatype) {
    return (A)addToIcon(new Icon(base64data, mediatype));
  }
  public IconNested<A> addNewIcon() {
    return new IconNested(-1, null);
  }
  public IconNested<A> addNewIconLike(Icon item) {
    return new IconNested(-1, item);
  }
  public IconNested<A> setNewIconLike(int index,Icon item) {
    return new IconNested(index, item);
  }
  public IconNested<A> editIcon(int index) {
    if (icon.size() <= index) throw new RuntimeException("Can't edit icon. Index exceeds size.");
    return setNewIconLike(index, buildIcon(index));
  }
  public IconNested<A> editFirstIcon() {
    if (icon.size() == 0) throw new RuntimeException("Can't edit first icon. The list is empty.");
    return setNewIconLike(0, buildIcon(0));
  }
  public IconNested<A> editLastIcon() {
    int index = icon.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last icon. The list is empty.");
    return setNewIconLike(index, buildIcon(index));
  }
  public IconNested<A> editMatchingIcon(Predicate<IconBuilder> predicate) {
    int index = -1;
    for (int i=0;i<icon.size();i++) { 
    if (predicate.test(icon.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching icon. No match found.");
    return setNewIconLike(index, buildIcon(index));
  }
  public NamedInstallStrategy buildInstall() {
    return this.install!=null ?this.install.build():null;
  }
  public A withInstall(NamedInstallStrategy install) {
    _visitables.get("install").remove(this.install);
    if (install!=null){ this.install= new NamedInstallStrategyBuilder(install); _visitables.get("install").add(this.install);} else { this.install = null; _visitables.get("install").remove(this.install); } return (A) this;
  }
  public boolean hasInstall() {
    return this.install != null;
  }
  public InstallNested<A> withNewInstall() {
    return new InstallNested(null);
  }
  public InstallNested<A> withNewInstallLike(NamedInstallStrategy item) {
    return new InstallNested(item);
  }
  public InstallNested<A> editInstall() {
    return withNewInstallLike(java.util.Optional.ofNullable(buildInstall()).orElse(null));
  }
  public InstallNested<A> editOrNewInstall() {
    return withNewInstallLike(java.util.Optional.ofNullable(buildInstall()).orElse(new NamedInstallStrategyBuilder().build()));
  }
  public InstallNested<A> editOrNewInstallLike(NamedInstallStrategy item) {
    return withNewInstallLike(java.util.Optional.ofNullable(buildInstall()).orElse(item));
  }
  public A addToInstallModes(int index,InstallMode item) {
    if (this.installModes == null) {this.installModes = new ArrayList<InstallModeBuilder>();}
    InstallModeBuilder builder = new InstallModeBuilder(item);
    if (index < 0 || index >= installModes.size()) { _visitables.get("installModes").add(builder); installModes.add(builder); } else { _visitables.get("installModes").add(index, builder); installModes.add(index, builder);}
    return (A)this;
  }
  public A setToInstallModes(int index,InstallMode item) {
    if (this.installModes == null) {this.installModes = new ArrayList<InstallModeBuilder>();}
    InstallModeBuilder builder = new InstallModeBuilder(item);
    if (index < 0 || index >= installModes.size()) { _visitables.get("installModes").add(builder); installModes.add(builder); } else { _visitables.get("installModes").set(index, builder); installModes.set(index, builder);}
    return (A)this;
  }
  public A addToInstallModes(io.fabric8.openshift.api.model.operatorhub.v1alpha1.InstallMode... items) {
    if (this.installModes == null) {this.installModes = new ArrayList<InstallModeBuilder>();}
    for (InstallMode item : items) {InstallModeBuilder builder = new InstallModeBuilder(item);_visitables.get("installModes").add(builder);this.installModes.add(builder);} return (A)this;
  }
  public A addAllToInstallModes(Collection<InstallMode> items) {
    if (this.installModes == null) {this.installModes = new ArrayList<InstallModeBuilder>();}
    for (InstallMode item : items) {InstallModeBuilder builder = new InstallModeBuilder(item);_visitables.get("installModes").add(builder);this.installModes.add(builder);} return (A)this;
  }
  public A removeFromInstallModes(io.fabric8.openshift.api.model.operatorhub.v1alpha1.InstallMode... items) {
    if (this.installModes == null) return (A)this;
    for (InstallMode item : items) {InstallModeBuilder builder = new InstallModeBuilder(item);_visitables.get("installModes").remove(builder); this.installModes.remove(builder);} return (A)this;
  }
  public A removeAllFromInstallModes(Collection<InstallMode> items) {
    if (this.installModes == null) return (A)this;
    for (InstallMode item : items) {InstallModeBuilder builder = new InstallModeBuilder(item);_visitables.get("installModes").remove(builder); this.installModes.remove(builder);} return (A)this;
  }
  public A removeMatchingFromInstallModes(Predicate<InstallModeBuilder> predicate) {
    if (installModes == null) return (A) this;
    final Iterator<InstallModeBuilder> each = installModes.iterator();
    final List visitables = _visitables.get("installModes");
    while (each.hasNext()) {
      InstallModeBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<InstallMode> buildInstallModes() {
    return installModes != null ? build(installModes) : null;
  }
  public InstallMode buildInstallMode(int index) {
    return this.installModes.get(index).build();
  }
  public InstallMode buildFirstInstallMode() {
    return this.installModes.get(0).build();
  }
  public InstallMode buildLastInstallMode() {
    return this.installModes.get(installModes.size() - 1).build();
  }
  public InstallMode buildMatchingInstallMode(Predicate<InstallModeBuilder> predicate) {
    for (InstallModeBuilder item: installModes) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingInstallMode(Predicate<InstallModeBuilder> predicate) {
    for (InstallModeBuilder item: installModes) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withInstallModes(List<InstallMode> installModes) {
    if (this.installModes != null) { _visitables.get("installModes").clear();}
    if (installModes != null) {this.installModes = new ArrayList(); for (InstallMode item : installModes){this.addToInstallModes(item);}} else { this.installModes = null;} return (A) this;
  }
  public A withInstallModes(io.fabric8.openshift.api.model.operatorhub.v1alpha1.InstallMode... installModes) {
    if (this.installModes != null) {this.installModes.clear(); _visitables.remove("installModes"); }
    if (installModes != null) {for (InstallMode item :installModes){ this.addToInstallModes(item);}} return (A) this;
  }
  public boolean hasInstallModes() {
    return installModes != null && !installModes.isEmpty();
  }
  public A addNewInstallMode(Boolean supported,String type) {
    return (A)addToInstallModes(new InstallMode(supported, type));
  }
  public InstallModesNested<A> addNewInstallMode() {
    return new InstallModesNested(-1, null);
  }
  public InstallModesNested<A> addNewInstallModeLike(InstallMode item) {
    return new InstallModesNested(-1, item);
  }
  public InstallModesNested<A> setNewInstallModeLike(int index,InstallMode item) {
    return new InstallModesNested(index, item);
  }
  public InstallModesNested<A> editInstallMode(int index) {
    if (installModes.size() <= index) throw new RuntimeException("Can't edit installModes. Index exceeds size.");
    return setNewInstallModeLike(index, buildInstallMode(index));
  }
  public InstallModesNested<A> editFirstInstallMode() {
    if (installModes.size() == 0) throw new RuntimeException("Can't edit first installModes. The list is empty.");
    return setNewInstallModeLike(0, buildInstallMode(0));
  }
  public InstallModesNested<A> editLastInstallMode() {
    int index = installModes.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last installModes. The list is empty.");
    return setNewInstallModeLike(index, buildInstallMode(index));
  }
  public InstallModesNested<A> editMatchingInstallMode(Predicate<InstallModeBuilder> predicate) {
    int index = -1;
    for (int i=0;i<installModes.size();i++) { 
    if (predicate.test(installModes.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching installModes. No match found.");
    return setNewInstallModeLike(index, buildInstallMode(index));
  }
  public A addToKeywords(int index,String item) {
    if (this.keywords == null) {this.keywords = new ArrayList<String>();}
    this.keywords.add(index, item);
    return (A)this;
  }
  public A setToKeywords(int index,String item) {
    if (this.keywords == null) {this.keywords = new ArrayList<String>();}
    this.keywords.set(index, item); return (A)this;
  }
  public A addToKeywords(java.lang.String... items) {
    if (this.keywords == null) {this.keywords = new ArrayList<String>();}
    for (String item : items) {this.keywords.add(item);} return (A)this;
  }
  public A addAllToKeywords(Collection<String> items) {
    if (this.keywords == null) {this.keywords = new ArrayList<String>();}
    for (String item : items) {this.keywords.add(item);} return (A)this;
  }
  public A removeFromKeywords(java.lang.String... items) {
    if (this.keywords == null) return (A)this;
    for (String item : items) { this.keywords.remove(item);} return (A)this;
  }
  public A removeAllFromKeywords(Collection<String> items) {
    if (this.keywords == null) return (A)this;
    for (String item : items) { this.keywords.remove(item);} return (A)this;
  }
  public List<String> getKeywords() {
    return this.keywords;
  }
  public String getKeyword(int index) {
    return this.keywords.get(index);
  }
  public String getFirstKeyword() {
    return this.keywords.get(0);
  }
  public String getLastKeyword() {
    return this.keywords.get(keywords.size() - 1);
  }
  public String getMatchingKeyword(Predicate<String> predicate) {
    for (String item: keywords) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingKeyword(Predicate<String> predicate) {
    for (String item: keywords) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withKeywords(List<String> keywords) {
    if (keywords != null) {this.keywords = new ArrayList(); for (String item : keywords){this.addToKeywords(item);}} else { this.keywords = null;} return (A) this;
  }
  public A withKeywords(java.lang.String... keywords) {
    if (this.keywords != null) {this.keywords.clear(); _visitables.remove("keywords"); }
    if (keywords != null) {for (String item :keywords){ this.addToKeywords(item);}} return (A) this;
  }
  public boolean hasKeywords() {
    return keywords != null && !keywords.isEmpty();
  }
  public A addToLabels(String key,String value) {
    if(this.labels == null && key != null && value != null) { this.labels = new LinkedHashMap(); }
    if(key != null && value != null) {this.labels.put(key, value);} return (A)this;
  }
  public A addToLabels(Map<String,String> map) {
    if(this.labels == null && map != null) { this.labels = new LinkedHashMap(); }
    if(map != null) { this.labels.putAll(map);} return (A)this;
  }
  public A removeFromLabels(String key) {
    if(this.labels == null) { return (A) this; }
    if(key != null && this.labels != null) {this.labels.remove(key);} return (A)this;
  }
  public A removeFromLabels(Map<String,String> map) {
    if(this.labels == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.labels != null){this.labels.remove(key);}}} return (A)this;
  }
  public Map<String,String> getLabels() {
    return this.labels;
  }
  public <K,V>A withLabels(Map<String,String> labels) {
    if (labels == null) { this.labels =  null;} else {this.labels = new LinkedHashMap(labels);} return (A) this;
  }
  public boolean hasLabels() {
    return this.labels != null;
  }
  public A addToLinks(int index,AppLink item) {
    if (this.links == null) {this.links = new ArrayList<AppLinkBuilder>();}
    AppLinkBuilder builder = new AppLinkBuilder(item);
    if (index < 0 || index >= links.size()) { _visitables.get("links").add(builder); links.add(builder); } else { _visitables.get("links").add(index, builder); links.add(index, builder);}
    return (A)this;
  }
  public A setToLinks(int index,AppLink item) {
    if (this.links == null) {this.links = new ArrayList<AppLinkBuilder>();}
    AppLinkBuilder builder = new AppLinkBuilder(item);
    if (index < 0 || index >= links.size()) { _visitables.get("links").add(builder); links.add(builder); } else { _visitables.get("links").set(index, builder); links.set(index, builder);}
    return (A)this;
  }
  public A addToLinks(io.fabric8.openshift.api.model.operatorhub.v1alpha1.AppLink... items) {
    if (this.links == null) {this.links = new ArrayList<AppLinkBuilder>();}
    for (AppLink item : items) {AppLinkBuilder builder = new AppLinkBuilder(item);_visitables.get("links").add(builder);this.links.add(builder);} return (A)this;
  }
  public A addAllToLinks(Collection<AppLink> items) {
    if (this.links == null) {this.links = new ArrayList<AppLinkBuilder>();}
    for (AppLink item : items) {AppLinkBuilder builder = new AppLinkBuilder(item);_visitables.get("links").add(builder);this.links.add(builder);} return (A)this;
  }
  public A removeFromLinks(io.fabric8.openshift.api.model.operatorhub.v1alpha1.AppLink... items) {
    if (this.links == null) return (A)this;
    for (AppLink item : items) {AppLinkBuilder builder = new AppLinkBuilder(item);_visitables.get("links").remove(builder); this.links.remove(builder);} return (A)this;
  }
  public A removeAllFromLinks(Collection<AppLink> items) {
    if (this.links == null) return (A)this;
    for (AppLink item : items) {AppLinkBuilder builder = new AppLinkBuilder(item);_visitables.get("links").remove(builder); this.links.remove(builder);} return (A)this;
  }
  public A removeMatchingFromLinks(Predicate<AppLinkBuilder> predicate) {
    if (links == null) return (A) this;
    final Iterator<AppLinkBuilder> each = links.iterator();
    final List visitables = _visitables.get("links");
    while (each.hasNext()) {
      AppLinkBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<AppLink> buildLinks() {
    return links != null ? build(links) : null;
  }
  public AppLink buildLink(int index) {
    return this.links.get(index).build();
  }
  public AppLink buildFirstLink() {
    return this.links.get(0).build();
  }
  public AppLink buildLastLink() {
    return this.links.get(links.size() - 1).build();
  }
  public AppLink buildMatchingLink(Predicate<AppLinkBuilder> predicate) {
    for (AppLinkBuilder item: links) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingLink(Predicate<AppLinkBuilder> predicate) {
    for (AppLinkBuilder item: links) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withLinks(List<AppLink> links) {
    if (this.links != null) { _visitables.get("links").clear();}
    if (links != null) {this.links = new ArrayList(); for (AppLink item : links){this.addToLinks(item);}} else { this.links = null;} return (A) this;
  }
  public A withLinks(io.fabric8.openshift.api.model.operatorhub.v1alpha1.AppLink... links) {
    if (this.links != null) {this.links.clear(); _visitables.remove("links"); }
    if (links != null) {for (AppLink item :links){ this.addToLinks(item);}} return (A) this;
  }
  public boolean hasLinks() {
    return links != null && !links.isEmpty();
  }
  public A addNewLink(String name,String url) {
    return (A)addToLinks(new AppLink(name, url));
  }
  public LinksNested<A> addNewLink() {
    return new LinksNested(-1, null);
  }
  public LinksNested<A> addNewLinkLike(AppLink item) {
    return new LinksNested(-1, item);
  }
  public LinksNested<A> setNewLinkLike(int index,AppLink item) {
    return new LinksNested(index, item);
  }
  public LinksNested<A> editLink(int index) {
    if (links.size() <= index) throw new RuntimeException("Can't edit links. Index exceeds size.");
    return setNewLinkLike(index, buildLink(index));
  }
  public LinksNested<A> editFirstLink() {
    if (links.size() == 0) throw new RuntimeException("Can't edit first links. The list is empty.");
    return setNewLinkLike(0, buildLink(0));
  }
  public LinksNested<A> editLastLink() {
    int index = links.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last links. The list is empty.");
    return setNewLinkLike(index, buildLink(index));
  }
  public LinksNested<A> editMatchingLink(Predicate<AppLinkBuilder> predicate) {
    int index = -1;
    for (int i=0;i<links.size();i++) { 
    if (predicate.test(links.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching links. No match found.");
    return setNewLinkLike(index, buildLink(index));
  }
  public A addToMaintainers(int index,Maintainer item) {
    if (this.maintainers == null) {this.maintainers = new ArrayList<MaintainerBuilder>();}
    MaintainerBuilder builder = new MaintainerBuilder(item);
    if (index < 0 || index >= maintainers.size()) { _visitables.get("maintainers").add(builder); maintainers.add(builder); } else { _visitables.get("maintainers").add(index, builder); maintainers.add(index, builder);}
    return (A)this;
  }
  public A setToMaintainers(int index,Maintainer item) {
    if (this.maintainers == null) {this.maintainers = new ArrayList<MaintainerBuilder>();}
    MaintainerBuilder builder = new MaintainerBuilder(item);
    if (index < 0 || index >= maintainers.size()) { _visitables.get("maintainers").add(builder); maintainers.add(builder); } else { _visitables.get("maintainers").set(index, builder); maintainers.set(index, builder);}
    return (A)this;
  }
  public A addToMaintainers(io.fabric8.openshift.api.model.operatorhub.v1alpha1.Maintainer... items) {
    if (this.maintainers == null) {this.maintainers = new ArrayList<MaintainerBuilder>();}
    for (Maintainer item : items) {MaintainerBuilder builder = new MaintainerBuilder(item);_visitables.get("maintainers").add(builder);this.maintainers.add(builder);} return (A)this;
  }
  public A addAllToMaintainers(Collection<Maintainer> items) {
    if (this.maintainers == null) {this.maintainers = new ArrayList<MaintainerBuilder>();}
    for (Maintainer item : items) {MaintainerBuilder builder = new MaintainerBuilder(item);_visitables.get("maintainers").add(builder);this.maintainers.add(builder);} return (A)this;
  }
  public A removeFromMaintainers(io.fabric8.openshift.api.model.operatorhub.v1alpha1.Maintainer... items) {
    if (this.maintainers == null) return (A)this;
    for (Maintainer item : items) {MaintainerBuilder builder = new MaintainerBuilder(item);_visitables.get("maintainers").remove(builder); this.maintainers.remove(builder);} return (A)this;
  }
  public A removeAllFromMaintainers(Collection<Maintainer> items) {
    if (this.maintainers == null) return (A)this;
    for (Maintainer item : items) {MaintainerBuilder builder = new MaintainerBuilder(item);_visitables.get("maintainers").remove(builder); this.maintainers.remove(builder);} return (A)this;
  }
  public A removeMatchingFromMaintainers(Predicate<MaintainerBuilder> predicate) {
    if (maintainers == null) return (A) this;
    final Iterator<MaintainerBuilder> each = maintainers.iterator();
    final List visitables = _visitables.get("maintainers");
    while (each.hasNext()) {
      MaintainerBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<Maintainer> buildMaintainers() {
    return maintainers != null ? build(maintainers) : null;
  }
  public Maintainer buildMaintainer(int index) {
    return this.maintainers.get(index).build();
  }
  public Maintainer buildFirstMaintainer() {
    return this.maintainers.get(0).build();
  }
  public Maintainer buildLastMaintainer() {
    return this.maintainers.get(maintainers.size() - 1).build();
  }
  public Maintainer buildMatchingMaintainer(Predicate<MaintainerBuilder> predicate) {
    for (MaintainerBuilder item: maintainers) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingMaintainer(Predicate<MaintainerBuilder> predicate) {
    for (MaintainerBuilder item: maintainers) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withMaintainers(List<Maintainer> maintainers) {
    if (this.maintainers != null) { _visitables.get("maintainers").clear();}
    if (maintainers != null) {this.maintainers = new ArrayList(); for (Maintainer item : maintainers){this.addToMaintainers(item);}} else { this.maintainers = null;} return (A) this;
  }
  public A withMaintainers(io.fabric8.openshift.api.model.operatorhub.v1alpha1.Maintainer... maintainers) {
    if (this.maintainers != null) {this.maintainers.clear(); _visitables.remove("maintainers"); }
    if (maintainers != null) {for (Maintainer item :maintainers){ this.addToMaintainers(item);}} return (A) this;
  }
  public boolean hasMaintainers() {
    return maintainers != null && !maintainers.isEmpty();
  }
  public A addNewMaintainer(String email,String name) {
    return (A)addToMaintainers(new Maintainer(email, name));
  }
  public MaintainersNested<A> addNewMaintainer() {
    return new MaintainersNested(-1, null);
  }
  public MaintainersNested<A> addNewMaintainerLike(Maintainer item) {
    return new MaintainersNested(-1, item);
  }
  public MaintainersNested<A> setNewMaintainerLike(int index,Maintainer item) {
    return new MaintainersNested(index, item);
  }
  public MaintainersNested<A> editMaintainer(int index) {
    if (maintainers.size() <= index) throw new RuntimeException("Can't edit maintainers. Index exceeds size.");
    return setNewMaintainerLike(index, buildMaintainer(index));
  }
  public MaintainersNested<A> editFirstMaintainer() {
    if (maintainers.size() == 0) throw new RuntimeException("Can't edit first maintainers. The list is empty.");
    return setNewMaintainerLike(0, buildMaintainer(0));
  }
  public MaintainersNested<A> editLastMaintainer() {
    int index = maintainers.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last maintainers. The list is empty.");
    return setNewMaintainerLike(index, buildMaintainer(index));
  }
  public MaintainersNested<A> editMatchingMaintainer(Predicate<MaintainerBuilder> predicate) {
    int index = -1;
    for (int i=0;i<maintainers.size();i++) { 
    if (predicate.test(maintainers.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching maintainers. No match found.");
    return setNewMaintainerLike(index, buildMaintainer(index));
  }
  public String getMaturity() {
    return this.maturity;
  }
  public A withMaturity(String maturity) {
    this.maturity=maturity; return (A) this;
  }
  public boolean hasMaturity() {
    return this.maturity != null;
  }
  public String getMinKubeVersion() {
    return this.minKubeVersion;
  }
  public A withMinKubeVersion(String minKubeVersion) {
    this.minKubeVersion=minKubeVersion; return (A) this;
  }
  public boolean hasMinKubeVersion() {
    return this.minKubeVersion != null;
  }
  public A addToNativeAPIs(int index,GroupVersionKind item) {
    if (this.nativeAPIs == null) {this.nativeAPIs = new ArrayList<GroupVersionKind>();}
    this.nativeAPIs.add(index, item);
    return (A)this;
  }
  public A setToNativeAPIs(int index,GroupVersionKind item) {
    if (this.nativeAPIs == null) {this.nativeAPIs = new ArrayList<GroupVersionKind>();}
    this.nativeAPIs.set(index, item); return (A)this;
  }
  public A addToNativeAPIs(io.fabric8.kubernetes.api.model.GroupVersionKind... items) {
    if (this.nativeAPIs == null) {this.nativeAPIs = new ArrayList<GroupVersionKind>();}
    for (GroupVersionKind item : items) {this.nativeAPIs.add(item);} return (A)this;
  }
  public A addAllToNativeAPIs(Collection<GroupVersionKind> items) {
    if (this.nativeAPIs == null) {this.nativeAPIs = new ArrayList<GroupVersionKind>();}
    for (GroupVersionKind item : items) {this.nativeAPIs.add(item);} return (A)this;
  }
  public A removeFromNativeAPIs(io.fabric8.kubernetes.api.model.GroupVersionKind... items) {
    if (this.nativeAPIs == null) return (A)this;
    for (GroupVersionKind item : items) { this.nativeAPIs.remove(item);} return (A)this;
  }
  public A removeAllFromNativeAPIs(Collection<GroupVersionKind> items) {
    if (this.nativeAPIs == null) return (A)this;
    for (GroupVersionKind item : items) { this.nativeAPIs.remove(item);} return (A)this;
  }
  public List<GroupVersionKind> getNativeAPIs() {
    return this.nativeAPIs;
  }
  public GroupVersionKind getNativeAPI(int index) {
    return this.nativeAPIs.get(index);
  }
  public GroupVersionKind getFirstNativeAPI() {
    return this.nativeAPIs.get(0);
  }
  public GroupVersionKind getLastNativeAPI() {
    return this.nativeAPIs.get(nativeAPIs.size() - 1);
  }
  public GroupVersionKind getMatchingNativeAPI(Predicate<GroupVersionKind> predicate) {
    for (GroupVersionKind item: nativeAPIs) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingNativeAPI(Predicate<GroupVersionKind> predicate) {
    for (GroupVersionKind item: nativeAPIs) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withNativeAPIs(List<GroupVersionKind> nativeAPIs) {
    if (nativeAPIs != null) {this.nativeAPIs = new ArrayList(); for (GroupVersionKind item : nativeAPIs){this.addToNativeAPIs(item);}} else { this.nativeAPIs = null;} return (A) this;
  }
  public A withNativeAPIs(io.fabric8.kubernetes.api.model.GroupVersionKind... nativeAPIs) {
    if (this.nativeAPIs != null) {this.nativeAPIs.clear(); _visitables.remove("nativeAPIs"); }
    if (nativeAPIs != null) {for (GroupVersionKind item :nativeAPIs){ this.addToNativeAPIs(item);}} return (A) this;
  }
  public boolean hasNativeAPIs() {
    return nativeAPIs != null && !nativeAPIs.isEmpty();
  }
  public A addNewNativeAPI(String group,String kind,String version) {
    return (A)addToNativeAPIs(new GroupVersionKind(group, kind, version));
  }
  public AppLink buildProvider() {
    return this.provider!=null ?this.provider.build():null;
  }
  public A withProvider(AppLink provider) {
    _visitables.get("provider").remove(this.provider);
    if (provider!=null){ this.provider= new AppLinkBuilder(provider); _visitables.get("provider").add(this.provider);} else { this.provider = null; _visitables.get("provider").remove(this.provider); } return (A) this;
  }
  public boolean hasProvider() {
    return this.provider != null;
  }
  public A withNewProvider(String name,String url) {
    return (A)withProvider(new AppLink(name, url));
  }
  public ProviderNested<A> withNewProvider() {
    return new ProviderNested(null);
  }
  public ProviderNested<A> withNewProviderLike(AppLink item) {
    return new ProviderNested(item);
  }
  public ProviderNested<A> editProvider() {
    return withNewProviderLike(java.util.Optional.ofNullable(buildProvider()).orElse(null));
  }
  public ProviderNested<A> editOrNewProvider() {
    return withNewProviderLike(java.util.Optional.ofNullable(buildProvider()).orElse(new AppLinkBuilder().build()));
  }
  public ProviderNested<A> editOrNewProviderLike(AppLink item) {
    return withNewProviderLike(java.util.Optional.ofNullable(buildProvider()).orElse(item));
  }
  public A addToRelatedImages(int index,RelatedImage item) {
    if (this.relatedImages == null) {this.relatedImages = new ArrayList<RelatedImageBuilder>();}
    RelatedImageBuilder builder = new RelatedImageBuilder(item);
    if (index < 0 || index >= relatedImages.size()) { _visitables.get("relatedImages").add(builder); relatedImages.add(builder); } else { _visitables.get("relatedImages").add(index, builder); relatedImages.add(index, builder);}
    return (A)this;
  }
  public A setToRelatedImages(int index,RelatedImage item) {
    if (this.relatedImages == null) {this.relatedImages = new ArrayList<RelatedImageBuilder>();}
    RelatedImageBuilder builder = new RelatedImageBuilder(item);
    if (index < 0 || index >= relatedImages.size()) { _visitables.get("relatedImages").add(builder); relatedImages.add(builder); } else { _visitables.get("relatedImages").set(index, builder); relatedImages.set(index, builder);}
    return (A)this;
  }
  public A addToRelatedImages(io.fabric8.openshift.api.model.operatorhub.v1alpha1.RelatedImage... items) {
    if (this.relatedImages == null) {this.relatedImages = new ArrayList<RelatedImageBuilder>();}
    for (RelatedImage item : items) {RelatedImageBuilder builder = new RelatedImageBuilder(item);_visitables.get("relatedImages").add(builder);this.relatedImages.add(builder);} return (A)this;
  }
  public A addAllToRelatedImages(Collection<RelatedImage> items) {
    if (this.relatedImages == null) {this.relatedImages = new ArrayList<RelatedImageBuilder>();}
    for (RelatedImage item : items) {RelatedImageBuilder builder = new RelatedImageBuilder(item);_visitables.get("relatedImages").add(builder);this.relatedImages.add(builder);} return (A)this;
  }
  public A removeFromRelatedImages(io.fabric8.openshift.api.model.operatorhub.v1alpha1.RelatedImage... items) {
    if (this.relatedImages == null) return (A)this;
    for (RelatedImage item : items) {RelatedImageBuilder builder = new RelatedImageBuilder(item);_visitables.get("relatedImages").remove(builder); this.relatedImages.remove(builder);} return (A)this;
  }
  public A removeAllFromRelatedImages(Collection<RelatedImage> items) {
    if (this.relatedImages == null) return (A)this;
    for (RelatedImage item : items) {RelatedImageBuilder builder = new RelatedImageBuilder(item);_visitables.get("relatedImages").remove(builder); this.relatedImages.remove(builder);} return (A)this;
  }
  public A removeMatchingFromRelatedImages(Predicate<RelatedImageBuilder> predicate) {
    if (relatedImages == null) return (A) this;
    final Iterator<RelatedImageBuilder> each = relatedImages.iterator();
    final List visitables = _visitables.get("relatedImages");
    while (each.hasNext()) {
      RelatedImageBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<RelatedImage> buildRelatedImages() {
    return relatedImages != null ? build(relatedImages) : null;
  }
  public RelatedImage buildRelatedImage(int index) {
    return this.relatedImages.get(index).build();
  }
  public RelatedImage buildFirstRelatedImage() {
    return this.relatedImages.get(0).build();
  }
  public RelatedImage buildLastRelatedImage() {
    return this.relatedImages.get(relatedImages.size() - 1).build();
  }
  public RelatedImage buildMatchingRelatedImage(Predicate<RelatedImageBuilder> predicate) {
    for (RelatedImageBuilder item: relatedImages) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingRelatedImage(Predicate<RelatedImageBuilder> predicate) {
    for (RelatedImageBuilder item: relatedImages) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withRelatedImages(List<RelatedImage> relatedImages) {
    if (this.relatedImages != null) { _visitables.get("relatedImages").clear();}
    if (relatedImages != null) {this.relatedImages = new ArrayList(); for (RelatedImage item : relatedImages){this.addToRelatedImages(item);}} else { this.relatedImages = null;} return (A) this;
  }
  public A withRelatedImages(io.fabric8.openshift.api.model.operatorhub.v1alpha1.RelatedImage... relatedImages) {
    if (this.relatedImages != null) {this.relatedImages.clear(); _visitables.remove("relatedImages"); }
    if (relatedImages != null) {for (RelatedImage item :relatedImages){ this.addToRelatedImages(item);}} return (A) this;
  }
  public boolean hasRelatedImages() {
    return relatedImages != null && !relatedImages.isEmpty();
  }
  public A addNewRelatedImage(String image,String name) {
    return (A)addToRelatedImages(new RelatedImage(image, name));
  }
  public RelatedImagesNested<A> addNewRelatedImage() {
    return new RelatedImagesNested(-1, null);
  }
  public RelatedImagesNested<A> addNewRelatedImageLike(RelatedImage item) {
    return new RelatedImagesNested(-1, item);
  }
  public RelatedImagesNested<A> setNewRelatedImageLike(int index,RelatedImage item) {
    return new RelatedImagesNested(index, item);
  }
  public RelatedImagesNested<A> editRelatedImage(int index) {
    if (relatedImages.size() <= index) throw new RuntimeException("Can't edit relatedImages. Index exceeds size.");
    return setNewRelatedImageLike(index, buildRelatedImage(index));
  }
  public RelatedImagesNested<A> editFirstRelatedImage() {
    if (relatedImages.size() == 0) throw new RuntimeException("Can't edit first relatedImages. The list is empty.");
    return setNewRelatedImageLike(0, buildRelatedImage(0));
  }
  public RelatedImagesNested<A> editLastRelatedImage() {
    int index = relatedImages.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last relatedImages. The list is empty.");
    return setNewRelatedImageLike(index, buildRelatedImage(index));
  }
  public RelatedImagesNested<A> editMatchingRelatedImage(Predicate<RelatedImageBuilder> predicate) {
    int index = -1;
    for (int i=0;i<relatedImages.size();i++) { 
    if (predicate.test(relatedImages.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching relatedImages. No match found.");
    return setNewRelatedImageLike(index, buildRelatedImage(index));
  }
  public String getReplaces() {
    return this.replaces;
  }
  public A withReplaces(String replaces) {
    this.replaces=replaces; return (A) this;
  }
  public boolean hasReplaces() {
    return this.replaces != null;
  }
  public LabelSelector buildSelector() {
    return this.selector!=null ?this.selector.build():null;
  }
  public A withSelector(LabelSelector selector) {
    _visitables.get("selector").remove(this.selector);
    if (selector!=null){ this.selector= new LabelSelectorBuilder(selector); _visitables.get("selector").add(this.selector);} else { this.selector = null; _visitables.get("selector").remove(this.selector); } return (A) this;
  }
  public boolean hasSelector() {
    return this.selector != null;
  }
  public SelectorNested<A> withNewSelector() {
    return new SelectorNested(null);
  }
  public SelectorNested<A> withNewSelectorLike(LabelSelector item) {
    return new SelectorNested(item);
  }
  public SelectorNested<A> editSelector() {
    return withNewSelectorLike(java.util.Optional.ofNullable(buildSelector()).orElse(null));
  }
  public SelectorNested<A> editOrNewSelector() {
    return withNewSelectorLike(java.util.Optional.ofNullable(buildSelector()).orElse(new LabelSelectorBuilder().build()));
  }
  public SelectorNested<A> editOrNewSelectorLike(LabelSelector item) {
    return withNewSelectorLike(java.util.Optional.ofNullable(buildSelector()).orElse(item));
  }
  public A addToSkips(int index,String item) {
    if (this.skips == null) {this.skips = new ArrayList<String>();}
    this.skips.add(index, item);
    return (A)this;
  }
  public A setToSkips(int index,String item) {
    if (this.skips == null) {this.skips = new ArrayList<String>();}
    this.skips.set(index, item); return (A)this;
  }
  public A addToSkips(java.lang.String... items) {
    if (this.skips == null) {this.skips = new ArrayList<String>();}
    for (String item : items) {this.skips.add(item);} return (A)this;
  }
  public A addAllToSkips(Collection<String> items) {
    if (this.skips == null) {this.skips = new ArrayList<String>();}
    for (String item : items) {this.skips.add(item);} return (A)this;
  }
  public A removeFromSkips(java.lang.String... items) {
    if (this.skips == null) return (A)this;
    for (String item : items) { this.skips.remove(item);} return (A)this;
  }
  public A removeAllFromSkips(Collection<String> items) {
    if (this.skips == null) return (A)this;
    for (String item : items) { this.skips.remove(item);} return (A)this;
  }
  public List<String> getSkips() {
    return this.skips;
  }
  public String getSkip(int index) {
    return this.skips.get(index);
  }
  public String getFirstSkip() {
    return this.skips.get(0);
  }
  public String getLastSkip() {
    return this.skips.get(skips.size() - 1);
  }
  public String getMatchingSkip(Predicate<String> predicate) {
    for (String item: skips) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingSkip(Predicate<String> predicate) {
    for (String item: skips) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withSkips(List<String> skips) {
    if (skips != null) {this.skips = new ArrayList(); for (String item : skips){this.addToSkips(item);}} else { this.skips = null;} return (A) this;
  }
  public A withSkips(java.lang.String... skips) {
    if (this.skips != null) {this.skips.clear(); _visitables.remove("skips"); }
    if (skips != null) {for (String item :skips){ this.addToSkips(item);}} return (A) this;
  }
  public boolean hasSkips() {
    return skips != null && !skips.isEmpty();
  }
  public String getVersion() {
    return this.version;
  }
  public A withVersion(String version) {
    this.version=version; return (A) this;
  }
  public boolean hasVersion() {
    return this.version != null;
  }
  public A addToWebhookdefinitions(int index,WebhookDescription item) {
    if (this.webhookdefinitions == null) {this.webhookdefinitions = new ArrayList<WebhookDescriptionBuilder>();}
    WebhookDescriptionBuilder builder = new WebhookDescriptionBuilder(item);
    if (index < 0 || index >= webhookdefinitions.size()) { _visitables.get("webhookdefinitions").add(builder); webhookdefinitions.add(builder); } else { _visitables.get("webhookdefinitions").add(index, builder); webhookdefinitions.add(index, builder);}
    return (A)this;
  }
  public A setToWebhookdefinitions(int index,WebhookDescription item) {
    if (this.webhookdefinitions == null) {this.webhookdefinitions = new ArrayList<WebhookDescriptionBuilder>();}
    WebhookDescriptionBuilder builder = new WebhookDescriptionBuilder(item);
    if (index < 0 || index >= webhookdefinitions.size()) { _visitables.get("webhookdefinitions").add(builder); webhookdefinitions.add(builder); } else { _visitables.get("webhookdefinitions").set(index, builder); webhookdefinitions.set(index, builder);}
    return (A)this;
  }
  public A addToWebhookdefinitions(io.fabric8.openshift.api.model.operatorhub.v1alpha1.WebhookDescription... items) {
    if (this.webhookdefinitions == null) {this.webhookdefinitions = new ArrayList<WebhookDescriptionBuilder>();}
    for (WebhookDescription item : items) {WebhookDescriptionBuilder builder = new WebhookDescriptionBuilder(item);_visitables.get("webhookdefinitions").add(builder);this.webhookdefinitions.add(builder);} return (A)this;
  }
  public A addAllToWebhookdefinitions(Collection<WebhookDescription> items) {
    if (this.webhookdefinitions == null) {this.webhookdefinitions = new ArrayList<WebhookDescriptionBuilder>();}
    for (WebhookDescription item : items) {WebhookDescriptionBuilder builder = new WebhookDescriptionBuilder(item);_visitables.get("webhookdefinitions").add(builder);this.webhookdefinitions.add(builder);} return (A)this;
  }
  public A removeFromWebhookdefinitions(io.fabric8.openshift.api.model.operatorhub.v1alpha1.WebhookDescription... items) {
    if (this.webhookdefinitions == null) return (A)this;
    for (WebhookDescription item : items) {WebhookDescriptionBuilder builder = new WebhookDescriptionBuilder(item);_visitables.get("webhookdefinitions").remove(builder); this.webhookdefinitions.remove(builder);} return (A)this;
  }
  public A removeAllFromWebhookdefinitions(Collection<WebhookDescription> items) {
    if (this.webhookdefinitions == null) return (A)this;
    for (WebhookDescription item : items) {WebhookDescriptionBuilder builder = new WebhookDescriptionBuilder(item);_visitables.get("webhookdefinitions").remove(builder); this.webhookdefinitions.remove(builder);} return (A)this;
  }
  public A removeMatchingFromWebhookdefinitions(Predicate<WebhookDescriptionBuilder> predicate) {
    if (webhookdefinitions == null) return (A) this;
    final Iterator<WebhookDescriptionBuilder> each = webhookdefinitions.iterator();
    final List visitables = _visitables.get("webhookdefinitions");
    while (each.hasNext()) {
      WebhookDescriptionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<WebhookDescription> buildWebhookdefinitions() {
    return webhookdefinitions != null ? build(webhookdefinitions) : null;
  }
  public WebhookDescription buildWebhookdefinition(int index) {
    return this.webhookdefinitions.get(index).build();
  }
  public WebhookDescription buildFirstWebhookdefinition() {
    return this.webhookdefinitions.get(0).build();
  }
  public WebhookDescription buildLastWebhookdefinition() {
    return this.webhookdefinitions.get(webhookdefinitions.size() - 1).build();
  }
  public WebhookDescription buildMatchingWebhookdefinition(Predicate<WebhookDescriptionBuilder> predicate) {
    for (WebhookDescriptionBuilder item: webhookdefinitions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingWebhookdefinition(Predicate<WebhookDescriptionBuilder> predicate) {
    for (WebhookDescriptionBuilder item: webhookdefinitions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withWebhookdefinitions(List<WebhookDescription> webhookdefinitions) {
    if (this.webhookdefinitions != null) { _visitables.get("webhookdefinitions").clear();}
    if (webhookdefinitions != null) {this.webhookdefinitions = new ArrayList(); for (WebhookDescription item : webhookdefinitions){this.addToWebhookdefinitions(item);}} else { this.webhookdefinitions = null;} return (A) this;
  }
  public A withWebhookdefinitions(io.fabric8.openshift.api.model.operatorhub.v1alpha1.WebhookDescription... webhookdefinitions) {
    if (this.webhookdefinitions != null) {this.webhookdefinitions.clear(); _visitables.remove("webhookdefinitions"); }
    if (webhookdefinitions != null) {for (WebhookDescription item :webhookdefinitions){ this.addToWebhookdefinitions(item);}} return (A) this;
  }
  public boolean hasWebhookdefinitions() {
    return webhookdefinitions != null && !webhookdefinitions.isEmpty();
  }
  public WebhookdefinitionsNested<A> addNewWebhookdefinition() {
    return new WebhookdefinitionsNested(-1, null);
  }
  public WebhookdefinitionsNested<A> addNewWebhookdefinitionLike(WebhookDescription item) {
    return new WebhookdefinitionsNested(-1, item);
  }
  public WebhookdefinitionsNested<A> setNewWebhookdefinitionLike(int index,WebhookDescription item) {
    return new WebhookdefinitionsNested(index, item);
  }
  public WebhookdefinitionsNested<A> editWebhookdefinition(int index) {
    if (webhookdefinitions.size() <= index) throw new RuntimeException("Can't edit webhookdefinitions. Index exceeds size.");
    return setNewWebhookdefinitionLike(index, buildWebhookdefinition(index));
  }
  public WebhookdefinitionsNested<A> editFirstWebhookdefinition() {
    if (webhookdefinitions.size() == 0) throw new RuntimeException("Can't edit first webhookdefinitions. The list is empty.");
    return setNewWebhookdefinitionLike(0, buildWebhookdefinition(0));
  }
  public WebhookdefinitionsNested<A> editLastWebhookdefinition() {
    int index = webhookdefinitions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last webhookdefinitions. The list is empty.");
    return setNewWebhookdefinitionLike(index, buildWebhookdefinition(index));
  }
  public WebhookdefinitionsNested<A> editMatchingWebhookdefinition(Predicate<WebhookDescriptionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<webhookdefinitions.size();i++) { 
    if (predicate.test(webhookdefinitions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching webhookdefinitions. No match found.");
    return setNewWebhookdefinitionLike(index, buildWebhookdefinition(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ClusterServiceVersionSpecFluent that = (ClusterServiceVersionSpecFluent) o;
    if (!java.util.Objects.equals(annotations, that.annotations)) return false;

    if (!java.util.Objects.equals(apiservicedefinitions, that.apiservicedefinitions)) return false;

    if (!java.util.Objects.equals(cleanup, that.cleanup)) return false;

    if (!java.util.Objects.equals(customresourcedefinitions, that.customresourcedefinitions)) return false;

    if (!java.util.Objects.equals(description, that.description)) return false;

    if (!java.util.Objects.equals(displayName, that.displayName)) return false;

    if (!java.util.Objects.equals(icon, that.icon)) return false;

    if (!java.util.Objects.equals(install, that.install)) return false;

    if (!java.util.Objects.equals(installModes, that.installModes)) return false;

    if (!java.util.Objects.equals(keywords, that.keywords)) return false;

    if (!java.util.Objects.equals(labels, that.labels)) return false;

    if (!java.util.Objects.equals(links, that.links)) return false;

    if (!java.util.Objects.equals(maintainers, that.maintainers)) return false;

    if (!java.util.Objects.equals(maturity, that.maturity)) return false;

    if (!java.util.Objects.equals(minKubeVersion, that.minKubeVersion)) return false;

    if (!java.util.Objects.equals(nativeAPIs, that.nativeAPIs)) return false;

    if (!java.util.Objects.equals(provider, that.provider)) return false;

    if (!java.util.Objects.equals(relatedImages, that.relatedImages)) return false;

    if (!java.util.Objects.equals(replaces, that.replaces)) return false;

    if (!java.util.Objects.equals(selector, that.selector)) return false;

    if (!java.util.Objects.equals(skips, that.skips)) return false;

    if (!java.util.Objects.equals(version, that.version)) return false;

    if (!java.util.Objects.equals(webhookdefinitions, that.webhookdefinitions)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(annotations,  apiservicedefinitions,  cleanup,  customresourcedefinitions,  description,  displayName,  icon,  install,  installModes,  keywords,  labels,  links,  maintainers,  maturity,  minKubeVersion,  nativeAPIs,  provider,  relatedImages,  replaces,  selector,  skips,  version,  webhookdefinitions,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (annotations != null && !annotations.isEmpty()) { sb.append("annotations:"); sb.append(annotations + ","); }
    if (apiservicedefinitions != null) { sb.append("apiservicedefinitions:"); sb.append(apiservicedefinitions + ","); }
    if (cleanup != null) { sb.append("cleanup:"); sb.append(cleanup + ","); }
    if (customresourcedefinitions != null) { sb.append("customresourcedefinitions:"); sb.append(customresourcedefinitions + ","); }
    if (description != null) { sb.append("description:"); sb.append(description + ","); }
    if (displayName != null) { sb.append("displayName:"); sb.append(displayName + ","); }
    if (icon != null && !icon.isEmpty()) { sb.append("icon:"); sb.append(icon + ","); }
    if (install != null) { sb.append("install:"); sb.append(install + ","); }
    if (installModes != null && !installModes.isEmpty()) { sb.append("installModes:"); sb.append(installModes + ","); }
    if (keywords != null && !keywords.isEmpty()) { sb.append("keywords:"); sb.append(keywords + ","); }
    if (labels != null && !labels.isEmpty()) { sb.append("labels:"); sb.append(labels + ","); }
    if (links != null && !links.isEmpty()) { sb.append("links:"); sb.append(links + ","); }
    if (maintainers != null && !maintainers.isEmpty()) { sb.append("maintainers:"); sb.append(maintainers + ","); }
    if (maturity != null) { sb.append("maturity:"); sb.append(maturity + ","); }
    if (minKubeVersion != null) { sb.append("minKubeVersion:"); sb.append(minKubeVersion + ","); }
    if (nativeAPIs != null && !nativeAPIs.isEmpty()) { sb.append("nativeAPIs:"); sb.append(nativeAPIs + ","); }
    if (provider != null) { sb.append("provider:"); sb.append(provider + ","); }
    if (relatedImages != null && !relatedImages.isEmpty()) { sb.append("relatedImages:"); sb.append(relatedImages + ","); }
    if (replaces != null) { sb.append("replaces:"); sb.append(replaces + ","); }
    if (selector != null) { sb.append("selector:"); sb.append(selector + ","); }
    if (skips != null && !skips.isEmpty()) { sb.append("skips:"); sb.append(skips + ","); }
    if (version != null) { sb.append("version:"); sb.append(version + ","); }
    if (webhookdefinitions != null && !webhookdefinitions.isEmpty()) { sb.append("webhookdefinitions:"); sb.append(webhookdefinitions + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ApiservicedefinitionsNested<N> extends APIServiceDefinitionsFluent<ApiservicedefinitionsNested<N>> implements Nested<N>{
    ApiservicedefinitionsNested(APIServiceDefinitions item) {
      this.builder = new APIServiceDefinitionsBuilder(this, item);
    }
    APIServiceDefinitionsBuilder builder;
    public N and() {
      return (N) ClusterServiceVersionSpecFluent.this.withApiservicedefinitions(builder.build());
    }
    public N endApiservicedefinitions() {
      return and();
    }
    
  }
  public class CleanupNested<N> extends CleanupSpecFluent<CleanupNested<N>> implements Nested<N>{
    CleanupNested(CleanupSpec item) {
      this.builder = new CleanupSpecBuilder(this, item);
    }
    CleanupSpecBuilder builder;
    public N and() {
      return (N) ClusterServiceVersionSpecFluent.this.withCleanup(builder.build());
    }
    public N endCleanup() {
      return and();
    }
    
  }
  public class CustomresourcedefinitionsNested<N> extends CustomResourceDefinitionsFluent<CustomresourcedefinitionsNested<N>> implements Nested<N>{
    CustomresourcedefinitionsNested(CustomResourceDefinitions item) {
      this.builder = new CustomResourceDefinitionsBuilder(this, item);
    }
    CustomResourceDefinitionsBuilder builder;
    public N and() {
      return (N) ClusterServiceVersionSpecFluent.this.withCustomresourcedefinitions(builder.build());
    }
    public N endCustomresourcedefinitions() {
      return and();
    }
    
  }
  public class IconNested<N> extends IconFluent<IconNested<N>> implements Nested<N>{
    IconNested(int index,Icon item) {
      this.index = index;
      this.builder = new IconBuilder(this, item);
    }
    IconBuilder builder;
    int index;
    public N and() {
      return (N) ClusterServiceVersionSpecFluent.this.setToIcon(index,builder.build());
    }
    public N endIcon() {
      return and();
    }
    
  }
  public class InstallNested<N> extends NamedInstallStrategyFluent<InstallNested<N>> implements Nested<N>{
    InstallNested(NamedInstallStrategy item) {
      this.builder = new NamedInstallStrategyBuilder(this, item);
    }
    NamedInstallStrategyBuilder builder;
    public N and() {
      return (N) ClusterServiceVersionSpecFluent.this.withInstall(builder.build());
    }
    public N endInstall() {
      return and();
    }
    
  }
  public class InstallModesNested<N> extends InstallModeFluent<InstallModesNested<N>> implements Nested<N>{
    InstallModesNested(int index,InstallMode item) {
      this.index = index;
      this.builder = new InstallModeBuilder(this, item);
    }
    InstallModeBuilder builder;
    int index;
    public N and() {
      return (N) ClusterServiceVersionSpecFluent.this.setToInstallModes(index,builder.build());
    }
    public N endInstallMode() {
      return and();
    }
    
  }
  public class LinksNested<N> extends AppLinkFluent<LinksNested<N>> implements Nested<N>{
    LinksNested(int index,AppLink item) {
      this.index = index;
      this.builder = new AppLinkBuilder(this, item);
    }
    AppLinkBuilder builder;
    int index;
    public N and() {
      return (N) ClusterServiceVersionSpecFluent.this.setToLinks(index,builder.build());
    }
    public N endLink() {
      return and();
    }
    
  }
  public class MaintainersNested<N> extends MaintainerFluent<MaintainersNested<N>> implements Nested<N>{
    MaintainersNested(int index,Maintainer item) {
      this.index = index;
      this.builder = new MaintainerBuilder(this, item);
    }
    MaintainerBuilder builder;
    int index;
    public N and() {
      return (N) ClusterServiceVersionSpecFluent.this.setToMaintainers(index,builder.build());
    }
    public N endMaintainer() {
      return and();
    }
    
  }
  public class ProviderNested<N> extends AppLinkFluent<ProviderNested<N>> implements Nested<N>{
    ProviderNested(AppLink item) {
      this.builder = new AppLinkBuilder(this, item);
    }
    AppLinkBuilder builder;
    public N and() {
      return (N) ClusterServiceVersionSpecFluent.this.withProvider(builder.build());
    }
    public N endProvider() {
      return and();
    }
    
  }
  public class RelatedImagesNested<N> extends RelatedImageFluent<RelatedImagesNested<N>> implements Nested<N>{
    RelatedImagesNested(int index,RelatedImage item) {
      this.index = index;
      this.builder = new RelatedImageBuilder(this, item);
    }
    RelatedImageBuilder builder;
    int index;
    public N and() {
      return (N) ClusterServiceVersionSpecFluent.this.setToRelatedImages(index,builder.build());
    }
    public N endRelatedImage() {
      return and();
    }
    
  }
  public class SelectorNested<N> extends LabelSelectorFluent<SelectorNested<N>> implements Nested<N>{
    SelectorNested(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    LabelSelectorBuilder builder;
    public N and() {
      return (N) ClusterServiceVersionSpecFluent.this.withSelector(builder.build());
    }
    public N endSelector() {
      return and();
    }
    
  }
  public class WebhookdefinitionsNested<N> extends WebhookDescriptionFluent<WebhookdefinitionsNested<N>> implements Nested<N>{
    WebhookdefinitionsNested(int index,WebhookDescription item) {
      this.index = index;
      this.builder = new WebhookDescriptionBuilder(this, item);
    }
    WebhookDescriptionBuilder builder;
    int index;
    public N and() {
      return (N) ClusterServiceVersionSpecFluent.this.setToWebhookdefinitions(index,builder.build());
    }
    public N endWebhookdefinition() {
      return and();
    }
    
  }
  
}