package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class InstallModeBuilder extends InstallModeFluent<InstallModeBuilder> implements VisitableBuilder<InstallMode,InstallModeBuilder>{
  public InstallModeBuilder() {
    this(false);
  }
  public InstallModeBuilder(Boolean validationEnabled) {
    this(new InstallMode(), validationEnabled);
  }
  public InstallModeBuilder(InstallModeFluent<?> fluent) {
    this(fluent, false);
  }
  public InstallModeBuilder(InstallModeFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new InstallMode(), validationEnabled);
  }
  public InstallModeBuilder(InstallModeFluent<?> fluent,InstallMode instance) {
    this(fluent, instance, false);
  }
  public InstallModeBuilder(InstallModeFluent<?> fluent,InstallMode instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new InstallMode());

    if (instance != null) {
      fluent.withSupported(instance.getSupported());
      fluent.withType(instance.getType());
      fluent.withSupported(instance.getSupported());
      fluent.withType(instance.getType());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public InstallModeBuilder(InstallMode instance) {
    this(instance,false);
  }
  public InstallModeBuilder(InstallMode instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new InstallMode());

    if (instance != null) {
      this.withSupported(instance.getSupported());
      this.withType(instance.getType());
      this.withSupported(instance.getSupported());
      this.withType(instance.getType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  InstallModeFluent<?> fluent;
  Boolean validationEnabled;
  public InstallMode build() {
    InstallMode buildable = new InstallMode(fluent.getSupported(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}