package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RegistryServiceStatusBuilder extends RegistryServiceStatusFluent<RegistryServiceStatusBuilder> implements VisitableBuilder<RegistryServiceStatus,RegistryServiceStatusBuilder>{
  public RegistryServiceStatusBuilder() {
    this(false);
  }
  public RegistryServiceStatusBuilder(Boolean validationEnabled) {
    this(new RegistryServiceStatus(), validationEnabled);
  }
  public RegistryServiceStatusBuilder(RegistryServiceStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public RegistryServiceStatusBuilder(RegistryServiceStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new RegistryServiceStatus(), validationEnabled);
  }
  public RegistryServiceStatusBuilder(RegistryServiceStatusFluent<?> fluent,RegistryServiceStatus instance) {
    this(fluent, instance, false);
  }
  public RegistryServiceStatusBuilder(RegistryServiceStatusFluent<?> fluent,RegistryServiceStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new RegistryServiceStatus());

    if (instance != null) {
      fluent.withCreatedAt(instance.getCreatedAt());
      fluent.withPort(instance.getPort());
      fluent.withProtocol(instance.getProtocol());
      fluent.withServiceName(instance.getServiceName());
      fluent.withServiceNamespace(instance.getServiceNamespace());
      fluent.withCreatedAt(instance.getCreatedAt());
      fluent.withPort(instance.getPort());
      fluent.withProtocol(instance.getProtocol());
      fluent.withServiceName(instance.getServiceName());
      fluent.withServiceNamespace(instance.getServiceNamespace());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public RegistryServiceStatusBuilder(RegistryServiceStatus instance) {
    this(instance,false);
  }
  public RegistryServiceStatusBuilder(RegistryServiceStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new RegistryServiceStatus());

    if (instance != null) {
      this.withCreatedAt(instance.getCreatedAt());
      this.withPort(instance.getPort());
      this.withProtocol(instance.getProtocol());
      this.withServiceName(instance.getServiceName());
      this.withServiceNamespace(instance.getServiceNamespace());
      this.withCreatedAt(instance.getCreatedAt());
      this.withPort(instance.getPort());
      this.withProtocol(instance.getProtocol());
      this.withServiceName(instance.getServiceName());
      this.withServiceNamespace(instance.getServiceNamespace());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  RegistryServiceStatusFluent<?> fluent;
  Boolean validationEnabled;
  public RegistryServiceStatus build() {
    RegistryServiceStatus buildable = new RegistryServiceStatus(fluent.getCreatedAt(),fluent.getPort(),fluent.getProtocol(),fluent.getServiceName(),fluent.getServiceNamespace());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}