package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ResourceListFluent<A extends ResourceListFluent<A>> extends BaseFluent<A>{
  public ResourceListFluent() {
  }
  public ResourceListFluent(ResourceList instance) {
    instance = (instance != null ? instance : new ResourceList());

    if (instance != null) {
      this.withGroup(instance.getGroup());
      this.withInstances(instance.getInstances());
      this.withKind(instance.getKind());
      this.withGroup(instance.getGroup());
      this.withInstances(instance.getInstances());
      this.withKind(instance.getKind());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String group;
  private ArrayList<ResourceInstanceBuilder> instances = new ArrayList<ResourceInstanceBuilder>();
  private String kind;
  private Map<String,Object> additionalProperties;
  public String getGroup() {
    return this.group;
  }
  public A withGroup(String group) {
    this.group=group; return (A) this;
  }
  public boolean hasGroup() {
    return this.group != null;
  }
  public A addToInstances(int index,ResourceInstance item) {
    if (this.instances == null) {this.instances = new ArrayList<ResourceInstanceBuilder>();}
    ResourceInstanceBuilder builder = new ResourceInstanceBuilder(item);
    if (index < 0 || index >= instances.size()) { _visitables.get("instances").add(builder); instances.add(builder); } else { _visitables.get("instances").add(index, builder); instances.add(index, builder);}
    return (A)this;
  }
  public A setToInstances(int index,ResourceInstance item) {
    if (this.instances == null) {this.instances = new ArrayList<ResourceInstanceBuilder>();}
    ResourceInstanceBuilder builder = new ResourceInstanceBuilder(item);
    if (index < 0 || index >= instances.size()) { _visitables.get("instances").add(builder); instances.add(builder); } else { _visitables.get("instances").set(index, builder); instances.set(index, builder);}
    return (A)this;
  }
  public A addToInstances(io.fabric8.openshift.api.model.operatorhub.v1alpha1.ResourceInstance... items) {
    if (this.instances == null) {this.instances = new ArrayList<ResourceInstanceBuilder>();}
    for (ResourceInstance item : items) {ResourceInstanceBuilder builder = new ResourceInstanceBuilder(item);_visitables.get("instances").add(builder);this.instances.add(builder);} return (A)this;
  }
  public A addAllToInstances(Collection<ResourceInstance> items) {
    if (this.instances == null) {this.instances = new ArrayList<ResourceInstanceBuilder>();}
    for (ResourceInstance item : items) {ResourceInstanceBuilder builder = new ResourceInstanceBuilder(item);_visitables.get("instances").add(builder);this.instances.add(builder);} return (A)this;
  }
  public A removeFromInstances(io.fabric8.openshift.api.model.operatorhub.v1alpha1.ResourceInstance... items) {
    if (this.instances == null) return (A)this;
    for (ResourceInstance item : items) {ResourceInstanceBuilder builder = new ResourceInstanceBuilder(item);_visitables.get("instances").remove(builder); this.instances.remove(builder);} return (A)this;
  }
  public A removeAllFromInstances(Collection<ResourceInstance> items) {
    if (this.instances == null) return (A)this;
    for (ResourceInstance item : items) {ResourceInstanceBuilder builder = new ResourceInstanceBuilder(item);_visitables.get("instances").remove(builder); this.instances.remove(builder);} return (A)this;
  }
  public A removeMatchingFromInstances(Predicate<ResourceInstanceBuilder> predicate) {
    if (instances == null) return (A) this;
    final Iterator<ResourceInstanceBuilder> each = instances.iterator();
    final List visitables = _visitables.get("instances");
    while (each.hasNext()) {
      ResourceInstanceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<ResourceInstance> buildInstances() {
    return instances != null ? build(instances) : null;
  }
  public ResourceInstance buildInstance(int index) {
    return this.instances.get(index).build();
  }
  public ResourceInstance buildFirstInstance() {
    return this.instances.get(0).build();
  }
  public ResourceInstance buildLastInstance() {
    return this.instances.get(instances.size() - 1).build();
  }
  public ResourceInstance buildMatchingInstance(Predicate<ResourceInstanceBuilder> predicate) {
    for (ResourceInstanceBuilder item: instances) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingInstance(Predicate<ResourceInstanceBuilder> predicate) {
    for (ResourceInstanceBuilder item: instances) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withInstances(List<ResourceInstance> instances) {
    if (this.instances != null) { _visitables.get("instances").clear();}
    if (instances != null) {this.instances = new ArrayList(); for (ResourceInstance item : instances){this.addToInstances(item);}} else { this.instances = null;} return (A) this;
  }
  public A withInstances(io.fabric8.openshift.api.model.operatorhub.v1alpha1.ResourceInstance... instances) {
    if (this.instances != null) {this.instances.clear(); _visitables.remove("instances"); }
    if (instances != null) {for (ResourceInstance item :instances){ this.addToInstances(item);}} return (A) this;
  }
  public boolean hasInstances() {
    return instances != null && !instances.isEmpty();
  }
  public A addNewInstance(String name,String namespace) {
    return (A)addToInstances(new ResourceInstance(name, namespace));
  }
  public InstancesNested<A> addNewInstance() {
    return new InstancesNested(-1, null);
  }
  public InstancesNested<A> addNewInstanceLike(ResourceInstance item) {
    return new InstancesNested(-1, item);
  }
  public InstancesNested<A> setNewInstanceLike(int index,ResourceInstance item) {
    return new InstancesNested(index, item);
  }
  public InstancesNested<A> editInstance(int index) {
    if (instances.size() <= index) throw new RuntimeException("Can't edit instances. Index exceeds size.");
    return setNewInstanceLike(index, buildInstance(index));
  }
  public InstancesNested<A> editFirstInstance() {
    if (instances.size() == 0) throw new RuntimeException("Can't edit first instances. The list is empty.");
    return setNewInstanceLike(0, buildInstance(0));
  }
  public InstancesNested<A> editLastInstance() {
    int index = instances.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last instances. The list is empty.");
    return setNewInstanceLike(index, buildInstance(index));
  }
  public InstancesNested<A> editMatchingInstance(Predicate<ResourceInstanceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<instances.size();i++) { 
    if (predicate.test(instances.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching instances. No match found.");
    return setNewInstanceLike(index, buildInstance(index));
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public boolean hasKind() {
    return this.kind != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ResourceListFluent that = (ResourceListFluent) o;
    if (!java.util.Objects.equals(group, that.group)) return false;

    if (!java.util.Objects.equals(instances, that.instances)) return false;

    if (!java.util.Objects.equals(kind, that.kind)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(group,  instances,  kind,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (group != null) { sb.append("group:"); sb.append(group + ","); }
    if (instances != null && !instances.isEmpty()) { sb.append("instances:"); sb.append(instances + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class InstancesNested<N> extends ResourceInstanceFluent<InstancesNested<N>> implements Nested<N>{
    InstancesNested(int index,ResourceInstance item) {
      this.index = index;
      this.builder = new ResourceInstanceBuilder(this, item);
    }
    ResourceInstanceBuilder builder;
    int index;
    public N and() {
      return (N) ResourceListFluent.this.setToInstances(index,builder.build());
    }
    public N endInstance() {
      return and();
    }
    
  }
  
}