package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SpecDescriptorBuilder extends SpecDescriptorFluent<SpecDescriptorBuilder> implements VisitableBuilder<SpecDescriptor,SpecDescriptorBuilder>{
  public SpecDescriptorBuilder() {
    this(false);
  }
  public SpecDescriptorBuilder(Boolean validationEnabled) {
    this(new SpecDescriptor(), validationEnabled);
  }
  public SpecDescriptorBuilder(SpecDescriptorFluent<?> fluent) {
    this(fluent, false);
  }
  public SpecDescriptorBuilder(SpecDescriptorFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SpecDescriptor(), validationEnabled);
  }
  public SpecDescriptorBuilder(SpecDescriptorFluent<?> fluent,SpecDescriptor instance) {
    this(fluent, instance, false);
  }
  public SpecDescriptorBuilder(SpecDescriptorFluent<?> fluent,SpecDescriptor instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new SpecDescriptor());

    if (instance != null) {
      fluent.withDescription(instance.getDescription());
      fluent.withDisplayName(instance.getDisplayName());
      fluent.withPath(instance.getPath());
      fluent.withValue(instance.getValue());
      fluent.withXDescriptors(instance.getXDescriptors());
      fluent.withDescription(instance.getDescription());
      fluent.withDisplayName(instance.getDisplayName());
      fluent.withPath(instance.getPath());
      fluent.withValue(instance.getValue());
      fluent.withXDescriptors(instance.getXDescriptors());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SpecDescriptorBuilder(SpecDescriptor instance) {
    this(instance,false);
  }
  public SpecDescriptorBuilder(SpecDescriptor instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new SpecDescriptor());

    if (instance != null) {
      this.withDescription(instance.getDescription());
      this.withDisplayName(instance.getDisplayName());
      this.withPath(instance.getPath());
      this.withValue(instance.getValue());
      this.withXDescriptors(instance.getXDescriptors());
      this.withDescription(instance.getDescription());
      this.withDisplayName(instance.getDisplayName());
      this.withPath(instance.getPath());
      this.withValue(instance.getValue());
      this.withXDescriptors(instance.getXDescriptors());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  SpecDescriptorFluent<?> fluent;
  Boolean validationEnabled;
  public SpecDescriptor build() {
    SpecDescriptor buildable = new SpecDescriptor(fluent.getDescription(),fluent.getDisplayName(),fluent.getPath(),fluent.getValue(),fluent.getXDescriptors());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}