package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;
import java.util.function.Predicate;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class SpecDescriptorFluent<A extends SpecDescriptorFluent<A>> extends BaseFluent<A>{
  public SpecDescriptorFluent() {
  }
  public SpecDescriptorFluent(SpecDescriptor instance) {
    instance = (instance != null ? instance : new SpecDescriptor());

    if (instance != null) {
      this.withDescription(instance.getDescription());
      this.withDisplayName(instance.getDisplayName());
      this.withPath(instance.getPath());
      this.withValue(instance.getValue());
      this.withXDescriptors(instance.getXDescriptors());
      this.withDescription(instance.getDescription());
      this.withDisplayName(instance.getDisplayName());
      this.withPath(instance.getPath());
      this.withValue(instance.getValue());
      this.withXDescriptors(instance.getXDescriptors());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String description;
  private String displayName;
  private String path;
  private String value;
  private List<String> xDescriptors = new ArrayList<String>();
  private Map<String,Object> additionalProperties;
  public String getDescription() {
    return this.description;
  }
  public A withDescription(String description) {
    this.description=description; return (A) this;
  }
  public boolean hasDescription() {
    return this.description != null;
  }
  public String getDisplayName() {
    return this.displayName;
  }
  public A withDisplayName(String displayName) {
    this.displayName=displayName; return (A) this;
  }
  public boolean hasDisplayName() {
    return this.displayName != null;
  }
  public String getPath() {
    return this.path;
  }
  public A withPath(String path) {
    this.path=path; return (A) this;
  }
  public boolean hasPath() {
    return this.path != null;
  }
  public String getValue() {
    return this.value;
  }
  public A withValue(String value) {
    this.value=value; return (A) this;
  }
  public boolean hasValue() {
    return this.value != null;
  }
  public A addToXDescriptors(int index,String item) {
    if (this.xDescriptors == null) {this.xDescriptors = new ArrayList<String>();}
    this.xDescriptors.add(index, item);
    return (A)this;
  }
  public A setToXDescriptors(int index,String item) {
    if (this.xDescriptors == null) {this.xDescriptors = new ArrayList<String>();}
    this.xDescriptors.set(index, item); return (A)this;
  }
  public A addToXDescriptors(java.lang.String... items) {
    if (this.xDescriptors == null) {this.xDescriptors = new ArrayList<String>();}
    for (String item : items) {this.xDescriptors.add(item);} return (A)this;
  }
  public A addAllToXDescriptors(Collection<String> items) {
    if (this.xDescriptors == null) {this.xDescriptors = new ArrayList<String>();}
    for (String item : items) {this.xDescriptors.add(item);} return (A)this;
  }
  public A removeFromXDescriptors(java.lang.String... items) {
    if (this.xDescriptors == null) return (A)this;
    for (String item : items) { this.xDescriptors.remove(item);} return (A)this;
  }
  public A removeAllFromXDescriptors(Collection<String> items) {
    if (this.xDescriptors == null) return (A)this;
    for (String item : items) { this.xDescriptors.remove(item);} return (A)this;
  }
  public List<String> getXDescriptors() {
    return this.xDescriptors;
  }
  public String getXDescriptor(int index) {
    return this.xDescriptors.get(index);
  }
  public String getFirstXDescriptor() {
    return this.xDescriptors.get(0);
  }
  public String getLastXDescriptor() {
    return this.xDescriptors.get(xDescriptors.size() - 1);
  }
  public String getMatchingXDescriptor(Predicate<String> predicate) {
    for (String item: xDescriptors) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingXDescriptor(Predicate<String> predicate) {
    for (String item: xDescriptors) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withXDescriptors(List<String> xDescriptors) {
    if (xDescriptors != null) {this.xDescriptors = new ArrayList(); for (String item : xDescriptors){this.addToXDescriptors(item);}} else { this.xDescriptors = null;} return (A) this;
  }
  public A withXDescriptors(java.lang.String... xDescriptors) {
    if (this.xDescriptors != null) {this.xDescriptors.clear(); _visitables.remove("xDescriptors"); }
    if (xDescriptors != null) {for (String item :xDescriptors){ this.addToXDescriptors(item);}} return (A) this;
  }
  public boolean hasXDescriptors() {
    return xDescriptors != null && !xDescriptors.isEmpty();
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    SpecDescriptorFluent that = (SpecDescriptorFluent) o;
    if (!java.util.Objects.equals(description, that.description)) return false;

    if (!java.util.Objects.equals(displayName, that.displayName)) return false;

    if (!java.util.Objects.equals(path, that.path)) return false;

    if (!java.util.Objects.equals(value, that.value)) return false;

    if (!java.util.Objects.equals(xDescriptors, that.xDescriptors)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(description,  displayName,  path,  value,  xDescriptors,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (description != null) { sb.append("description:"); sb.append(description + ","); }
    if (displayName != null) { sb.append("displayName:"); sb.append(displayName + ","); }
    if (path != null) { sb.append("path:"); sb.append(path + ","); }
    if (value != null) { sb.append("value:"); sb.append(value + ","); }
    if (xDescriptors != null && !xDescriptors.isEmpty()) { sb.append("xDescriptors:"); sb.append(xDescriptors + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
}