package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SubscriptionConfigBuilder extends SubscriptionConfigFluent<SubscriptionConfigBuilder> implements VisitableBuilder<SubscriptionConfig,SubscriptionConfigBuilder>{
  public SubscriptionConfigBuilder() {
    this(false);
  }
  public SubscriptionConfigBuilder(Boolean validationEnabled) {
    this(new SubscriptionConfig(), validationEnabled);
  }
  public SubscriptionConfigBuilder(SubscriptionConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public SubscriptionConfigBuilder(SubscriptionConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SubscriptionConfig(), validationEnabled);
  }
  public SubscriptionConfigBuilder(SubscriptionConfigFluent<?> fluent,SubscriptionConfig instance) {
    this(fluent, instance, false);
  }
  public SubscriptionConfigBuilder(SubscriptionConfigFluent<?> fluent,SubscriptionConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new SubscriptionConfig());

    if (instance != null) {
      fluent.withEnv(instance.getEnv());
      fluent.withEnvFrom(instance.getEnvFrom());
      fluent.withNodeSelector(instance.getNodeSelector());
      fluent.withResources(instance.getResources());
      fluent.withSelector(instance.getSelector());
      fluent.withTolerations(instance.getTolerations());
      fluent.withVolumeMounts(instance.getVolumeMounts());
      fluent.withVolumes(instance.getVolumes());
      fluent.withEnv(instance.getEnv());
      fluent.withEnvFrom(instance.getEnvFrom());
      fluent.withNodeSelector(instance.getNodeSelector());
      fluent.withResources(instance.getResources());
      fluent.withSelector(instance.getSelector());
      fluent.withTolerations(instance.getTolerations());
      fluent.withVolumeMounts(instance.getVolumeMounts());
      fluent.withVolumes(instance.getVolumes());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SubscriptionConfigBuilder(SubscriptionConfig instance) {
    this(instance,false);
  }
  public SubscriptionConfigBuilder(SubscriptionConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new SubscriptionConfig());

    if (instance != null) {
      this.withEnv(instance.getEnv());
      this.withEnvFrom(instance.getEnvFrom());
      this.withNodeSelector(instance.getNodeSelector());
      this.withResources(instance.getResources());
      this.withSelector(instance.getSelector());
      this.withTolerations(instance.getTolerations());
      this.withVolumeMounts(instance.getVolumeMounts());
      this.withVolumes(instance.getVolumes());
      this.withEnv(instance.getEnv());
      this.withEnvFrom(instance.getEnvFrom());
      this.withNodeSelector(instance.getNodeSelector());
      this.withResources(instance.getResources());
      this.withSelector(instance.getSelector());
      this.withTolerations(instance.getTolerations());
      this.withVolumeMounts(instance.getVolumeMounts());
      this.withVolumes(instance.getVolumes());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  SubscriptionConfigFluent<?> fluent;
  Boolean validationEnabled;
  public SubscriptionConfig build() {
    SubscriptionConfig buildable = new SubscriptionConfig(fluent.getEnv(),fluent.getEnvFrom(),fluent.getNodeSelector(),fluent.buildResources(),fluent.buildSelector(),fluent.getTolerations(),fluent.getVolumeMounts(),fluent.getVolumes());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}