package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SubscriptionStatusBuilder extends SubscriptionStatusFluent<SubscriptionStatusBuilder> implements VisitableBuilder<SubscriptionStatus,SubscriptionStatusBuilder>{
  public SubscriptionStatusBuilder() {
    this(false);
  }
  public SubscriptionStatusBuilder(Boolean validationEnabled) {
    this(new SubscriptionStatus(), validationEnabled);
  }
  public SubscriptionStatusBuilder(SubscriptionStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public SubscriptionStatusBuilder(SubscriptionStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SubscriptionStatus(), validationEnabled);
  }
  public SubscriptionStatusBuilder(SubscriptionStatusFluent<?> fluent,SubscriptionStatus instance) {
    this(fluent, instance, false);
  }
  public SubscriptionStatusBuilder(SubscriptionStatusFluent<?> fluent,SubscriptionStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new SubscriptionStatus());

    if (instance != null) {
      fluent.withCatalogHealth(instance.getCatalogHealth());
      fluent.withConditions(instance.getConditions());
      fluent.withCurrentCSV(instance.getCurrentCSV());
      fluent.withInstallPlanGeneration(instance.getInstallPlanGeneration());
      fluent.withInstallPlanRef(instance.getInstallPlanRef());
      fluent.withInstalledCSV(instance.getInstalledCSV());
      fluent.withInstallplan(instance.getInstallplan());
      fluent.withLastUpdated(instance.getLastUpdated());
      fluent.withReason(instance.getReason());
      fluent.withState(instance.getState());
      fluent.withCatalogHealth(instance.getCatalogHealth());
      fluent.withConditions(instance.getConditions());
      fluent.withCurrentCSV(instance.getCurrentCSV());
      fluent.withInstallPlanGeneration(instance.getInstallPlanGeneration());
      fluent.withInstallPlanRef(instance.getInstallPlanRef());
      fluent.withInstalledCSV(instance.getInstalledCSV());
      fluent.withInstallplan(instance.getInstallplan());
      fluent.withLastUpdated(instance.getLastUpdated());
      fluent.withReason(instance.getReason());
      fluent.withState(instance.getState());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SubscriptionStatusBuilder(SubscriptionStatus instance) {
    this(instance,false);
  }
  public SubscriptionStatusBuilder(SubscriptionStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new SubscriptionStatus());

    if (instance != null) {
      this.withCatalogHealth(instance.getCatalogHealth());
      this.withConditions(instance.getConditions());
      this.withCurrentCSV(instance.getCurrentCSV());
      this.withInstallPlanGeneration(instance.getInstallPlanGeneration());
      this.withInstallPlanRef(instance.getInstallPlanRef());
      this.withInstalledCSV(instance.getInstalledCSV());
      this.withInstallplan(instance.getInstallplan());
      this.withLastUpdated(instance.getLastUpdated());
      this.withReason(instance.getReason());
      this.withState(instance.getState());
      this.withCatalogHealth(instance.getCatalogHealth());
      this.withConditions(instance.getConditions());
      this.withCurrentCSV(instance.getCurrentCSV());
      this.withInstallPlanGeneration(instance.getInstallPlanGeneration());
      this.withInstallPlanRef(instance.getInstallPlanRef());
      this.withInstalledCSV(instance.getInstalledCSV());
      this.withInstallplan(instance.getInstallplan());
      this.withLastUpdated(instance.getLastUpdated());
      this.withReason(instance.getReason());
      this.withState(instance.getState());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  SubscriptionStatusFluent<?> fluent;
  Boolean validationEnabled;
  public SubscriptionStatus build() {
    SubscriptionStatus buildable = new SubscriptionStatus(fluent.buildCatalogHealth(),fluent.buildConditions(),fluent.getCurrentCSV(),fluent.getInstallPlanGeneration(),fluent.buildInstallPlanRef(),fluent.getInstalledCSV(),fluent.buildInstallplan(),fluent.getLastUpdated(),fluent.getReason(),fluent.getState());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}