package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class WebhookDescriptionBuilder extends WebhookDescriptionFluent<WebhookDescriptionBuilder> implements VisitableBuilder<WebhookDescription,WebhookDescriptionBuilder>{
  public WebhookDescriptionBuilder() {
    this(false);
  }
  public WebhookDescriptionBuilder(Boolean validationEnabled) {
    this(new WebhookDescription(), validationEnabled);
  }
  public WebhookDescriptionBuilder(WebhookDescriptionFluent<?> fluent) {
    this(fluent, false);
  }
  public WebhookDescriptionBuilder(WebhookDescriptionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new WebhookDescription(), validationEnabled);
  }
  public WebhookDescriptionBuilder(WebhookDescriptionFluent<?> fluent,WebhookDescription instance) {
    this(fluent, instance, false);
  }
  public WebhookDescriptionBuilder(WebhookDescriptionFluent<?> fluent,WebhookDescription instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new WebhookDescription());

    if (instance != null) {
      fluent.withAdmissionReviewVersions(instance.getAdmissionReviewVersions());
      fluent.withContainerPort(instance.getContainerPort());
      fluent.withConversionCRDs(instance.getConversionCRDs());
      fluent.withDeploymentName(instance.getDeploymentName());
      fluent.withFailurePolicy(instance.getFailurePolicy());
      fluent.withGenerateName(instance.getGenerateName());
      fluent.withMatchPolicy(instance.getMatchPolicy());
      fluent.withObjectSelector(instance.getObjectSelector());
      fluent.withReinvocationPolicy(instance.getReinvocationPolicy());
      fluent.withRules(instance.getRules());
      fluent.withSideEffects(instance.getSideEffects());
      fluent.withTargetPort(instance.getTargetPort());
      fluent.withTimeoutSeconds(instance.getTimeoutSeconds());
      fluent.withType(instance.getType());
      fluent.withWebhookPath(instance.getWebhookPath());
      fluent.withAdmissionReviewVersions(instance.getAdmissionReviewVersions());
      fluent.withContainerPort(instance.getContainerPort());
      fluent.withConversionCRDs(instance.getConversionCRDs());
      fluent.withDeploymentName(instance.getDeploymentName());
      fluent.withFailurePolicy(instance.getFailurePolicy());
      fluent.withGenerateName(instance.getGenerateName());
      fluent.withMatchPolicy(instance.getMatchPolicy());
      fluent.withObjectSelector(instance.getObjectSelector());
      fluent.withReinvocationPolicy(instance.getReinvocationPolicy());
      fluent.withRules(instance.getRules());
      fluent.withSideEffects(instance.getSideEffects());
      fluent.withTargetPort(instance.getTargetPort());
      fluent.withTimeoutSeconds(instance.getTimeoutSeconds());
      fluent.withType(instance.getType());
      fluent.withWebhookPath(instance.getWebhookPath());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public WebhookDescriptionBuilder(WebhookDescription instance) {
    this(instance,false);
  }
  public WebhookDescriptionBuilder(WebhookDescription instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new WebhookDescription());

    if (instance != null) {
      this.withAdmissionReviewVersions(instance.getAdmissionReviewVersions());
      this.withContainerPort(instance.getContainerPort());
      this.withConversionCRDs(instance.getConversionCRDs());
      this.withDeploymentName(instance.getDeploymentName());
      this.withFailurePolicy(instance.getFailurePolicy());
      this.withGenerateName(instance.getGenerateName());
      this.withMatchPolicy(instance.getMatchPolicy());
      this.withObjectSelector(instance.getObjectSelector());
      this.withReinvocationPolicy(instance.getReinvocationPolicy());
      this.withRules(instance.getRules());
      this.withSideEffects(instance.getSideEffects());
      this.withTargetPort(instance.getTargetPort());
      this.withTimeoutSeconds(instance.getTimeoutSeconds());
      this.withType(instance.getType());
      this.withWebhookPath(instance.getWebhookPath());
      this.withAdmissionReviewVersions(instance.getAdmissionReviewVersions());
      this.withContainerPort(instance.getContainerPort());
      this.withConversionCRDs(instance.getConversionCRDs());
      this.withDeploymentName(instance.getDeploymentName());
      this.withFailurePolicy(instance.getFailurePolicy());
      this.withGenerateName(instance.getGenerateName());
      this.withMatchPolicy(instance.getMatchPolicy());
      this.withObjectSelector(instance.getObjectSelector());
      this.withReinvocationPolicy(instance.getReinvocationPolicy());
      this.withRules(instance.getRules());
      this.withSideEffects(instance.getSideEffects());
      this.withTargetPort(instance.getTargetPort());
      this.withTimeoutSeconds(instance.getTimeoutSeconds());
      this.withType(instance.getType());
      this.withWebhookPath(instance.getWebhookPath());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  WebhookDescriptionFluent<?> fluent;
  Boolean validationEnabled;
  public WebhookDescription build() {
    WebhookDescription buildable = new WebhookDescription(fluent.getAdmissionReviewVersions(),fluent.getContainerPort(),fluent.getConversionCRDs(),fluent.getDeploymentName(),fluent.getFailurePolicy(),fluent.getGenerateName(),fluent.getMatchPolicy(),fluent.buildObjectSelector(),fluent.getReinvocationPolicy(),fluent.getRules(),fluent.getSideEffects(),fluent.buildTargetPort(),fluent.getTimeoutSeconds(),fluent.getType(),fluent.getWebhookPath());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}