package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.EnvVar;
import java.util.List;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.EnvFromSource;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.Toleration;
import java.lang.Long;
import io.fabric8.kubernetes.api.model.Affinity;
import io.fabric8.kubernetes.api.model.VolumeMount;
import java.util.Collection;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class SubscriptionConfigFluent<A extends SubscriptionConfigFluent<A>> extends BaseFluent<A>{
  public SubscriptionConfigFluent() {
  }
  
  public SubscriptionConfigFluent(SubscriptionConfig instance) {
    this.copyInstance(instance);
  }
  private Affinity affinity;
  private List<EnvVar> env = new ArrayList<EnvVar>();
  private List<EnvFromSource> envFrom = new ArrayList<EnvFromSource>();
  private Map<String,String> nodeSelector;
  private ResourceRequirementsBuilder resources;
  private LabelSelectorBuilder selector;
  private List<Toleration> tolerations = new ArrayList<Toleration>();
  private List<VolumeMount> volumeMounts = new ArrayList<VolumeMount>();
  private List<Volume> volumes = new ArrayList<Volume>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(SubscriptionConfig instance) {
    instance = (instance != null ? instance : new SubscriptionConfig());
    if (instance != null) {
          this.withAffinity(instance.getAffinity());
          this.withEnv(instance.getEnv());
          this.withEnvFrom(instance.getEnvFrom());
          this.withNodeSelector(instance.getNodeSelector());
          this.withResources(instance.getResources());
          this.withSelector(instance.getSelector());
          this.withTolerations(instance.getTolerations());
          this.withVolumeMounts(instance.getVolumeMounts());
          this.withVolumes(instance.getVolumes());
          this.withAffinity(instance.getAffinity());
          this.withEnv(instance.getEnv());
          this.withEnvFrom(instance.getEnvFrom());
          this.withNodeSelector(instance.getNodeSelector());
          this.withResources(instance.getResources());
          this.withSelector(instance.getSelector());
          this.withTolerations(instance.getTolerations());
          this.withVolumeMounts(instance.getVolumeMounts());
          this.withVolumes(instance.getVolumes());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public Affinity getAffinity() {
    return this.affinity;
  }
  
  public A withAffinity(Affinity affinity) {
    this.affinity = affinity;
    return (A) this;
  }
  
  public boolean hasAffinity() {
    return this.affinity != null;
  }
  
  public A addToEnv(int index,EnvVar item) {
    if (this.env == null) {this.env = new ArrayList<EnvVar>();}
    this.env.add(index, item);
    return (A)this;
  }
  
  public A setToEnv(int index,EnvVar item) {
    if (this.env == null) {this.env = new ArrayList<EnvVar>();}
    this.env.set(index, item); return (A)this;
  }
  
  public A addToEnv(io.fabric8.kubernetes.api.model.EnvVar... items) {
    if (this.env == null) {this.env = new ArrayList<EnvVar>();}
    for (EnvVar item : items) {this.env.add(item);} return (A)this;
  }
  
  public A addAllToEnv(Collection<EnvVar> items) {
    if (this.env == null) {this.env = new ArrayList<EnvVar>();}
    for (EnvVar item : items) {this.env.add(item);} return (A)this;
  }
  
  public A removeFromEnv(io.fabric8.kubernetes.api.model.EnvVar... items) {
    if (this.env == null) return (A)this;
    for (EnvVar item : items) { this.env.remove(item);} return (A)this;
  }
  
  public A removeAllFromEnv(Collection<EnvVar> items) {
    if (this.env == null) return (A)this;
    for (EnvVar item : items) { this.env.remove(item);} return (A)this;
  }
  
  public List<EnvVar> getEnv() {
    return this.env;
  }
  
  public EnvVar getEnv(int index) {
    return this.env.get(index);
  }
  
  public EnvVar getFirstEnv() {
    return this.env.get(0);
  }
  
  public EnvVar getLastEnv() {
    return this.env.get(env.size() - 1);
  }
  
  public EnvVar getMatchingEnv(Predicate<EnvVar> predicate) {
      for (EnvVar item : env) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingEnv(Predicate<EnvVar> predicate) {
      for (EnvVar item : env) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withEnv(List<EnvVar> env) {
    if (env != null) {
        this.env = new ArrayList();
        for (EnvVar item : env) {
          this.addToEnv(item);
        }
    } else {
      this.env = null;
    }
    return (A) this;
  }
  
  public A withEnv(io.fabric8.kubernetes.api.model.EnvVar... env) {
    if (this.env != null) {this.env.clear(); _visitables.remove("env"); }
    if (env != null) {for (EnvVar item :env){ this.addToEnv(item);}} return (A) this;
  }
  
  public boolean hasEnv() {
    return this.env != null && !this.env.isEmpty();
  }
  
  public A addToEnvFrom(int index,EnvFromSource item) {
    if (this.envFrom == null) {this.envFrom = new ArrayList<EnvFromSource>();}
    this.envFrom.add(index, item);
    return (A)this;
  }
  
  public A setToEnvFrom(int index,EnvFromSource item) {
    if (this.envFrom == null) {this.envFrom = new ArrayList<EnvFromSource>();}
    this.envFrom.set(index, item); return (A)this;
  }
  
  public A addToEnvFrom(io.fabric8.kubernetes.api.model.EnvFromSource... items) {
    if (this.envFrom == null) {this.envFrom = new ArrayList<EnvFromSource>();}
    for (EnvFromSource item : items) {this.envFrom.add(item);} return (A)this;
  }
  
  public A addAllToEnvFrom(Collection<EnvFromSource> items) {
    if (this.envFrom == null) {this.envFrom = new ArrayList<EnvFromSource>();}
    for (EnvFromSource item : items) {this.envFrom.add(item);} return (A)this;
  }
  
  public A removeFromEnvFrom(io.fabric8.kubernetes.api.model.EnvFromSource... items) {
    if (this.envFrom == null) return (A)this;
    for (EnvFromSource item : items) { this.envFrom.remove(item);} return (A)this;
  }
  
  public A removeAllFromEnvFrom(Collection<EnvFromSource> items) {
    if (this.envFrom == null) return (A)this;
    for (EnvFromSource item : items) { this.envFrom.remove(item);} return (A)this;
  }
  
  public List<EnvFromSource> getEnvFrom() {
    return this.envFrom;
  }
  
  public EnvFromSource getEnvFrom(int index) {
    return this.envFrom.get(index);
  }
  
  public EnvFromSource getFirstEnvFrom() {
    return this.envFrom.get(0);
  }
  
  public EnvFromSource getLastEnvFrom() {
    return this.envFrom.get(envFrom.size() - 1);
  }
  
  public EnvFromSource getMatchingEnvFrom(Predicate<EnvFromSource> predicate) {
      for (EnvFromSource item : envFrom) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingEnvFrom(Predicate<EnvFromSource> predicate) {
      for (EnvFromSource item : envFrom) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withEnvFrom(List<EnvFromSource> envFrom) {
    if (envFrom != null) {
        this.envFrom = new ArrayList();
        for (EnvFromSource item : envFrom) {
          this.addToEnvFrom(item);
        }
    } else {
      this.envFrom = null;
    }
    return (A) this;
  }
  
  public A withEnvFrom(io.fabric8.kubernetes.api.model.EnvFromSource... envFrom) {
    if (this.envFrom != null) {this.envFrom.clear(); _visitables.remove("envFrom"); }
    if (envFrom != null) {for (EnvFromSource item :envFrom){ this.addToEnvFrom(item);}} return (A) this;
  }
  
  public boolean hasEnvFrom() {
    return this.envFrom != null && !this.envFrom.isEmpty();
  }
  
  public A addToNodeSelector(String key,String value) {
    if(this.nodeSelector == null && key != null && value != null) { this.nodeSelector = new LinkedHashMap(); }
    if(key != null && value != null) {this.nodeSelector.put(key, value);} return (A)this;
  }
  
  public A addToNodeSelector(Map<String,String> map) {
    if(this.nodeSelector == null && map != null) { this.nodeSelector = new LinkedHashMap(); }
    if(map != null) { this.nodeSelector.putAll(map);} return (A)this;
  }
  
  public A removeFromNodeSelector(String key) {
    if(this.nodeSelector == null) { return (A) this; }
    if(key != null && this.nodeSelector != null) {this.nodeSelector.remove(key);} return (A)this;
  }
  
  public A removeFromNodeSelector(Map<String,String> map) {
    if(this.nodeSelector == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.nodeSelector != null){this.nodeSelector.remove(key);}}} return (A)this;
  }
  
  public Map<String,String> getNodeSelector() {
    return this.nodeSelector;
  }
  
  public <K,V>A withNodeSelector(Map<String,String> nodeSelector) {
    if (nodeSelector == null) {
      this.nodeSelector = null;
    } else {
      this.nodeSelector = new LinkedHashMap(nodeSelector);
    }
    return (A) this;
  }
  
  public boolean hasNodeSelector() {
    return this.nodeSelector != null;
  }
  
  public ResourceRequirements buildResources() {
    return this.resources != null ? this.resources.build() : null;
  }
  
  public A withResources(ResourceRequirements resources) {
    this._visitables.remove(this.resources);
    if (resources != null) {
        this.resources = new ResourceRequirementsBuilder(resources);
        this._visitables.get("resources").add(this.resources);
    } else {
        this.resources = null;
        this._visitables.get("resources").remove(this.resources);
    }
    return (A) this;
  }
  
  public boolean hasResources() {
    return this.resources != null;
  }
  
  public ResourcesNested<A> withNewResources() {
    return new ResourcesNested(null);
  }
  
  public ResourcesNested<A> withNewResourcesLike(ResourceRequirements item) {
    return new ResourcesNested(item);
  }
  
  public ResourcesNested<A> editResources() {
    return withNewResourcesLike(java.util.Optional.ofNullable(buildResources()).orElse(null));
  }
  
  public ResourcesNested<A> editOrNewResources() {
    return withNewResourcesLike(java.util.Optional.ofNullable(buildResources()).orElse(new ResourceRequirementsBuilder().build()));
  }
  
  public ResourcesNested<A> editOrNewResourcesLike(ResourceRequirements item) {
    return withNewResourcesLike(java.util.Optional.ofNullable(buildResources()).orElse(item));
  }
  
  public LabelSelector buildSelector() {
    return this.selector != null ? this.selector.build() : null;
  }
  
  public A withSelector(LabelSelector selector) {
    this._visitables.remove(this.selector);
    if (selector != null) {
        this.selector = new LabelSelectorBuilder(selector);
        this._visitables.get("selector").add(this.selector);
    } else {
        this.selector = null;
        this._visitables.get("selector").remove(this.selector);
    }
    return (A) this;
  }
  
  public boolean hasSelector() {
    return this.selector != null;
  }
  
  public SelectorNested<A> withNewSelector() {
    return new SelectorNested(null);
  }
  
  public SelectorNested<A> withNewSelectorLike(LabelSelector item) {
    return new SelectorNested(item);
  }
  
  public SelectorNested<A> editSelector() {
    return withNewSelectorLike(java.util.Optional.ofNullable(buildSelector()).orElse(null));
  }
  
  public SelectorNested<A> editOrNewSelector() {
    return withNewSelectorLike(java.util.Optional.ofNullable(buildSelector()).orElse(new LabelSelectorBuilder().build()));
  }
  
  public SelectorNested<A> editOrNewSelectorLike(LabelSelector item) {
    return withNewSelectorLike(java.util.Optional.ofNullable(buildSelector()).orElse(item));
  }
  
  public A addToTolerations(int index,Toleration item) {
    if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
    this.tolerations.add(index, item);
    return (A)this;
  }
  
  public A setToTolerations(int index,Toleration item) {
    if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
    this.tolerations.set(index, item); return (A)this;
  }
  
  public A addToTolerations(io.fabric8.kubernetes.api.model.Toleration... items) {
    if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
    for (Toleration item : items) {this.tolerations.add(item);} return (A)this;
  }
  
  public A addAllToTolerations(Collection<Toleration> items) {
    if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
    for (Toleration item : items) {this.tolerations.add(item);} return (A)this;
  }
  
  public A removeFromTolerations(io.fabric8.kubernetes.api.model.Toleration... items) {
    if (this.tolerations == null) return (A)this;
    for (Toleration item : items) { this.tolerations.remove(item);} return (A)this;
  }
  
  public A removeAllFromTolerations(Collection<Toleration> items) {
    if (this.tolerations == null) return (A)this;
    for (Toleration item : items) { this.tolerations.remove(item);} return (A)this;
  }
  
  public List<Toleration> getTolerations() {
    return this.tolerations;
  }
  
  public Toleration getToleration(int index) {
    return this.tolerations.get(index);
  }
  
  public Toleration getFirstToleration() {
    return this.tolerations.get(0);
  }
  
  public Toleration getLastToleration() {
    return this.tolerations.get(tolerations.size() - 1);
  }
  
  public Toleration getMatchingToleration(Predicate<Toleration> predicate) {
      for (Toleration item : tolerations) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingToleration(Predicate<Toleration> predicate) {
      for (Toleration item : tolerations) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withTolerations(List<Toleration> tolerations) {
    if (tolerations != null) {
        this.tolerations = new ArrayList();
        for (Toleration item : tolerations) {
          this.addToTolerations(item);
        }
    } else {
      this.tolerations = null;
    }
    return (A) this;
  }
  
  public A withTolerations(io.fabric8.kubernetes.api.model.Toleration... tolerations) {
    if (this.tolerations != null) {this.tolerations.clear(); _visitables.remove("tolerations"); }
    if (tolerations != null) {for (Toleration item :tolerations){ this.addToTolerations(item);}} return (A) this;
  }
  
  public boolean hasTolerations() {
    return this.tolerations != null && !this.tolerations.isEmpty();
  }
  
  public A addNewToleration(String effect,String key,String operator,Long tolerationSeconds,String value) {
    return (A)addToTolerations(new Toleration(effect, key, operator, tolerationSeconds, value));
  }
  
  public A addToVolumeMounts(int index,VolumeMount item) {
    if (this.volumeMounts == null) {this.volumeMounts = new ArrayList<VolumeMount>();}
    this.volumeMounts.add(index, item);
    return (A)this;
  }
  
  public A setToVolumeMounts(int index,VolumeMount item) {
    if (this.volumeMounts == null) {this.volumeMounts = new ArrayList<VolumeMount>();}
    this.volumeMounts.set(index, item); return (A)this;
  }
  
  public A addToVolumeMounts(io.fabric8.kubernetes.api.model.VolumeMount... items) {
    if (this.volumeMounts == null) {this.volumeMounts = new ArrayList<VolumeMount>();}
    for (VolumeMount item : items) {this.volumeMounts.add(item);} return (A)this;
  }
  
  public A addAllToVolumeMounts(Collection<VolumeMount> items) {
    if (this.volumeMounts == null) {this.volumeMounts = new ArrayList<VolumeMount>();}
    for (VolumeMount item : items) {this.volumeMounts.add(item);} return (A)this;
  }
  
  public A removeFromVolumeMounts(io.fabric8.kubernetes.api.model.VolumeMount... items) {
    if (this.volumeMounts == null) return (A)this;
    for (VolumeMount item : items) { this.volumeMounts.remove(item);} return (A)this;
  }
  
  public A removeAllFromVolumeMounts(Collection<VolumeMount> items) {
    if (this.volumeMounts == null) return (A)this;
    for (VolumeMount item : items) { this.volumeMounts.remove(item);} return (A)this;
  }
  
  public List<VolumeMount> getVolumeMounts() {
    return this.volumeMounts;
  }
  
  public VolumeMount getVolumeMount(int index) {
    return this.volumeMounts.get(index);
  }
  
  public VolumeMount getFirstVolumeMount() {
    return this.volumeMounts.get(0);
  }
  
  public VolumeMount getLastVolumeMount() {
    return this.volumeMounts.get(volumeMounts.size() - 1);
  }
  
  public VolumeMount getMatchingVolumeMount(Predicate<VolumeMount> predicate) {
      for (VolumeMount item : volumeMounts) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingVolumeMount(Predicate<VolumeMount> predicate) {
      for (VolumeMount item : volumeMounts) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withVolumeMounts(List<VolumeMount> volumeMounts) {
    if (volumeMounts != null) {
        this.volumeMounts = new ArrayList();
        for (VolumeMount item : volumeMounts) {
          this.addToVolumeMounts(item);
        }
    } else {
      this.volumeMounts = null;
    }
    return (A) this;
  }
  
  public A withVolumeMounts(io.fabric8.kubernetes.api.model.VolumeMount... volumeMounts) {
    if (this.volumeMounts != null) {this.volumeMounts.clear(); _visitables.remove("volumeMounts"); }
    if (volumeMounts != null) {for (VolumeMount item :volumeMounts){ this.addToVolumeMounts(item);}} return (A) this;
  }
  
  public boolean hasVolumeMounts() {
    return this.volumeMounts != null && !this.volumeMounts.isEmpty();
  }
  
  public A addToVolumes(int index,Volume item) {
    if (this.volumes == null) {this.volumes = new ArrayList<Volume>();}
    this.volumes.add(index, item);
    return (A)this;
  }
  
  public A setToVolumes(int index,Volume item) {
    if (this.volumes == null) {this.volumes = new ArrayList<Volume>();}
    this.volumes.set(index, item); return (A)this;
  }
  
  public A addToVolumes(io.fabric8.kubernetes.api.model.Volume... items) {
    if (this.volumes == null) {this.volumes = new ArrayList<Volume>();}
    for (Volume item : items) {this.volumes.add(item);} return (A)this;
  }
  
  public A addAllToVolumes(Collection<Volume> items) {
    if (this.volumes == null) {this.volumes = new ArrayList<Volume>();}
    for (Volume item : items) {this.volumes.add(item);} return (A)this;
  }
  
  public A removeFromVolumes(io.fabric8.kubernetes.api.model.Volume... items) {
    if (this.volumes == null) return (A)this;
    for (Volume item : items) { this.volumes.remove(item);} return (A)this;
  }
  
  public A removeAllFromVolumes(Collection<Volume> items) {
    if (this.volumes == null) return (A)this;
    for (Volume item : items) { this.volumes.remove(item);} return (A)this;
  }
  
  public List<Volume> getVolumes() {
    return this.volumes;
  }
  
  public Volume getVolume(int index) {
    return this.volumes.get(index);
  }
  
  public Volume getFirstVolume() {
    return this.volumes.get(0);
  }
  
  public Volume getLastVolume() {
    return this.volumes.get(volumes.size() - 1);
  }
  
  public Volume getMatchingVolume(Predicate<Volume> predicate) {
      for (Volume item : volumes) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingVolume(Predicate<Volume> predicate) {
      for (Volume item : volumes) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withVolumes(List<Volume> volumes) {
    if (volumes != null) {
        this.volumes = new ArrayList();
        for (Volume item : volumes) {
          this.addToVolumes(item);
        }
    } else {
      this.volumes = null;
    }
    return (A) this;
  }
  
  public A withVolumes(io.fabric8.kubernetes.api.model.Volume... volumes) {
    if (this.volumes != null) {this.volumes.clear(); _visitables.remove("volumes"); }
    if (volumes != null) {for (Volume item :volumes){ this.addToVolumes(item);}} return (A) this;
  }
  
  public boolean hasVolumes() {
    return this.volumes != null && !this.volumes.isEmpty();
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    SubscriptionConfigFluent that = (SubscriptionConfigFluent) o;
    if (!java.util.Objects.equals(affinity, that.affinity)) return false;
    if (!java.util.Objects.equals(env, that.env)) return false;
    if (!java.util.Objects.equals(envFrom, that.envFrom)) return false;
    if (!java.util.Objects.equals(nodeSelector, that.nodeSelector)) return false;
    if (!java.util.Objects.equals(resources, that.resources)) return false;
    if (!java.util.Objects.equals(selector, that.selector)) return false;
    if (!java.util.Objects.equals(tolerations, that.tolerations)) return false;
    if (!java.util.Objects.equals(volumeMounts, that.volumeMounts)) return false;
    if (!java.util.Objects.equals(volumes, that.volumes)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(affinity,  env,  envFrom,  nodeSelector,  resources,  selector,  tolerations,  volumeMounts,  volumes,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (affinity != null) { sb.append("affinity:"); sb.append(affinity + ","); }
    if (env != null && !env.isEmpty()) { sb.append("env:"); sb.append(env + ","); }
    if (envFrom != null && !envFrom.isEmpty()) { sb.append("envFrom:"); sb.append(envFrom + ","); }
    if (nodeSelector != null && !nodeSelector.isEmpty()) { sb.append("nodeSelector:"); sb.append(nodeSelector + ","); }
    if (resources != null) { sb.append("resources:"); sb.append(resources + ","); }
    if (selector != null) { sb.append("selector:"); sb.append(selector + ","); }
    if (tolerations != null && !tolerations.isEmpty()) { sb.append("tolerations:"); sb.append(tolerations + ","); }
    if (volumeMounts != null && !volumeMounts.isEmpty()) { sb.append("volumeMounts:"); sb.append(volumeMounts + ","); }
    if (volumes != null && !volumes.isEmpty()) { sb.append("volumes:"); sb.append(volumes + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ResourcesNested<N> extends ResourceRequirementsFluent<ResourcesNested<N>> implements Nested<N>{
    ResourcesNested(ResourceRequirements item) {
      this.builder = new ResourceRequirementsBuilder(this, item);
    }
    ResourceRequirementsBuilder builder;
    
    public N and() {
      return (N) SubscriptionConfigFluent.this.withResources(builder.build());
    }
    
    public N endResources() {
      return and();
    }
    
  
  }
  public class SelectorNested<N> extends LabelSelectorFluent<SelectorNested<N>> implements Nested<N>{
    SelectorNested(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    LabelSelectorBuilder builder;
    
    public N and() {
      return (N) SubscriptionConfigFluent.this.withSelector(builder.build());
    }
    
    public N endSelector() {
      return and();
    }
    
  
  }

}