/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operatorhub.v1;

import com.fasterxml.jackson.databind.JsonNode;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import io.fabric8.openshift.api.model.operatorhub.v1.Components;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ComponentsFluent<A extends ComponentsFluent<A>>
extends BaseFluent<A> {
    private LabelSelectorBuilder labelSelector;
    private List<JsonNode> refs = new ArrayList<JsonNode>();
    private Map<String, Object> additionalProperties;

    public ComponentsFluent() {
    }

    public ComponentsFluent(Components instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Components instance) {
        Components components = instance = instance != null ? instance : new Components();
        if (instance != null) {
            this.withLabelSelector(instance.getLabelSelector());
            this.withRefs(instance.getRefs());
            this.withLabelSelector(instance.getLabelSelector());
            this.withRefs(instance.getRefs());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public LabelSelector buildLabelSelector() {
        return this.labelSelector != null ? this.labelSelector.build() : null;
    }

    public A withLabelSelector(LabelSelector labelSelector) {
        this._visitables.remove((Object)this.labelSelector);
        if (labelSelector != null) {
            this.labelSelector = new LabelSelectorBuilder(labelSelector);
            this._visitables.get((Object)"labelSelector").add(this.labelSelector);
        } else {
            this.labelSelector = null;
            this._visitables.get((Object)"labelSelector").remove(this.labelSelector);
        }
        return (A)((Object)this);
    }

    public boolean hasLabelSelector() {
        return this.labelSelector != null;
    }

    public LabelSelectorNested<A> withNewLabelSelector() {
        return new LabelSelectorNested(null);
    }

    public LabelSelectorNested<A> withNewLabelSelectorLike(LabelSelector item) {
        return new LabelSelectorNested(item);
    }

    public LabelSelectorNested<A> editLabelSelector() {
        return this.withNewLabelSelectorLike(Optional.ofNullable(this.buildLabelSelector()).orElse(null));
    }

    public LabelSelectorNested<A> editOrNewLabelSelector() {
        return this.withNewLabelSelectorLike(Optional.ofNullable(this.buildLabelSelector()).orElse(new LabelSelectorBuilder().build()));
    }

    public LabelSelectorNested<A> editOrNewLabelSelectorLike(LabelSelector item) {
        return this.withNewLabelSelectorLike(Optional.ofNullable(this.buildLabelSelector()).orElse(item));
    }

    public A addToRefs(int index, JsonNode item) {
        if (this.refs == null) {
            this.refs = new ArrayList<JsonNode>();
        }
        this.refs.add(index, item);
        return (A)((Object)this);
    }

    public A setToRefs(int index, JsonNode item) {
        if (this.refs == null) {
            this.refs = new ArrayList<JsonNode>();
        }
        this.refs.set(index, item);
        return (A)((Object)this);
    }

    public A addToRefs(JsonNode ... items) {
        if (this.refs == null) {
            this.refs = new ArrayList<JsonNode>();
        }
        for (JsonNode item : items) {
            this.refs.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToRefs(Collection<JsonNode> items) {
        if (this.refs == null) {
            this.refs = new ArrayList<JsonNode>();
        }
        for (JsonNode item : items) {
            this.refs.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromRefs(JsonNode ... items) {
        if (this.refs == null) {
            return (A)((Object)this);
        }
        for (JsonNode item : items) {
            this.refs.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromRefs(Collection<JsonNode> items) {
        if (this.refs == null) {
            return (A)((Object)this);
        }
        for (JsonNode item : items) {
            this.refs.remove(item);
        }
        return (A)((Object)this);
    }

    public List<JsonNode> getRefs() {
        return this.refs;
    }

    public JsonNode getRef(int index) {
        return this.refs.get(index);
    }

    public JsonNode getFirstRef() {
        return this.refs.get(0);
    }

    public JsonNode getLastRef() {
        return this.refs.get(this.refs.size() - 1);
    }

    public JsonNode getMatchingRef(Predicate<JsonNode> predicate) {
        for (JsonNode item : this.refs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingRef(Predicate<JsonNode> predicate) {
        for (JsonNode item : this.refs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withRefs(List<JsonNode> refs) {
        if (refs != null) {
            this.refs = new ArrayList<JsonNode>();
            for (JsonNode item : refs) {
                this.addToRefs(item);
            }
        } else {
            this.refs = null;
        }
        return (A)((Object)this);
    }

    public A withRefs(JsonNode ... refs) {
        if (this.refs != null) {
            this.refs.clear();
            this._visitables.remove((Object)"refs");
        }
        if (refs != null) {
            for (JsonNode item : refs) {
                this.addToRefs(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasRefs() {
        return this.refs != null && !this.refs.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ComponentsFluent that = (ComponentsFluent)((Object)o);
        if (!Objects.equals(this.labelSelector, that.labelSelector)) {
            return false;
        }
        if (!Objects.equals(this.refs, that.refs)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.labelSelector, this.refs, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.labelSelector != null) {
            sb.append("labelSelector:");
            sb.append(this.labelSelector + ",");
        }
        if (this.refs != null && !this.refs.isEmpty()) {
            sb.append("refs:");
            sb.append(this.refs + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class LabelSelectorNested<N>
    extends LabelSelectorFluent<LabelSelectorNested<N>>
    implements Nested<N> {
        LabelSelectorBuilder builder;

        LabelSelectorNested(LabelSelector item) {
            this.builder = new LabelSelectorBuilder((LabelSelectorFluent)this, item);
        }

        public N and() {
            return (N)ComponentsFluent.this.withLabelSelector(this.builder.build());
        }

        public N endLabelSelector() {
            return this.and();
        }
    }
}

