package io.fabric8.openshift.api.model.tuned.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class TunedMatchBuilder extends io.fabric8.openshift.api.model.tuned.v1.TunedMatchFluentImpl<io.fabric8.openshift.api.model.tuned.v1.TunedMatchBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.tuned.v1.TunedMatch,io.fabric8.openshift.api.model.tuned.v1.TunedMatchBuilder>{
  public TunedMatchBuilder() {
    this(false);
  }
  public TunedMatchBuilder(java.lang.Boolean validationEnabled) {
    this(new TunedMatch(), validationEnabled);
  }
  public TunedMatchBuilder(io.fabric8.openshift.api.model.tuned.v1.TunedMatchFluent<?> fluent) {
    this(fluent, false);
  }
  public TunedMatchBuilder(io.fabric8.openshift.api.model.tuned.v1.TunedMatchFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new TunedMatch(), validationEnabled);
  }
  public TunedMatchBuilder(io.fabric8.openshift.api.model.tuned.v1.TunedMatchFluent<?> fluent,io.fabric8.openshift.api.model.tuned.v1.TunedMatch instance) {
    this(fluent, instance, false);
  }
  public TunedMatchBuilder(io.fabric8.openshift.api.model.tuned.v1.TunedMatchFluent<?> fluent,io.fabric8.openshift.api.model.tuned.v1.TunedMatch instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withLabel(instance.getLabel()); 
    fluent.withMatch(instance.getMatch()); 
    fluent.withType(instance.getType()); 
    fluent.withValue(instance.getValue()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public TunedMatchBuilder(io.fabric8.openshift.api.model.tuned.v1.TunedMatch instance) {
    this(instance,false);
  }
  public TunedMatchBuilder(io.fabric8.openshift.api.model.tuned.v1.TunedMatch instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withLabel(instance.getLabel()); 
    this.withMatch(instance.getMatch()); 
    this.withType(instance.getType()); 
    this.withValue(instance.getValue()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.tuned.v1.TunedMatchFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.tuned.v1.TunedMatch build() {
    TunedMatch buildable = new TunedMatch(fluent.getLabel(),fluent.getMatch(),fluent.getType(),fluent.getValue());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    TunedMatchBuilder that = (TunedMatchBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}