package io.fabric8.openshift.api.model.tuned.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class TunedRecommendBuilder extends io.fabric8.openshift.api.model.tuned.v1.TunedRecommendFluentImpl<io.fabric8.openshift.api.model.tuned.v1.TunedRecommendBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.tuned.v1.TunedRecommend,io.fabric8.openshift.api.model.tuned.v1.TunedRecommendBuilder>{
  public TunedRecommendBuilder() {
    this(false);
  }
  public TunedRecommendBuilder(java.lang.Boolean validationEnabled) {
    this(new TunedRecommend(), validationEnabled);
  }
  public TunedRecommendBuilder(io.fabric8.openshift.api.model.tuned.v1.TunedRecommendFluent<?> fluent) {
    this(fluent, false);
  }
  public TunedRecommendBuilder(io.fabric8.openshift.api.model.tuned.v1.TunedRecommendFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new TunedRecommend(), validationEnabled);
  }
  public TunedRecommendBuilder(io.fabric8.openshift.api.model.tuned.v1.TunedRecommendFluent<?> fluent,io.fabric8.openshift.api.model.tuned.v1.TunedRecommend instance) {
    this(fluent, instance, false);
  }
  public TunedRecommendBuilder(io.fabric8.openshift.api.model.tuned.v1.TunedRecommendFluent<?> fluent,io.fabric8.openshift.api.model.tuned.v1.TunedRecommend instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withMachineConfigLabels(instance.getMachineConfigLabels()); 
    fluent.withMatch(instance.getMatch()); 
    fluent.withOperand(instance.getOperand()); 
    fluent.withPriority(instance.getPriority()); 
    fluent.withProfile(instance.getProfile()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public TunedRecommendBuilder(io.fabric8.openshift.api.model.tuned.v1.TunedRecommend instance) {
    this(instance,false);
  }
  public TunedRecommendBuilder(io.fabric8.openshift.api.model.tuned.v1.TunedRecommend instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withMachineConfigLabels(instance.getMachineConfigLabels()); 
    this.withMatch(instance.getMatch()); 
    this.withOperand(instance.getOperand()); 
    this.withPriority(instance.getPriority()); 
    this.withProfile(instance.getProfile()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.tuned.v1.TunedRecommendFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.tuned.v1.TunedRecommend build() {
    TunedRecommend buildable = new TunedRecommend(fluent.getMachineConfigLabels(),fluent.getMatch(),fluent.getOperand(),fluent.getPriority(),fluent.getProfile());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    TunedRecommendBuilder that = (TunedRecommendBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}